/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderthing.blocks;

import gigaherz.enderthing.storage.EnderInventory;
import gigaherz.enderthing.storage.InventoryManager;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.ObjectHolder;

public class EnderKeyChestTileEntity
extends TileEntity
implements IChestLid,
ITickableTileEntity {
    @ObjectHolder(value="enderthing:key_chest")
    public static TileEntityType<EnderKeyChestTileEntity> TYPE;
    private long key = -1L;
    private int ticksSinceSync;
    private UUID boundToPlayer;
    private EnderInventory inventory;
    private boolean priv;
    private LazyOptional<IItemHandler> inventoryLazy = LazyOptional.of(this::getInventory);
    public float lidAngle;
    public float prevLidAngle;
    public int numPlayersUsing;

    protected EnderKeyChestTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public EnderKeyChestTileEntity() {
        super(TYPE);
    }

    public boolean isPrivate() {
        return this.priv;
    }

    public void setPrivate(boolean p) {
        if (this.priv != p) {
            this.priv = p;
            if (!p && this.isBoundToPlayer()) {
                this.boundToPlayer = null;
            }
            this.invalidateInventory();
        }
    }

    public long getKey() {
        return this.key;
    }

    public void setKey(long key) {
        if (key != this.key) {
            this.key = key;
            this.invalidateInventory();
        }
    }

    @Nullable
    public UUID getPlayerBound() {
        return this.boundToPlayer;
    }

    public void bindToPlayer(@Nullable UUID boundToPlayer) {
        if (!this.isPrivate()) {
            return;
        }
        if (boundToPlayer != this.boundToPlayer) {
            this.boundToPlayer = boundToPlayer;
            this.invalidateInventory();
        }
    }

    private void invalidateInventory() {
        this.inventoryLazy.invalidate();
        this.inventoryLazy = LazyOptional.of(this::getInventory);
        this.releasePreviousInventory();
        this.func_70296_d();
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public boolean isBoundToPlayer() {
        return this.boundToPlayer != null;
    }

    private void releasePreviousInventory() {
        if (this.inventory != null) {
            this.inventory.removeWeakListener(this);
        }
        this.inventory = null;
    }

    public boolean hasInventory() {
        return this.key >= 0L && (!this.isPrivate() || this.isBoundToPlayer());
    }

    @Nonnull
    public IItemHandlerModifiable getInventory() {
        if (this.field_145850_b != null && this.inventory == null && this.hasInventory()) {
            this.inventory = this.isBoundToPlayer() ? InventoryManager.get(this.field_145850_b).getPrivate(this.boundToPlayer).getInventory(this.key) : InventoryManager.get(this.field_145850_b).getInventory(this.key);
            this.inventory.addWeakListener(this);
        }
        return this.inventory;
    }

    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.key = tag.func_74763_f("Key");
        this.priv = tag.func_74767_n("IsPrivate");
        if (this.isPrivate() && tag.func_150297_b("Bound", 8)) {
            this.boundToPlayer = UUID.fromString(tag.func_74779_i("Bound"));
        }
        this.releasePreviousInventory();
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        tag.func_74772_a("Key", this.key);
        tag.func_74757_a("IsPrivate", this.priv);
        if (this.isPrivate() && this.boundToPlayer != null) {
            tag.func_74778_a("Bound", this.boundToPlayer.toString());
        }
        return tag;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.hasInventory()) {
            return this.inventoryLazy.cast();
        }
        return super.getCapability(capability, facing);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void handleUpdateTag(CompoundNBT tag) {
        this.func_145839_a(tag);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        super.onDataPacket(net, packet);
        this.handleUpdateTag(packet.func_148857_g());
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public boolean canRenderBreaking() {
        return true;
    }

    public void func_73660_a() {
        if (++this.ticksSinceSync % 80 != 0 || !this.field_145850_b.field_72995_K) {
            // empty if block
        }
        this.prevLidAngle = this.lidAngle;
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        float f = 0.1f;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            this.field_145850_b.func_184148_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, SoundEvents.field_187520_aJ, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float closedThreshold;
            float prevAngle = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += f) : (this.lidAngle -= f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (closedThreshold = 0.5f) && prevAngle >= closedThreshold) {
                this.field_145850_b.func_184148_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, SoundEvents.field_187519_aI, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public void receiveUpdate(int id, int value) {
        if (id == 1) {
            this.numPlayersUsing = value;
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void func_145843_s() {
        this.func_145836_u();
        super.func_145843_s();
    }

    public void openChest() {
        ++this.numPlayersUsing;
        this.field_145850_b.func_175641_c(this.field_174879_c, Blocks.field_150477_bB, 1, this.numPlayersUsing);
    }

    public void closeChest() {
        --this.numPlayersUsing;
        this.field_145850_b.func_175641_c(this.field_174879_c, Blocks.field_150477_bB, 1, this.numPlayersUsing);
    }

    public boolean canBeUsed(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return !(player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) > 64.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_195480_a(float partialTicks) {
        return this.prevLidAngle + (this.lidAngle - this.prevLidAngle) * partialTicks;
    }
}

