/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderthing.gui;

import gigaherz.enderthing.blocks.EnderKeyChestTileEntity;
import gigaherz.enderthing.gui.KeyContainer;
import gigaherz.enderthing.gui.PasscodeContainer;
import gigaherz.enderthing.util.ILongAccessor;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.IContainerProvider;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkHooks;

public class Containers {
    private static final String GLOBAL_TITLE = "container.enderthing.global";
    private static final String PRIVATE_TITLE = "container.enderthing.private";
    private static final String CODE_TITLE = "container.enderthing.passcode";

    private static ITextComponent getDisplayName(boolean priv) {
        return new TranslationTextComponent(priv ? PRIVATE_TITLE : GLOBAL_TITLE, new Object[0]);
    }

    public static void openBlockGui(ServerPlayerEntity player, EnderKeyChestTileEntity chest) {
        Containers.openGui(player, chest.isPrivate(), -1, (id, inv, p) -> new KeyContainer(id, inv, chest));
    }

    public static void openItemGui(ServerPlayerEntity player, boolean isPrivate, int slot, long key, @Nullable UUID bound, @Nullable TileEntity te) {
        Containers.openGui(player, isPrivate, slot, (id, inv, p) -> new KeyContainer(id, inv, te, isPrivate, slot, key, bound));
    }

    private static void openGui(ServerPlayerEntity player, boolean isPrivate, int slot, IContainerProvider provider) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new SimpleNamedContainerProvider(provider, Containers.getDisplayName(isPrivate)), packet -> packet.writeInt(slot));
        player.func_195066_a(Stats.field_188090_X);
    }

    public static void openPasscodeScreen(ServerPlayerEntity player, ILongAccessor code, ItemStack previewBase) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new SimpleNamedContainerProvider((id, inv, p) -> new PasscodeContainer(id, inv, code, previewBase), (ITextComponent)new TranslationTextComponent(CODE_TITLE, new Object[0])), packet -> {
            packet.writeLong(code.get());
            packet.func_150788_a(previewBase);
        });
    }
}

