/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderthing.items;

import gigaherz.enderthing.Enderthing;
import gigaherz.enderthing.KeyUtils;
import gigaherz.enderthing.blocks.EnderKeyChestTileEntity;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EnderCardItem
extends Item
implements KeyUtils.IBindable {
    public EnderCardItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public Optional<CompoundNBT> findHolderTag(ItemStack stack) {
        return Optional.ofNullable(stack.func_77978_p());
    }

    @Override
    public CompoundNBT getOrCreateHolderTag(ItemStack stack) {
        return stack.func_196082_o();
    }

    @Override
    public boolean isBound(ItemStack stack) {
        return this.findHolderTag(stack).map(tag -> !Strings.isNullOrEmpty((String)tag.func_74779_i("Bound"))).orElse(false);
    }

    @Override
    @Nullable
    public UUID getBound(ItemStack stack) {
        return this.findHolderTag(stack).map(tag -> {
            if (!tag.func_150297_b("Bound", 8)) {
                return null;
            }
            try {
                return UUID.fromString(tag.func_74779_i("Bound"));
            }
            catch (IllegalArgumentException e) {
                Enderthing.LOGGER.warn("Stack contained wrong UUID", (Throwable)e);
                return null;
            }
        }).orElse(null);
    }

    @Override
    public void setBound(ItemStack stack, @Nullable UUID uuid) {
        if (uuid == null) {
            this.findHolderTag(stack).ifPresent(blockTag -> {
                blockTag.func_82580_o("Bound");
                blockTag.func_82580_o("PlayerName");
            });
        } else {
            CompoundNBT tag = this.getOrCreateHolderTag(stack);
            tag.func_74778_a("Bound", uuid.toString());
            tag.func_82580_o("PlayerName");
        }
    }

    public void bindToPlayer(ItemStack stack, PlayerEntity player) {
        this.setBound(stack, player.func_110124_au());
        stack.func_196082_o().func_74778_a("PlayerName", player.func_200200_C_().getString());
    }

    @Nullable
    public String getBoundPlayerCachedName(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return null;
        }
        if (!tag.func_150297_b("PlayerName", 8)) {
            return null;
        }
        return tag.func_74779_i("PlayerName");
    }

    public void setBoundPlayerCachedName(ItemStack stack, String newName) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            tag = new CompoundNBT();
            stack.func_77982_d(tag);
        }
        tag.func_74778_a("PlayerName", newName);
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.isBound(stack) || super.func_77636_d(stack);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        return itemStack.func_77946_l();
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            return ActionResult.func_226248_a_((Object)stack);
        }
        if (playerIn.func_225608_bj_()) {
            this.bindToPlayer(stack, playerIn);
            playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("text.enderthing.ender_card.bound", new Object[0]));
            return ActionResult.func_226248_a_((Object)stack);
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        ItemStack stack = context.func_195996_i();
        UUID uuid = this.getBound(stack);
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != Enderthing.KEY_CHEST) {
            return ActionResultType.PASS;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof EnderKeyChestTileEntity) {
            EnderKeyChestTileEntity chest = (EnderKeyChestTileEntity)te;
            if (!chest.isPrivate()) {
                return ActionResultType.PASS;
            }
            chest.bindToPlayer(uuid);
            String name = this.getBoundPlayerCachedName(stack);
            if (player != null) {
                if (name == null || name.length() == 0) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("text.enderthing.ender_chest.bound1", new Object[]{new StringTextComponent(uuid.toString())}));
                } else {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("text.enderthing.ender_chest.bound2", new Object[]{new StringTextComponent(uuid.toString()), new StringTextComponent(name)}));
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        UUID uuid;
        if (!worldIn.field_72995_K && (long)(stack.hashCode() % 120) == worldIn.func_82737_E() % 120L && (uuid = this.getBound(stack)) != null) {
            String name = this.getBoundPlayerCachedName(stack);
            String newName = KeyUtils.queryNameFromUUID(uuid);
            if (newName != null && !newName.equals(name)) {
                this.setBoundPlayerCachedName(stack, newName);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(new TranslationTextComponent("tooltip.enderthing.ender_card.right_click1", new Object[0]).func_211708_a(TextFormatting.ITALIC));
        tooltip.add(new TranslationTextComponent("tooltip.enderthing.ender_card.right_click2", new Object[0]).func_211708_a(TextFormatting.ITALIC));
        UUID uuid = this.getBound(stack);
        if (uuid == null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.enderthing.ender_card.unbound", new Object[0]));
            return;
        }
        String name = this.getBoundPlayerCachedName(stack);
        String uuidText = uuid.toString();
        if (flagIn == ITooltipFlag.TooltipFlags.NORMAL && !Screen.hasShiftDown()) {
            String uuidBegin = uuidText.substring(0, 4);
            String uuidEnd = uuidText.substring(uuidText.length() - 4);
            uuidText = uuidBegin + "..." + uuidEnd;
        }
        if (name == null || name.length() == 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.enderthing.ender_card.bound1", new Object[]{uuidText}));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.enderthing.ender_card.bound2", new Object[]{uuidText, name}));
        }
    }
}

