/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderthing.blocks;

import gigaherz.enderthing.Enderthing;
import gigaherz.enderthing.gui.IContainerInteraction;
import gigaherz.enderthing.storage.EnderInventory;
import gigaherz.enderthing.storage.InventoryManager;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.ObjectHolder;

@OnlyIn(value=Dist.CLIENT, _interface=IChestLid.class)
public class EnderKeyChestTileEntity
extends TileEntity
implements IChestLid,
ITickableTileEntity,
IContainerInteraction {
    @ObjectHolder(value="enderthing:key_chest")
    public static TileEntityType<EnderKeyChestTileEntity> TYPE;
    public float lidAngle;
    public float prevLidAngle;
    public int numPlayersUsing;
    private int ticksSinceSync;
    private long key = -1L;
    private UUID boundToPlayer;
    private EnderInventory inventory;
    private boolean priv;
    private LazyOptional<IItemHandler> inventoryLazy = LazyOptional.of(this::getInventory);

    protected EnderKeyChestTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public EnderKeyChestTileEntity() {
        super(TYPE);
    }

    public boolean isPrivate() {
        return this.priv;
    }

    public void setPrivate(boolean p) {
        if (this.priv != p) {
            this.priv = p;
            if (!p && this.isBoundToPlayer()) {
                this.boundToPlayer = null;
            }
            this.invalidateInventory();
        }
    }

    public long getKey() {
        return this.key;
    }

    public void setKey(long key) {
        if (key != this.key) {
            this.key = key;
            this.invalidateInventory();
        }
    }

    @Nullable
    public UUID getPlayerBound() {
        return this.boundToPlayer;
    }

    public void bindToPlayer(@Nullable UUID boundToPlayer) {
        if (!this.isPrivate()) {
            return;
        }
        if (boundToPlayer != this.boundToPlayer) {
            this.boundToPlayer = boundToPlayer;
            this.invalidateInventory();
        }
    }

    private void invalidateInventory() {
        this.inventoryLazy.invalidate();
        this.inventoryLazy = LazyOptional.of(this::getInventory);
        this.releasePreviousInventory();
        this.func_70296_d();
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public boolean isBoundToPlayer() {
        return this.boundToPlayer != null;
    }

    private void releasePreviousInventory() {
        if (this.inventory != null) {
            this.inventory.removeWeakListener(this);
        }
        this.inventory = null;
    }

    public boolean hasInventory() {
        return this.key >= 0L && (!this.isPrivate() || this.isBoundToPlayer());
    }

    @Nonnull
    public IItemHandlerModifiable getInventory() {
        if (this.field_145850_b != null && this.inventory == null && this.hasInventory()) {
            this.inventory = this.isBoundToPlayer() ? InventoryManager.get(this.field_145850_b).getPrivate(this.boundToPlayer).getInventory(this.key) : InventoryManager.get(this.field_145850_b).getInventory(this.key);
            this.inventory.addWeakListener(this);
        }
        return this.inventory;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.key = tag.func_74763_f("Key");
        this.priv = tag.func_74767_n("IsPrivate");
        if (this.isPrivate() && tag.func_150297_b("Bound", 8)) {
            this.boundToPlayer = UUID.fromString(tag.func_74779_i("Bound"));
        }
        this.releasePreviousInventory();
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        tag.func_74772_a("Key", this.key);
        tag.func_74757_a("IsPrivate", this.priv);
        if (this.isPrivate() && this.boundToPlayer != null) {
            tag.func_74778_a("Bound", this.boundToPlayer.toString());
        }
        return tag;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.hasInventory()) {
            return this.inventoryLazy.cast();
        }
        return super.getCapability(capability, facing);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        super.onDataPacket(net, packet);
        this.handleUpdateTag(this.func_195044_w(), packet.func_148857_g());
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public void func_73660_a() {
        if (++this.ticksSinceSync % 20 * 4 == 0) {
            this.field_145850_b.func_175641_c(this.field_174879_c, Blocks.field_150477_bB, 1, this.numPlayersUsing);
        }
        this.prevLidAngle = this.lidAngle;
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        float f = 0.1f;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            double d0 = (double)i + 0.5;
            double d1 = (double)k + 0.5;
            this.field_145850_b.func_184148_a(null, d0, (double)j + 0.5, d1, SoundEvents.field_187520_aJ, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float f2 = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            float f1 = 0.5f;
            if (this.lidAngle < 0.5f && f2 >= 0.5f) {
                double d3 = (double)i + 0.5;
                double d2 = (double)k + 0.5;
                this.field_145850_b.func_184148_a((PlayerEntity)null, d3, (double)j + 0.5, d2, SoundEvents.field_187519_aI, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void func_145843_s() {
        this.func_145836_u();
        super.func_145843_s();
    }

    @Override
    public void openChest() {
        ++this.numPlayersUsing;
        this.field_145850_b.func_175641_c(this.field_174879_c, (Block)Enderthing.KEY_CHEST, 1, this.numPlayersUsing);
    }

    @Override
    public void closeChest() {
        --this.numPlayersUsing;
        this.field_145850_b.func_175641_c(this.field_174879_c, (Block)Enderthing.KEY_CHEST, 1, this.numPlayersUsing);
    }

    @Override
    public boolean canBeUsed(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return !(player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) > 64.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_195480_a(float partialTicks) {
        return this.prevLidAngle + (this.lidAngle - this.prevLidAngle) * partialTicks;
    }
}

