/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderthing.storage;

import com.google.common.collect.Maps;
import gigaherz.enderthing.storage.EnderInventory;
import gigaherz.enderthing.storage.IInventoryManager;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.util.INBTSerializable;

public class InventoryManager
extends WorldSavedData
implements IInventoryManager {
    private static final String DATA_NAME = "enderthing_InventoryStorageManager";
    private Container global = new Container();
    private Map<UUID, Container> perPlayer = Maps.newHashMap();

    public InventoryManager() {
        super(DATA_NAME);
    }

    public static InventoryManager get(World world) {
        if (!(world instanceof ServerWorld)) {
            throw new RuntimeException("Attempted to get the data from a client world. This is wrong.");
        }
        ServerWorld overworld = world.func_73046_m().func_241755_D_();
        DimensionSavedDataManager storage = overworld.func_217481_x();
        return (InventoryManager)storage.func_215752_a(InventoryManager::new, DATA_NAME);
    }

    @Override
    public void setDirty() {
        this.func_76185_a();
    }

    @Override
    public EnderInventory getInventory(long id) {
        return this.global.getInventory(id);
    }

    public IInventoryManager getPrivate(UUID uuid) {
        Container container = this.perPlayer.get(uuid);
        if (container == null) {
            container = new Container();
            this.perPlayer.put(new UUID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits()), container);
            this.func_76185_a();
        }
        return container;
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.global.deserializeNBT(nbt);
        if (nbt.func_150297_b("Private", 9)) {
            ListNBT list = nbt.func_150295_c("Private", 10);
            this.perPlayer.clear();
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT containerTag = list.func_150305_b(i);
                UUID uuid = InventoryManager.uuidFromNBT(containerTag);
                Container container = new Container();
                container.deserializeNBT(containerTag);
                this.perPlayer.put(uuid, container);
            }
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        CompoundNBT temp = this.global.serializeNBT();
        compound.func_218657_a("Inventories", temp.func_74781_a("Inventories"));
        ListNBT list = new ListNBT();
        for (Map.Entry<UUID, Container> e : this.perPlayer.entrySet()) {
            CompoundNBT tag = e.getValue().serializeNBT();
            InventoryManager.uuidToNBT(tag, e.getKey());
            list.add((Object)tag);
        }
        compound.func_218657_a("Private", (INBT)list);
        return compound;
    }

    public static void uuidToNBT(CompoundNBT tag, UUID uuid) {
        tag.func_74772_a("PlayerUUID0", uuid.getLeastSignificantBits());
        tag.func_74772_a("PlayerUUID1", uuid.getMostSignificantBits());
    }

    @Nullable
    public static UUID uuidFromNBT(CompoundNBT tag) {
        if (!tag.func_150297_b("PlayerUUID0", 4) || !tag.func_150297_b("PlayerUUID1", 4)) {
            return null;
        }
        long uuid0 = tag.func_74763_f("PlayerUUID0");
        long uuid1 = tag.func_74763_f("PlayerUUID1");
        return new UUID(uuid1, uuid0);
    }

    private class Container
    implements INBTSerializable<CompoundNBT>,
    IInventoryManager {
        private Map<Long, EnderInventory> inventories = Maps.newHashMap();

        private Container() {
        }

        @Override
        public EnderInventory getInventory(long id) {
            EnderInventory inventory = this.inventories.get(id);
            if (inventory == null) {
                inventory = new EnderInventory(this);
                this.inventories.put(id, inventory);
            }
            return inventory;
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT tag = new CompoundNBT();
            ListNBT inventories = new ListNBT();
            for (Map.Entry<Long, EnderInventory> entry : this.inventories.entrySet()) {
                EnderInventory inventory = entry.getValue();
                CompoundNBT inventoryTag = new CompoundNBT();
                inventoryTag.func_74772_a("Key", entry.getKey().longValue());
                inventoryTag.func_218657_a("Contents", (INBT)inventory.serializeNBT());
                inventories.add((Object)inventoryTag);
            }
            tag.func_218657_a("Inventories", (INBT)inventories);
            return tag;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            ListNBT nbtTagList = nbt.func_150295_c("Inventories", 10);
            this.inventories.clear();
            for (int i = 0; i < nbtTagList.size(); ++i) {
                CompoundNBT inventoryTag = nbtTagList.func_150305_b(i);
                long j = inventoryTag.func_74763_f("Key");
                EnderInventory inventory = new EnderInventory(this);
                inventory.deserializeNBT(inventoryTag.func_74775_l("Contents"));
                this.inventories.put(j, inventory);
            }
        }

        @Override
        public void setDirty() {
            InventoryManager.this.func_76185_a();
        }
    }
}

