/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderthing.blocks;

import gigaherz.enderthing.Enderthing;
import gigaherz.enderthing.KeyUtils;
import gigaherz.enderthing.blocks.EnderKeyChestTileEntity;
import gigaherz.enderthing.gui.Containers;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractChestBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.EnderChestBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMerger;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;

public class EnderKeyChestBlock
extends AbstractChestBlock<EnderKeyChestTileEntity>
implements IWaterLoggable {
    public static final DirectionProperty FACING = EnderChestBlock.field_176437_a;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);

    public EnderKeyChestBlock(AbstractBlock.Properties properties) {
        super(properties, () -> EnderKeyChestTileEntity.TYPE);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    @OnlyIn(value=Dist.CLIENT)
    public TileEntityMerger.ICallbackWrapper<? extends ChestTileEntity> func_225536_a_(BlockState p_225536_1_, World p_225536_2_, BlockPos p_225536_3_, boolean p_225536_4_) {
        return TileEntityMerger.ICallback::func_225537_b_;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new EnderKeyChestTileEntity();
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new EnderKeyChestTileEntity();
    }

    @Deprecated
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return EnderKeyChestBlock.getItem(world, pos);
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207188_f() : Fluids.field_204541_a.func_207188_f();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof EnderKeyChestTileEntity)) {
            return ActionResultType.PASS;
        }
        if (worldIn.func_180495_p(pos.func_177984_a()).func_215686_e((IBlockReader)worldIn, pos)) {
            return ActionResultType.FAIL;
        }
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (player.func_225608_bj_()) {
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)EnderKeyChestBlock.getItem((IBlockReader)worldIn, pos));
            worldIn.func_175656_a(pos, (BlockState)((BlockState)Blocks.field_150477_bB.func_176223_P().func_206870_a((Property)WATERLOGGED, state.func_177229_b((Property)EnderChestBlock.field_204615_b))).func_206870_a((Property)FACING, state.func_177229_b((Property)EnderChestBlock.field_176437_a)));
            return ActionResultType.SUCCESS;
        }
        EnderKeyChestTileEntity chest = (EnderKeyChestTileEntity)te;
        if (player instanceof ServerPlayerEntity) {
            Containers.openBlockGui((ServerPlayerEntity)player, chest);
        }
        return ActionResultType.SUCCESS;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidState = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195999_j().func_174811_aO().func_176734_d())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)FACING, (Comparable)placer.func_174811_aO().func_176734_d()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        for (int i = 0; i < 3; ++i) {
            int xOffset = rand.nextInt(2) * 2 - 1;
            int zOffset = rand.nextInt(2) * 2 - 1;
            double xPos = (double)pos.func_177958_n() + 0.5 + (double)xOffset * 0.25;
            double yPos = (float)pos.func_177956_o() + rand.nextFloat();
            double zPos = (double)pos.func_177952_p() + 0.5 + (double)zOffset * 0.25;
            double xSpeed = rand.nextFloat() * (float)xOffset;
            double ySpeed = (double)rand.nextFloat() * 0.125 - 0.0625;
            double zSpeed = rand.nextFloat() * (float)zOffset;
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197599_J, xPos, yPos, zPos, xSpeed, ySpeed, zSpeed);
        }
    }

    @Deprecated
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Deprecated
    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    @Deprecated
    public boolean func_189539_a(BlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(id, param);
    }

    private static ItemStack getItem(IBlockReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof EnderKeyChestTileEntity) {
            long id = ((EnderKeyChestTileEntity)te).getKey();
            boolean priv = ((EnderKeyChestTileEntity)te).isPrivate();
            return KeyUtils.getLock(id, priv);
        }
        return new ItemStack((IItemProvider)Enderthing.KEY_CHEST);
    }
}

