/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderthing.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import gigaherz.enderthing.Enderthing;
import gigaherz.enderthing.KeyUtils;
import gigaherz.enderthing.gui.PasscodeContainer;
import gigaherz.enderthing.network.SetItemKey;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class PasscodeScreen
extends ContainerScreen<PasscodeContainer> {
    private static final ResourceLocation CHEST_GUI_TEXTURE = Enderthing.location("textures/container/passcode.png");
    private final NonNullList<ItemStack> itemPasscode = NonNullList.func_191196_a();
    private Button setButton;
    private TextFieldWidget textPasscode;
    public long currentCode = -1L;
    @Nullable
    public ItemStack preview = null;

    public PasscodeScreen(PasscodeContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
        this.field_146999_f = 212;
        this.field_147000_g = 218;
        this.field_238745_s_ = this.field_147000_g - 94;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        long cc = ((PasscodeContainer)this.field_147002_h).keyHolder.get();
        String startKey = cc >= 0L ? String.format("%d", cc) : "";
        this.setButton = new Button(this.field_147003_i + (this.field_146999_f - 30 - 10), this.field_147009_r + 95, 30, 20, (ITextComponent)new StringTextComponent("Set"), this::setButtonPressed);
        this.func_230480_a_((Widget)this.setButton);
        this.textPasscode = new TextFieldWidget(this.field_230712_o_, this.field_147003_i + 12, this.field_147009_r + 78, this.field_146999_f - 24, 12, (ITextComponent)new StringTextComponent(startKey)){

            public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
                if (mouseX >= (double)this.field_230690_l_ && mouseX < (double)(this.field_230690_l_ + this.field_230688_j_) && mouseY >= (double)this.field_230691_m_ && mouseY < (double)(this.field_230691_m_ + this.field_230689_k_) && mouseButton == 1 && !Strings.isNullOrEmpty((String)this.func_146179_b()) && this.func_146179_b().length() > 0) {
                    this.func_146180_a("");
                    return true;
                }
                return super.func_231044_a_(mouseX, mouseY, mouseButton);
            }
        };
        this.func_230480_a_((Widget)this.textPasscode);
        this.textPasscode.func_146189_e(true);
        this.textPasscode.func_146184_c(true);
        this.textPasscode.func_146185_a(true);
        this.textPasscode.func_146203_f(Short.MAX_VALUE);
        this.textPasscode.func_200675_a(this::textPasscodeChanging);
        if (cc >= 0L) {
            this.updateCodeText(startKey);
        }
        this.setButton.field_230693_o_ = this.currentCode >= 0L;
    }

    private void setButtonPressed(Button button) {
        if (this.currentCode >= 0L) {
            Enderthing.CHANNEL.sendToServer((Object)new SetItemKey(this.currentCode));
        }
    }

    private boolean textPasscodeChanging(String text) {
        if (Strings.isNullOrEmpty((String)this.textPasscode.func_146179_b()) && !Strings.isNullOrEmpty((String)text)) {
            this.itemPasscode.clear();
        }
        this.updateCodeText(text);
        return true;
    }

    public boolean func_231042_a_(char p_charTyped_1_, int p_charTyped_2_) {
        if (this.textPasscode.func_230999_j_() && this.textPasscode.func_231042_a_(p_charTyped_1_, p_charTyped_2_)) {
            return true;
        }
        return this.func_241217_q_() != null && this.func_241217_q_().func_231042_a_(p_charTyped_1_, p_charTyped_2_);
    }

    public boolean func_231046_a_(int key, int scanCode, int modifiers) {
        if (this.textPasscode.func_230999_j_()) {
            if (this.textPasscode.func_231046_a_(key, scanCode, modifiers)) {
                return true;
            }
            if (key != 256 && key != 258 && key != 257) {
                return false;
            }
        }
        return super.func_231046_a_(key, scanCode, modifiers);
    }

    public boolean func_231044_a_(double x, double y, int btn) {
        if (btn == 0) {
            double xx = x - (double)this.field_147003_i;
            double yy = y - (double)this.field_147009_r;
            for (Slot s : ((PasscodeContainer)this.field_147002_h).field_75151_b) {
                if (s.func_75211_c().func_190916_E() <= 0 || !(xx >= (double)s.field_75223_e) || !(xx < (double)(s.field_75223_e + 16)) || !(yy >= (double)s.field_75221_f) || !(yy < (double)(s.field_75221_f + 16))) continue;
                this.textPasscode.func_146180_a("");
                ItemStack st = s.func_75211_c().func_77946_l();
                st.func_190920_e(1);
                this.itemPasscode.add((Object)st);
                this.updateCodeItems();
                return true;
            }
        } else if (btn == 1) {
            double xx = x - (double)this.field_147003_i;
            double yy = y - (double)this.field_147009_r;
            if (xx >= 12.0 && xx < (double)(this.field_146999_f - 24) && yy >= 46.0 && yy < 62.0) {
                this.itemPasscode.clear();
                this.updateCodeItems();
                return true;
            }
        }
        return super.func_231044_a_(x, y, btn);
    }

    private void updateCodeText(String text) {
        this.updateCode(KeyUtils.getKeyFromPasscode(text));
    }

    private void updateCodeItems() {
        this.updateCode(KeyUtils.getKeyFromPasscode(this.itemPasscode));
    }

    private void updateCode(long keyFromPasscode) {
        this.currentCode = keyFromPasscode;
        boolean bl = this.setButton.field_230693_o_ = this.currentCode >= 0L;
        if (this.currentCode >= 0L) {
            this.preview = ((PasscodeContainer)this.field_147002_h).previewBase.func_77946_l();
            KeyUtils.setKey(this.preview, this.currentCode);
        } else {
            this.preview = null;
        }
    }

    public void func_231152_a_(@Nonnull Minecraft minecraft, int scaledWidth, int scaledHeight) {
        String s = this.textPasscode.func_146179_b();
        super.func_231152_a_(minecraft, scaledWidth, scaledHeight);
        this.textPasscode.func_146180_a(s);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        RenderHelper.func_227780_a_();
        for (int i = 0; i < this.itemPasscode.size(); ++i) {
            ItemStack st = (ItemStack)this.itemPasscode.get(i);
            this.field_230707_j_.func_180450_b(st, this.field_147003_i + 12 + i * 16, this.field_147009_r + 46);
        }
        if (this.preview != null) {
            this.field_230707_j_.func_180450_b(this.preview, this.field_147003_i + this.field_146999_f - 58, this.field_147009_r + 97);
        }
        RenderHelper.func_74518_a();
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float p_230450_2_, int mouseX, int mouseY) {
        assert (this.field_230706_i_ != null);
        this.field_230706_i_.field_71446_o.func_110577_a(CHEST_GUI_TEXTURE);
        this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_230459_a_(MatrixStack p_230459_1_, int p_230459_2_, int p_230459_3_) {
        super.func_230459_a_(p_230459_1_, p_230459_2_, p_230459_3_);
    }

    protected void func_230451_b_(MatrixStack p_230451_1_, int p_230451_2_, int p_230451_3_) {
        super.func_230451_b_(p_230451_1_, p_230451_2_, p_230451_3_);
        this.field_230712_o_.func_243246_a(p_230451_1_, this.getKeyFormatted("Current key", ((PasscodeContainer)this.field_147002_h).keyHolder.get(), "<not set>"), 10.0f, 22.0f, 0xD8D8D8);
        this.field_230712_o_.func_243246_a(p_230451_1_, (ITextComponent)new StringTextComponent("Click on some items to set a key... "), 10.0f, 35.0f, 0xD8D8D8);
        this.field_230712_o_.func_243246_a(p_230451_1_, (ITextComponent)new StringTextComponent("...or enter a key manually"), 10.0f, 66.0f, 0xD8D8D8);
        this.field_230712_o_.func_243246_a(p_230451_1_, this.getKeyFormatted("Key", this.currentCode, "<invalid>"), 10.0f, 100.0f, 0xD8D8D8);
    }

    private ITextComponent getKeyFormatted(String s1, long currentCode, String s2) {
        if (currentCode >= 0L) {
            return new StringTextComponent(String.format("%s: %d", s1, currentCode));
        }
        return new StringTextComponent(String.format("%s: %s", s1, s2));
    }
}

