/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderthing.items;

import gigaherz.enderthing.Enderthing;
import gigaherz.enderthing.KeyUtils;
import gigaherz.enderthing.blocks.EnderKeyChestBlock;
import gigaherz.enderthing.blocks.EnderKeyChestTileEntity;
import gigaherz.enderthing.items.EnderthingItem;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.EnderChestBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EnderLockItem
extends EnderthingItem
implements KeyUtils.IBindableKeyHolder {
    public EnderLockItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.enderthing.ender_lock.right_click").func_240699_a_(TextFormatting.ITALIC));
        if (this.isBound(stack)) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.enderthing.ender_lock.bound", new Object[]{this.getBoundStr(stack)}));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        long id = KeyUtils.getKey(stack);
        if (id < 0L) {
            if (!worldIn.field_72995_K) {
                this.openPasscodeScreen(playerIn, stack);
            }
            return ActionResult.func_226248_a_((Object)stack);
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World worldIn = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        ItemStack stack = context.func_195996_i();
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        BlockState state = worldIn.func_180495_p(pos);
        long id = KeyUtils.getKey(stack);
        if (id < 0L) {
            this.openPasscodeScreen(player, stack);
            return ActionResultType.SUCCESS;
        }
        Block b = state.func_177230_c();
        TileEntity te = worldIn.func_175625_s(pos);
        if (b == Blocks.field_150477_bB) {
            return this.replaceWithKeyChest(worldIn, pos, stack, state, id, true, player);
        }
        if (b instanceof EnderKeyChestBlock) {
            boolean newPrivate;
            boolean oldPrivate = false;
            if (te instanceof EnderKeyChestTileEntity) {
                EnderKeyChestTileEntity chest = (EnderKeyChestTileEntity)te;
                long oldId = chest.getKey();
                oldPrivate = chest.isPrivate();
                UUID bound = chest.getPlayerBound();
                ItemStack oldStack = KeyUtils.getLock(oldId, oldPrivate, bound);
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)oldStack);
            }
            return this.replaceWithKeyChest(worldIn, pos, stack, state, id, oldPrivate != (newPrivate = this.isPrivate(stack)), player);
        }
        return ActionResultType.PASS;
    }

    private ActionResultType replaceWithKeyChest(World worldIn, BlockPos pos, ItemStack stack, BlockState state, long id, boolean replace, PlayerEntity player) {
        TileEntity te;
        if (replace) {
            this.setKeyChest(worldIn, pos, state, stack);
        }
        if ((te = worldIn.func_175625_s(pos)) instanceof EnderKeyChestTileEntity) {
            EnderKeyChestTileEntity chest = (EnderKeyChestTileEntity)te;
            chest.setKey(id);
            chest.setPrivate(this.isPrivate(stack));
            if (this.isPrivate(stack) && this.isBound(stack)) {
                chest.bindToPlayer(this.getBound(stack));
            }
        }
        if (!player.func_184812_l_()) {
            stack.func_190917_f(-1);
        }
        return ActionResultType.SUCCESS;
    }

    private void setKeyChest(World worldIn, BlockPos pos, BlockState state, ItemStack stack) {
        worldIn.func_175656_a(pos, (BlockState)((BlockState)Enderthing.KEY_CHEST.func_176223_P().func_206870_a((Property)EnderKeyChestBlock.WATERLOGGED, state.func_177229_b((Property)EnderChestBlock.field_204615_b))).func_206870_a((Property)EnderKeyChestBlock.FACING, state.func_177229_b((Property)EnderChestBlock.field_176437_a)));
    }
}

