/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderthing.storage;

import com.google.common.collect.Lists;
import gigaherz.enderthing.blocks.EnderKeyChestTileEntity;
import gigaherz.enderthing.storage.IInventoryManager;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.ItemStackHandler;

public class EnderInventory
extends ItemStackHandler {
    public static final int SLOT_COUNT = 27;
    private final IInventoryManager manager;
    private final List<Reference<? extends EnderKeyChestTileEntity>> listeners = Lists.newArrayList();

    public void addWeakListener(EnderKeyChestTileEntity e) {
        this.listeners.add(new WeakReference<EnderKeyChestTileEntity>(e));
    }

    public void removeWeakListener(EnderKeyChestTileEntity e) {
        Iterator<Reference<? extends EnderKeyChestTileEntity>> it = this.listeners.iterator();
        while (it.hasNext()) {
            EnderKeyChestTileEntity te = it.next().get();
            if (te != null && !te.func_145837_r() && te != e) continue;
            it.remove();
        }
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        ArrayList dirty = Lists.newArrayList();
        Iterator<Reference<? extends EnderKeyChestTileEntity>> it = this.listeners.iterator();
        while (it.hasNext()) {
            EnderKeyChestTileEntity te = it.next().get();
            if (te == null || te.func_145837_r()) {
                it.remove();
                continue;
            }
            dirty.add(te);
        }
        dirty.forEach(TileEntity::func_70296_d);
        this.manager.setDirty();
    }

    EnderInventory(IInventoryManager manager) {
        super(27);
        this.setSize(27);
        this.manager = manager;
    }
}

