/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderthing.blocks;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.mojang.realmsclient.gui.ChatFormatting;
import gigaherz.enderthing.Enderthing;
import gigaherz.enderthing.blocks.BlockRegistered;
import gigaherz.enderthing.blocks.TileEnderKeyChest;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockEnderKeyChest
extends BlockRegistered {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool PRIVATE = PropertyBool.func_177716_a((String)"private");
    public static final PropertyBool BOUND = PropertyBool.func_177716_a((String)"bound");
    protected static final AxisAlignedBB ENDER_CHEST_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);
    public static final String INVENTORY_ID_KEY = "InventoryId";

    public BlockEnderKeyChest(String name) {
        super(name, Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)PRIVATE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BOUND, (Comparable)Boolean.valueOf(false)));
        this.func_149647_a(Enderthing.tabEnderthing);
        this.func_149711_c(22.5f);
        this.func_149752_b(1000.0f);
        this.func_149672_a(field_149769_e);
        this.func_149715_a(0.5f);
        this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)PRIVATE)).booleanValue()) {
            return new TileEnderKeyChest.Private();
        }
        return new TileEnderKeyChest();
    }

    public int func_149645_b() {
        return 2;
    }

    public boolean removedByPlayer(World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(world, pos, player, false);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos, EntityPlayer player) {
        return this.getAsItem((IBlockAccess)world, pos);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList ret = Lists.newArrayList();
        ret.add(new ItemStack(Blocks.field_150343_Z, 8));
        ret.add(BlockEnderKeyChest.getLock(this.getId(world, pos), (Boolean)state.func_177229_b((IProperty)PRIVATE)));
        return ret;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te) {
        player.func_71029_a(StatList.field_75934_C[BlockEnderKeyChest.func_149682_b((Block)this)]);
        player.func_71020_j(0.025f);
        if (this.canSilkHarvest(worldIn, pos, state, player) && EnchantmentHelper.func_77502_d((EntityLivingBase)player)) {
            ArrayList items = Lists.newArrayList();
            ItemStack itemstack = this.getAsItem((IBlockAccess)worldIn, pos);
            if (itemstack != null) {
                items.add(itemstack);
            }
            ForgeEventFactory.fireBlockHarvesting((List)items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
            for (ItemStack item : items) {
                BlockEnderKeyChest.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
            }
        } else {
            this.harvesters.set(player);
            int i = EnchantmentHelper.func_77517_e((EntityLivingBase)player);
            this.func_176226_b(worldIn, pos, state, i);
            this.harvesters.set(null);
        }
        worldIn.func_175698_g(pos);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te == null || !(te instanceof TileEnderKeyChest)) {
            return true;
        }
        if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c().isNormalCube((IBlockAccess)worldIn, pos.func_177984_a())) {
            return true;
        }
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEnderKeyChest chest = (TileEnderKeyChest)te;
        ItemStack heldItem = playerIn.func_70694_bm();
        if (side == EnumFacing.UP && heldItem != null && heldItem.func_77973_b() == Items.field_151100_aR && (chest.getPlayerBound() == null || chest.getPlayerBound().equals(playerIn.func_110124_au()))) {
            int oldId;
            int meta = EnumDyeColor.func_176766_a((int)heldItem.func_77960_j()).func_176765_a();
            float z = hitZ;
            float x = hitX;
            switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
                case EAST: {
                    x = hitZ;
                    z = 1.0f - hitX;
                    break;
                }
                case SOUTH: {
                    x = 1.0f - hitX;
                    z = 1.0f - hitZ;
                    break;
                }
                case WEST: {
                    x = 1.0f - hitZ;
                    z = hitX;
                }
            }
            x *= 16.0f;
            z *= 16.0f;
            boolean hitSuccess = false;
            int id = oldId = chest.getInventoryId();
            if (z >= 1.0f && z <= 8.0f) {
                int color1 = id & 0xF;
                int color2 = id >> 4 & 0xF;
                int color3 = id >> 8 & 0xF;
                if ((double)x >= 3.5 && (double)x < 6.5) {
                    color3 = meta;
                    hitSuccess = true;
                } else if ((double)x >= 6.5 && (double)x < 9.5) {
                    color2 = meta;
                    hitSuccess = true;
                } else if ((double)x >= 9.5 && (double)x < 12.5) {
                    color1 = meta;
                    hitSuccess = true;
                }
                id = color1 | color2 << 4 | color3 << 8;
            }
            if (oldId != id) {
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    --heldItem.field_77994_a;
                }
                chest.setInventoryId(id);
            }
            if (hitSuccess) {
                return true;
            }
        }
        int id = chest.getInventoryId() << 4 | ((Boolean)state.func_177229_b((IProperty)PRIVATE) != false ? 1 : 0);
        playerIn.openGui((Object)Enderthing.instance, id, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)PRIVATE, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)PRIVATE, (Comparable)Boolean.valueOf((stack.func_77960_j() & 8) != 0)), 2);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        for (int i = 0; i < 3; ++i) {
            int xOffset = rand.nextInt(2) * 2 - 1;
            int zOffset = rand.nextInt(2) * 2 - 1;
            double xPos = (double)pos.func_177958_n() + 0.5 + (double)xOffset * 0.25;
            double yPos = (float)pos.func_177956_o() + rand.nextFloat();
            double zPos = (double)pos.func_177952_p() + 0.5 + (double)zOffset * 0.25;
            double xSpeed = rand.nextFloat() * (float)xOffset;
            double ySpeed = (double)rand.nextFloat() * 0.125 - 0.0625;
            double zSpeed = rand.nextFloat() * (float)zOffset;
            worldIn.func_175688_a(EnumParticleTypes.PORTAL, xPos, yPos, zPos, xSpeed, ySpeed, zSpeed, new int[0]);
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)PRIVATE, (Comparable)Boolean.valueOf((meta & 8) != 0)).func_177226_a((IProperty)BOUND, (Comparable)Boolean.valueOf((meta & 0xC) == 12));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() | ((Boolean)state.func_177229_b((IProperty)PRIVATE) != false ? 8 : 0) | ((Boolean)state.func_177229_b((IProperty)BOUND) != false ? 4 : 0);
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{FACING, PRIVATE, BOUND});
    }

    int getId(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEnderKeyChest) {
            return ((TileEnderKeyChest)te).getInventoryId();
        }
        return 0;
    }

    private ItemStack getAsItem(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEnderKeyChest) {
            int id = ((TileEnderKeyChest)te).getInventoryId();
            return BlockEnderKeyChest.getItem(id, (Boolean)state.func_177229_b((IProperty)PRIVATE));
        }
        return new ItemStack((Block)Enderthing.blockEnderKeyChest);
    }

    public static ItemStack getItem(int id, boolean priv) {
        ItemStack stack = new ItemStack((Block)Enderthing.blockEnderKeyChest, 1, priv ? 8 : 0);
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound etag = new NBTTagCompound();
        etag.func_74768_a(INVENTORY_ID_KEY, id);
        tag.func_74782_a("BlockEntityTag", (NBTBase)etag);
        stack.func_77982_d(tag);
        return stack;
    }

    public static int getId(ItemStack stack) {
        NBTTagCompound etag;
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && (etag = tag.func_74775_l("BlockEntityTag")) != null) {
            return etag.func_74762_e(INVENTORY_ID_KEY);
        }
        return 0;
    }

    private static ItemStack getLock(int oldId, boolean value) {
        int oldColor1 = oldId & 0xF;
        int oldColor2 = oldId >> 4 & 0xF;
        int oldColor3 = oldId >> 8 & 0xF;
        ItemStack oldStack = new ItemStack((Item)Enderthing.enderLock, 1, value ? 1 : 0);
        NBTTagCompound oldTag = new NBTTagCompound();
        oldTag.func_74774_a("Color1", (byte)oldColor1);
        oldTag.func_74774_a("Color2", (byte)oldColor2);
        oldTag.func_74774_a("Color3", (byte)oldColor3);
        oldStack.func_77982_d(oldTag);
        return oldStack;
    }

    @Override
    public ItemBlock createItemBlock() {
        return new AsItem(this);
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < 16; ++i) {
            int id = i | i << 4 | i << 8;
            list.add(BlockEnderKeyChest.getItem(id, false));
            list.add(BlockEnderKeyChest.getItem(id, true));
        }
    }

    public static class AsItem
    extends ItemBlock {
        public AsItem(Block block) {
            super(block);
            this.func_77627_a(true);
            this.setRegistryName(block.getRegistryName());
        }

        public int func_77647_b(int damage) {
            return damage;
        }

        public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
            if (playerIn.func_70093_af()) {
                int oldId = BlockEnderKeyChest.getId(itemStackIn);
                ItemStack oldStack = BlockEnderKeyChest.getLock(oldId, itemStackIn.func_77960_j() != 0);
                if (!playerIn.field_71071_by.func_70441_a(oldStack)) {
                    playerIn.func_146097_a(oldStack, true, false);
                }
                if (itemStackIn.field_77994_a > 1) {
                    ItemStack stack = new ItemStack(Blocks.field_150477_bB);
                    if (!playerIn.field_71071_by.func_70441_a(stack)) {
                        playerIn.func_146097_a(stack, true, false);
                    }
                    --itemStackIn.field_77994_a;
                    return itemStackIn;
                }
                return new ItemStack(Blocks.field_150477_bB);
            }
            return super.func_77659_a(itemStackIn, worldIn, playerIn);
        }

        public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
            NBTTagCompound etag;
            tooltip.add(ChatFormatting.ITALIC + StatCollector.func_74838_a((String)"tooltip.enderthing.enderKeyChest.rightClick"));
            if ((stack.func_77960_j() & 8) != 0) {
                tooltip.add(ChatFormatting.BOLD + StatCollector.func_74838_a((String)"tooltip.enderthing.private"));
            }
            int id = 0;
            boolean idFound = false;
            NBTTagCompound tag = stack.func_77978_p();
            if (tag != null && (etag = tag.func_74775_l("BlockEntityTag")) != null) {
                idFound = true;
                id = etag.func_74762_e(BlockEnderKeyChest.INVENTORY_ID_KEY);
            }
            if (!idFound) {
                tooltip.add(ChatFormatting.ITALIC + StatCollector.func_74838_a((String)"tooltip.enderthing.colorMissing"));
                return;
            }
            int color1 = id & 0xF;
            int color2 = id >> 4 & 0xF;
            int color3 = id >> 8 & 0xF;
            EnumDyeColor c1 = EnumDyeColor.func_176764_b((int)color1);
            EnumDyeColor c2 = EnumDyeColor.func_176764_b((int)color2);
            EnumDyeColor c3 = EnumDyeColor.func_176764_b((int)color3);
            tooltip.add(StatCollector.func_74837_a((String)"tooltip.enderthing.colors", (Object[])new Object[]{c1.func_176610_l(), c2.func_176610_l(), c3.func_176610_l()}));
        }

        public int func_82790_a(ItemStack stack, int tintIndex) {
            NBTTagCompound etag;
            int color1 = 0;
            int color2 = 0;
            int color3 = 0;
            NBTTagCompound tag = stack.func_77978_p();
            if (tag != null && (etag = tag.func_74775_l("BlockEntityTag")) != null) {
                int id = etag.func_74762_e(BlockEnderKeyChest.INVENTORY_ID_KEY);
                color1 = id & 0xF;
                color2 = id >> 4 & 0xF;
                color3 = id >> 8 & 0xF;
            }
            EnumDyeColor c1 = EnumDyeColor.func_176764_b((int)color1);
            EnumDyeColor c2 = EnumDyeColor.func_176764_b((int)color2);
            EnumDyeColor c3 = EnumDyeColor.func_176764_b((int)color3);
            switch (tintIndex) {
                case 1: {
                    return c1.func_176768_e().field_76291_p;
                }
                case 2: {
                    return c2.func_176768_e().field_76291_p;
                }
                case 3: {
                    return c3.func_176768_e().field_76291_p;
                }
            }
            return -1;
        }
    }
}

