/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderthing.blocks;

import gigaherz.enderthing.Enderthing;
import gigaherz.enderthing.blocks.BlockEnderKeyChest;
import gigaherz.enderthing.network.UpdatePlayersUsing;
import gigaherz.enderthing.storage.EnderInventory;
import gigaherz.enderthing.storage.InventoryManager;
import java.util.UUID;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEnderKeyChest
extends TileEntityEnderChest {
    private int inventoryId;
    private int ticksSinceSync;
    protected boolean isPrivate;
    private UUID boundToPlayer;
    private EnderInventory inventory;

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public int getInventoryId() {
        return this.inventoryId;
    }

    public void setInventoryId(int inventoryId) {
        this.inventoryId = inventoryId;
        this.func_70296_d();
        this.field_145850_b.func_175689_h(this.field_174879_c);
    }

    public EnderInventory getInventory() {
        if (this.inventoryId < 0) {
            return null;
        }
        if (this.inventory == null && (!this.isPrivate || this.isBoundToPlayer())) {
            this.inventory = this.isBoundToPlayer() ? InventoryManager.get(this.field_145850_b).getPrivate(this.boundToPlayer).getInventory(this.inventoryId) : InventoryManager.get(this.field_145850_b).getInventory(this.inventoryId);
            this.inventory.addWeakListener(this);
        }
        return this.inventory;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c() || oldState.func_177229_b((IProperty)BlockEnderKeyChest.PRIVATE) != newState.func_177229_b((IProperty)BlockEnderKeyChest.PRIVATE) || oldState.func_177229_b((IProperty)BlockEnderKeyChest.BOUND) != newState.func_177229_b((IProperty)BlockEnderKeyChest.BOUND);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventoryId = tag.func_74762_e("InventoryId");
        this.boundToPlayer = InventoryManager.uuidFromNBT(tag);
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("InventoryId", this.inventoryId);
        if (this.boundToPlayer != null) {
            InventoryManager.uuidToNBT(tag, this.boundToPlayer);
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getInventory() != null;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.getInventory());
        }
        return (T)super.getCapability(capability, facing);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_174879_c, 0, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.func_145839_a(packet.func_148857_g());
    }

    public boolean canRenderBreaking() {
        return true;
    }

    public void func_73660_a() {
        if (++this.ticksSinceSync % 80 == 0 && !this.field_145850_b.field_72995_K) {
            Enderthing.channel.sendToAllAround((IMessage)new UpdatePlayersUsing(this.field_174879_c, 1, this.field_145973_j), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.func_177502_q(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 64.0));
        }
        this.field_145975_i = this.field_145972_a;
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int Z = this.field_174879_c.func_177952_p();
        float f = 0.1f;
        if (this.field_145973_j > 0 && this.field_145972_a == 0.0f) {
            this.field_145850_b.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)Z + 0.5, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.field_145973_j == 0 && this.field_145972_a > 0.0f || this.field_145973_j > 0 && this.field_145972_a < 1.0f) {
            float closedThreshold;
            float f2 = this.field_145972_a;
            this.field_145972_a = this.field_145973_j > 0 ? (this.field_145972_a += f) : (this.field_145972_a -= f);
            if (this.field_145972_a > 1.0f) {
                this.field_145972_a = 1.0f;
            }
            if (this.field_145972_a < (closedThreshold = 0.5f) && f2 >= closedThreshold) {
                this.field_145850_b.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)Z + 0.5, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.field_145972_a < 0.0f) {
                this.field_145972_a = 0.0f;
            }
        }
    }

    public void receiveUpdate(int id, int value) {
        if (id == 1) {
            this.field_145973_j = value;
        }
    }

    public UUID getPlayerBound() {
        return this.boundToPlayer;
    }

    public void bindToPlayer(UUID boundToPlayer) {
        this.boundToPlayer = boundToPlayer;
        this.func_70296_d();
        this.field_145850_b.func_175689_h(this.field_174879_c);
    }

    public boolean isBoundToPlayer() {
        return this.boundToPlayer != null;
    }

    public static class Private
    extends TileEnderKeyChest {
        public Private() {
            this.isPrivate = true;
        }
    }
}

