/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderthing.storage;

import com.google.common.collect.Maps;
import gigaherz.enderthing.storage.EnderInventory;
import gigaherz.enderthing.storage.IInventoryManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.common.util.INBTSerializable;

public class InventoryManager
extends WorldSavedData
implements IInventoryManager {
    private static final String StorageKey = "enderthing_InventoryStorageManager";
    private Container global = new Container();
    private Map<UUID, Container> perPlayer = Maps.newHashMap();

    public InventoryManager() {
        super(StorageKey);
    }

    public InventoryManager(String s) {
        super(s);
    }

    public static InventoryManager get(World world) {
        MapStorage storage = world.func_175693_T();
        InventoryManager instance = (InventoryManager)storage.func_75742_a(InventoryManager.class, StorageKey);
        if (instance == null) {
            instance = new InventoryManager();
            storage.func_75745_a(StorageKey, (WorldSavedData)instance);
        }
        return instance;
    }

    @Override
    public void setDirty() {
        this.func_76185_a();
    }

    @Override
    public EnderInventory getInventory(int id) {
        return this.global.getInventory(id);
    }

    public IInventoryManager getPrivate(EntityPlayer owner) {
        UUID key = owner.func_110124_au();
        return this.getPrivate(key);
    }

    public IInventoryManager getPrivate(UUID uuid) {
        Container container = this.perPlayer.get(uuid);
        if (container == null) {
            container = new Container();
            this.perPlayer.put(new UUID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits()), container);
            this.func_76185_a();
        }
        return container;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.global.deserializeNBT(nbt);
        if (nbt.func_150297_b("Private", 9)) {
            NBTTagList list = nbt.func_150295_c("Private", 10);
            this.perPlayer.clear();
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound containerTag = list.func_150305_b(i);
                UUID uuid = InventoryManager.uuidFromNBT(containerTag);
                Container container = new Container();
                container.deserializeNBT(containerTag);
                this.perPlayer.put(uuid, container);
            }
        }
    }

    public void func_76187_b(NBTTagCompound nbtTagCompound) {
        NBTTagCompound temp = this.global.serializeNBT();
        nbtTagCompound.func_74782_a("Inventories", temp.func_74781_a("Inventories"));
        NBTTagList list = new NBTTagList();
        for (Map.Entry<UUID, Container> e : this.perPlayer.entrySet()) {
            NBTTagCompound tag = e.getValue().serializeNBT();
            InventoryManager.uuidToNBT(tag, e.getKey());
            list.func_74742_a((NBTBase)tag);
        }
        nbtTagCompound.func_74782_a("Private", (NBTBase)list);
    }

    public void importCapabilityData(EntityPlayer player, NBTTagCompound nbt) {
        ((Container)this.getPrivate(player)).importNBT(nbt);
    }

    public static void uuidToNBT(NBTTagCompound tag, UUID uuid) {
        tag.func_74772_a("PlayerUUID0", uuid.getLeastSignificantBits());
        tag.func_74772_a("PlayerUUID1", uuid.getMostSignificantBits());
    }

    public static UUID uuidFromNBT(NBTTagCompound tag) {
        if (!tag.func_150297_b("PlayerUUID0", 4)) {
            return null;
        }
        long uuid0 = tag.func_74763_f("PlayerUUID0");
        long uuid1 = tag.func_74763_f("PlayerUUID1");
        return new UUID(uuid1, uuid0);
    }

    private class Container
    implements INBTSerializable<NBTTagCompound>,
    IInventoryManager {
        private Map<Integer, EnderInventory> inventories = new HashMap<Integer, EnderInventory>();

        private Container() {
        }

        @Override
        public EnderInventory getInventory(int id) {
            EnderInventory inventory = this.inventories.get(id);
            if (inventory == null) {
                inventory = new EnderInventory(this);
                this.inventories.put(id, inventory);
            }
            return inventory;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagList inventories = new NBTTagList();
            for (Map.Entry<Integer, EnderInventory> entry : this.inventories.entrySet()) {
                EnderInventory inventory = entry.getValue();
                NBTTagCompound inventoryTag = new NBTTagCompound();
                inventoryTag.func_74768_a("InventoryId", entry.getKey().intValue());
                inventoryTag.func_74782_a("InventoryContents", (NBTBase)inventory.serializeNBT());
                inventories.func_74742_a((NBTBase)inventoryTag);
            }
            tag.func_74782_a("Inventories", (NBTBase)inventories);
            return tag;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            NBTTagList nbtTagList = nbt.func_150295_c("Inventories", 10);
            this.inventories.clear();
            for (int i = 0; i < nbtTagList.func_74745_c(); ++i) {
                NBTTagCompound inventoryTag = nbtTagList.func_150305_b(i);
                int j = inventoryTag.func_74762_e("InventoryId");
                EnderInventory inventory = new EnderInventory(this);
                inventory.deserializeNBT(inventoryTag.func_74775_l("InventoryContents"));
                this.inventories.put(j, inventory);
            }
        }

        void importNBT(NBTTagCompound nbt) {
            NBTTagList nbtTagList = nbt.func_150295_c("Inventories", 10);
            for (int i = 0; i < nbtTagList.func_74745_c(); ++i) {
                NBTTagCompound inventoryTag = nbtTagList.func_150305_b(i);
                int j = inventoryTag.func_74762_e("InventoryId");
                if (this.inventories.containsKey(j)) continue;
                EnderInventory inventory = new EnderInventory(this);
                inventory.deserializeNBT(inventoryTag.func_74775_l("InventoryContents"));
                this.inventories.put(j, inventory);
            }
        }

        @Override
        public void setDirty() {
            InventoryManager.this.func_76185_a();
        }
    }
}

