/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.INameable;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.blocks.DecorBlock;
import wile.engineersdecor.blocks.IDecorBlock;
import wile.engineersdecor.libmc.blocks.StandardBlocks;
import wile.engineersdecor.libmc.detail.Inventories;
import wile.engineersdecor.libmc.detail.Networking;
import wile.engineersdecor.libmc.detail.TooltipDisplay;

public class EdDropper {
    private static boolean with_adjacent_item_insertion = false;

    public static void on_config(boolean with_item_insertion) {
        with_adjacent_item_insertion = with_item_insertion;
        ModEngineersDecor.logger().info("Config dropper: item-insertion:" + with_adjacent_item_insertion);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DropperGui
    extends ContainerScreen<DropperContainer> {
        protected final PlayerEntity player_;
        protected final TooltipDisplay tooltip_ = new TooltipDisplay();

        public DropperGui(DropperContainer container, PlayerInventory player_inventory, ITextComponent title) {
            super((Container)container, player_inventory, title);
            this.player_ = player_inventory.field_70458_d;
        }

        public void init() {
            super.init();
            String prefix = ModContent.FACTORY_DROPPER.func_149739_a() + ".tooltips.";
            int x0 = this.getGuiLeft();
            int y0 = this.getGuiTop();
            this.tooltip_.init(new TooltipDisplay.TipRange(x0 + 130, y0 + 10, 12, 25, (ITextComponent)new TranslationTextComponent(prefix + "velocity", new Object[0])), new TooltipDisplay.TipRange(x0 + 145, y0 + 10, 25, 25, (ITextComponent)new TranslationTextComponent(prefix + "direction", new Object[0])), new TooltipDisplay.TipRange(x0 + 129, y0 + 40, 44, 10, (ITextComponent)new TranslationTextComponent(prefix + "dropcount", new Object[0])), new TooltipDisplay.TipRange(x0 + 129, y0 + 50, 44, 10, (ITextComponent)new TranslationTextComponent(prefix + "period", new Object[0])), new TooltipDisplay.TipRange(x0 + 114, y0 + 51, 9, 9, (ITextComponent)new TranslationTextComponent(prefix + "rssignal", new Object[0])), new TooltipDisplay.TipRange(x0 + 162, y0 + 66, 7, 9, (ITextComponent)new TranslationTextComponent(prefix + "triggermode", new Object[0])), new TooltipDisplay.TipRange(x0 + 132, y0 + 66, 9, 9, (ITextComponent)new TranslationTextComponent(prefix + "filtergate", new Object[0])), new TooltipDisplay.TipRange(x0 + 148, y0 + 66, 9, 9, (ITextComponent)new TranslationTextComponent(prefix + "externgate", new Object[0])));
        }

        public void render(int mouseX, int mouseY, float partialTicks) {
            this.renderBackground();
            super.render(mouseX, mouseY, partialTicks);
            if (!this.tooltip_.render(this, mouseX, mouseY)) {
                this.func_191948_b(mouseX, mouseY);
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
            this.tooltip_.resetTimer();
            DropperContainer container = (DropperContainer)this.func_212873_a_();
            int mx = (int)(mouseX - (double)this.getGuiLeft() + 0.5);
            int my = (int)(mouseY - (double)this.getGuiTop() + 0.5);
            if (!this.func_195359_a(114, 1, 61, 79, mouseX, mouseY)) {
                return super.mouseClicked(mouseX, mouseY, mouseButton);
            }
            if (this.func_195359_a(130, 10, 12, 25, mouseX, mouseY)) {
                int force_percent = 100 - MathHelper.func_76125_a((int)((my - 10) * 100 / 25), (int)0, (int)100);
                container.onGuiAction("drop_speed", force_percent);
            } else if (this.func_195359_a(145, 10, 25, 25, mouseX, mouseY)) {
                int xdev = MathHelper.func_76125_a((int)((int)Math.round((double)((mx - 157) * 100) / 12.0)), (int)-100, (int)100);
                int ydev = MathHelper.func_76125_a((int)(-((int)Math.round((double)((my - 22) * 100) / 12.0))), (int)-100, (int)100);
                if (Math.abs(xdev) < 9) {
                    xdev = 0;
                }
                if (Math.abs(ydev) < 9) {
                    ydev = 0;
                }
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74768_a("drop_xdev", xdev);
                nbt.func_74768_a("drop_ydev", ydev);
                container.onGuiAction(nbt);
            } else if (this.func_195359_a(129, 40, 44, 10, mouseX, mouseY)) {
                int ndrop = mx - 135;
                ndrop = ndrop < -1 ? container.field(4) - 1 : (ndrop >= 34 ? container.field(4) + 1 : MathHelper.func_76125_a((int)(1 + ndrop), (int)1, (int)32));
                container.onGuiAction("drop_count", ndrop);
            } else if (this.func_195359_a(129, 50, 44, 10, mouseX, mouseY)) {
                int period = mx - 135;
                period = period < -1 ? container.field(6) - 3 : (period >= 34 ? container.field(6) + 3 : (int)(0.5 + 100.0 * (double)period / 34.0));
                period = MathHelper.func_76125_a((int)period, (int)0, (int)100);
                container.onGuiAction("drop_period", period);
            } else if (this.func_195359_a(114, 51, 9, 9, mouseX, mouseY)) {
                container.onGuiAction("manual_rstrigger", 1);
            } else if (this.func_195359_a(162, 66, 7, 9, mouseX, mouseY)) {
                container.onGuiAction("drop_logic", container.field(5) ^ 0x10);
            } else if (this.func_195359_a(132, 66, 9, 9, mouseX, mouseY)) {
                container.onGuiAction("drop_logic", container.field(5) ^ 1);
            } else if (this.func_195359_a(148, 66, 9, 9, mouseX, mouseY)) {
                container.onGuiAction("drop_logic", container.field(5) ^ 2);
            }
            return true;
        }

        protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
            RenderSystem.enableBlend();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.minecraft.func_110434_K().func_110577_a(new ResourceLocation("engineersdecor", "textures/gui/factory_dropper_gui.png"));
            int x0 = this.getGuiLeft();
            int y0 = this.getGuiTop();
            int w = this.getXSize();
            int h = this.getYSize();
            this.blit(x0, y0, 0, 0, w, h);
            DropperContainer container = (DropperContainer)this.func_212873_a_();
            int drop_slot_index = container.field(15);
            if (drop_slot_index < 0 || drop_slot_index >= 16) {
                drop_slot_index = 0;
            }
            int x = x0 + 9 + drop_slot_index % 6 * 18;
            int y = y0 + 5 + drop_slot_index / 6 * 17;
            this.blit(x, y, 180, 45, 18, 18);
            for (int i = 0; i < 3; ++i) {
                int xt = 180 + 6 * container.field(12 + i);
                int yt = 38;
                int x2 = x0 + 31 + i * 36;
                int y2 = y0 + 65;
                this.blit(x2, y2, xt, yt, 6, 6);
            }
            int hy = 2 + (100 - container.field(0)) * 21 / 100;
            x = x0 + 135;
            y = y0 + 12;
            int xt = 181;
            int yt = 4 + (23 - hy);
            this.blit(x, y, xt, yt, 3, hy);
            int x3 = x0 + 157 - 3 + container.field(1) * 12 / 100;
            int y3 = y0 + 22 - 3 - container.field(2) * 12 / 100;
            this.blit(x3, y3, 180, 30, 7, 7);
            x3 = x0 + 134 - 2 + container.field(4);
            y3 = y0 + 45;
            this.blit(x3, y3, 190, 31, 5, 5);
            int px = (int)Math.round(33.0 * (double)container.field(6) / 100.0 + 1.0);
            x = x0 + 134 - 2 + MathHelper.func_76125_a((int)px, (int)0, (int)33);
            y = y0 + 56;
            this.blit(x, y, 190, 31, 5, 5);
            if (container.field(11) != 0) {
                this.blit(x0 + 114, y0 + 51, 189, 18, 9, 9);
            }
            int filter_gate_offset = (container.field(5) & 1) != 0 ? 11 : 0;
            int extern_gate_offset = (container.field(5) & 2) != 0 ? 11 : 0;
            int pulse_mode_offset = (container.field(5) & 0x10) != 0 ? 10 : 0;
            this.blit(x0 + 132, y0 + 66, 179 + filter_gate_offset, 66, 9, 9);
            this.blit(x0 + 148, y0 + 66, 179 + extern_gate_offset, 66, 9, 9);
            this.blit(x0 + 162, y0 + 66, 200 + pulse_mode_offset, 66, 9, 9);
            if (container.field(9) > 10 && System.currentTimeMillis() % 1000L < 500L) {
                this.blit(x0 + 149, y0 + 51, 201, 39, 3, 3);
            }
            RenderSystem.disableBlend();
        }
    }

    public static class DropperContainer
    extends Container
    implements Networking.INetworkSynchronisableContainer {
        private static final int PLAYER_INV_START_SLOTNO = 15;
        private final PlayerEntity player_;
        private final IInventory inventory_;
        private final IWorldPosCallable wpc_;
        private final IIntArray fields_;

        public final int field(int index) {
            return this.fields_.func_221476_a(index);
        }

        public DropperContainer(int cid, PlayerInventory player_inventory) {
            this(cid, player_inventory, (IInventory)new Inventory(15), IWorldPosCallable.field_221489_a, (IIntArray)new IntArray(16));
        }

        private DropperContainer(int cid, PlayerInventory player_inventory, IInventory block_inventory, IWorldPosCallable wpc, IIntArray fields) {
            super(ModContent.CT_FACTORY_DROPPER, cid);
            int x;
            int y;
            this.fields_ = fields;
            this.wpc_ = wpc;
            this.player_ = player_inventory.field_70458_d;
            this.inventory_ = block_inventory;
            int i = -1;
            for (y = 0; y < 2; ++y) {
                for (x = 0; x < 6; ++x) {
                    int xpos = 10 + x * 18;
                    int ypos = 6 + y * 17;
                    this.func_75146_a(new Slot(this.inventory_, ++i, xpos, ypos));
                }
            }
            this.func_75146_a(new Slot(this.inventory_, ++i, 19, 48));
            this.func_75146_a(new Slot(this.inventory_, ++i, 55, 48));
            this.func_75146_a(new Slot(this.inventory_, ++i, 91, 48));
            for (int x2 = 0; x2 < 9; ++x2) {
                this.func_75146_a(new Slot((IInventory)player_inventory, x2, 8 + x2 * 18, 144));
            }
            for (y = 0; y < 3; ++y) {
                for (x = 0; x < 9; ++x) {
                    this.func_75146_a(new Slot((IInventory)player_inventory, x + y * 9 + 9, 8 + x * 18, 86 + y * 18));
                }
            }
            this.func_216961_a(this.fields_);
        }

        public boolean func_75145_c(PlayerEntity player) {
            return this.inventory_.func_70300_a(player);
        }

        public ItemStack func_82846_b(PlayerEntity player, int index) {
            Slot slot = this.func_75139_a(index);
            if (slot == null || !slot.func_75216_d()) {
                return ItemStack.field_190927_a;
            }
            ItemStack slot_stack = slot.func_75211_c();
            ItemStack transferred = slot_stack.func_77946_l();
            if (index >= 0 && index < 15) {
                if (!this.func_75135_a(slot_stack, 15, 51, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index >= 15 && index <= 51) {
                if (!this.func_75135_a(slot_stack, 0, 12, false)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                return ItemStack.field_190927_a;
            }
            if (slot_stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slot_stack.func_190916_E() == transferred.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slot_stack);
            return transferred;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(CompoundNBT nbt) {
            Networking.PacketContainerSyncClientToServer.sendToServer(this.field_75152_c, nbt);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(String key, int value) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a(key, value);
            Networking.PacketContainerSyncClientToServer.sendToServer(this.field_75152_c, nbt);
        }

        @Override
        public void onServerPacketReceived(int windowId, CompoundNBT nbt) {
        }

        @Override
        public void onClientPacketReceived(int windowId, PlayerEntity player, CompoundNBT nbt) {
            if (!(this.inventory_ instanceof DropperTileEntity)) {
                return;
            }
            DropperTileEntity te = (DropperTileEntity)this.inventory_;
            if (nbt.func_74764_b("drop_speed")) {
                te.drop_speed_ = MathHelper.func_76125_a((int)nbt.func_74762_e("drop_speed"), (int)0, (int)100);
            }
            if (nbt.func_74764_b("drop_xdev")) {
                te.drop_xdev_ = MathHelper.func_76125_a((int)nbt.func_74762_e("drop_xdev"), (int)-100, (int)100);
            }
            if (nbt.func_74764_b("drop_ydev")) {
                te.drop_ydev_ = MathHelper.func_76125_a((int)nbt.func_74762_e("drop_ydev"), (int)-100, (int)100);
            }
            if (nbt.func_74764_b("drop_count")) {
                te.drop_count_ = MathHelper.func_76125_a((int)nbt.func_74762_e("drop_count"), (int)1, (int)32);
            }
            if (nbt.func_74764_b("drop_period")) {
                te.drop_period_ = MathHelper.func_76125_a((int)nbt.func_74762_e("drop_period"), (int)0, (int)100);
            }
            if (nbt.func_74764_b("drop_logic")) {
                te.drop_logic_ = nbt.func_74762_e("drop_logic");
            }
            if (nbt.func_74764_b("manual_rstrigger") && nbt.func_74762_e("manual_rstrigger") != 0) {
                te.block_power_signal_ = true;
                te.block_power_updated_ = true;
                te.tick_timer_ = 1;
            }
            if (nbt.func_74764_b("manual_trigger") && nbt.func_74762_e("manual_trigger") != 0) {
                te.tick_timer_ = 1;
                te.triggered_ = true;
            }
            te.func_70296_d();
        }
    }

    public static class DropperTileEntity
    extends TileEntity
    implements ITickableTileEntity,
    INameable,
    IInventory,
    INamedContainerProvider,
    ISidedInventory {
        public static final int NUM_OF_FIELDS = 16;
        public static final int TICK_INTERVAL = 32;
        public static final int NUM_OF_SLOTS = 15;
        public static final int INPUT_SLOTS_FIRST = 0;
        public static final int INPUT_SLOTS_SIZE = 12;
        public static final int CTRL_SLOTS_FIRST = 12;
        public static final int CTRL_SLOTS_SIZE = 3;
        public static final int SHUTTER_CLOSE_DELAY = 40;
        public static final int MAX_DROP_COUNT = 32;
        public static final int DROP_PERIOD_OFFSET = 10;
        public static final int DROPLOGIC_FILTER_ANDGATE = 1;
        public static final int DROPLOGIC_EXTERN_ANDGATE = 2;
        public static final int DROPLOGIC_SILENT_DROP = 4;
        public static final int DROPLOGIC_SILENT_OPEN = 8;
        public static final int DROPLOGIC_CONTINUOUS = 16;
        private int[] filter_matches_ = new int[3];
        private int open_timer_ = 0;
        private int drop_timer_ = 0;
        private boolean triggered_ = false;
        private boolean block_power_signal_ = false;
        private boolean block_power_updated_ = false;
        private int drop_speed_ = 10;
        private int drop_noise_ = 0;
        private int drop_xdev_ = 0;
        private int drop_ydev_ = 0;
        private int drop_count_ = 1;
        private int drop_logic_ = 2;
        private int drop_period_ = 0;
        private int drop_slot_index_ = 0;
        private int tick_timer_ = 0;
        protected NonNullList<ItemStack> stacks_;
        protected final Inventories.SlotRange slot_range_ = new Inventories.SlotRange(this, 0, 12);
        protected final IIntArray fields = new IntArray(16){

            public int func_221476_a(int id) {
                switch (id) {
                    case 0: {
                        return drop_speed_;
                    }
                    case 1: {
                        return drop_xdev_;
                    }
                    case 2: {
                        return drop_ydev_;
                    }
                    case 3: {
                        return drop_noise_;
                    }
                    case 4: {
                        return drop_count_;
                    }
                    case 5: {
                        return drop_logic_;
                    }
                    case 6: {
                        return drop_period_;
                    }
                    case 9: {
                        return drop_timer_;
                    }
                    case 10: {
                        return open_timer_;
                    }
                    case 11: {
                        return block_power_signal_ ? 1 : 0;
                    }
                    case 12: {
                        return filter_matches_[0];
                    }
                    case 13: {
                        return filter_matches_[1];
                    }
                    case 14: {
                        return filter_matches_[2];
                    }
                    case 15: {
                        return drop_slot_index_;
                    }
                }
                return 0;
            }

            public void func_221477_a(int id, int value) {
                switch (id) {
                    case 0: {
                        drop_speed_ = MathHelper.func_76125_a((int)value, (int)0, (int)100);
                        return;
                    }
                    case 1: {
                        drop_xdev_ = MathHelper.func_76125_a((int)value, (int)-100, (int)100);
                        return;
                    }
                    case 2: {
                        drop_ydev_ = MathHelper.func_76125_a((int)value, (int)-100, (int)100);
                        return;
                    }
                    case 3: {
                        drop_noise_ = MathHelper.func_76125_a((int)value, (int)0, (int)100);
                        return;
                    }
                    case 4: {
                        drop_count_ = MathHelper.func_76125_a((int)value, (int)1, (int)32);
                        return;
                    }
                    case 5: {
                        drop_logic_ = value;
                        return;
                    }
                    case 6: {
                        drop_period_ = MathHelper.func_76125_a((int)value, (int)0, (int)100);
                        return;
                    }
                    case 9: {
                        drop_timer_ = MathHelper.func_76125_a((int)value, (int)0, (int)400);
                        return;
                    }
                    case 10: {
                        open_timer_ = MathHelper.func_76125_a((int)value, (int)0, (int)400);
                        return;
                    }
                    case 11: {
                        block_power_signal_ = value != 0;
                        return;
                    }
                    case 12: {
                        ((DropperTileEntity)this).filter_matches_[0] = value & 3;
                        return;
                    }
                    case 13: {
                        ((DropperTileEntity)this).filter_matches_[1] = value & 3;
                        return;
                    }
                    case 14: {
                        ((DropperTileEntity)this).filter_matches_[2] = value & 3;
                        return;
                    }
                    case 15: {
                        drop_slot_index_ = MathHelper.func_76125_a((int)value, (int)0, (int)11);
                        return;
                    }
                }
            }
        };
        LazyOptional<? extends IItemHandler>[] item_handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP});
        private static final int[] SIDED_INV_SLOTS = new int[12];

        public static void on_config(int cooldown_ticks) {
        }

        public DropperTileEntity() {
            this(ModContent.TET_FACTORY_DROPPER);
        }

        public DropperTileEntity(TileEntityType<?> te_type) {
            super(te_type);
            this.stacks_ = NonNullList.func_191197_a((int)15, (Object)ItemStack.field_190927_a);
            this.reset_rtstate();
        }

        public CompoundNBT clear_getnbt() {
            CompoundNBT nbt = new CompoundNBT();
            this.writenbt(nbt, false);
            for (int i = 0; i < this.stacks_.size(); ++i) {
                this.stacks_.set(i, (Object)ItemStack.field_190927_a);
            }
            this.reset_rtstate();
            this.triggered_ = false;
            this.block_power_updated_ = false;
            return nbt;
        }

        public void reset_rtstate() {
            this.block_power_signal_ = false;
            this.block_power_updated_ = false;
            for (int i = 0; i < this.filter_matches_.length; ++i) {
                this.filter_matches_[i] = 0;
            }
        }

        public void readnbt(CompoundNBT nbt, boolean update_packet) {
            this.stacks_ = NonNullList.func_191197_a((int)15, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.stacks_);
            while (this.stacks_.size() < 15) {
                this.stacks_.add((Object)ItemStack.field_190927_a);
            }
            this.block_power_signal_ = nbt.func_74767_n("powered");
            this.open_timer_ = nbt.func_74762_e("open_timer");
            this.drop_speed_ = nbt.func_74762_e("drop_speed");
            this.drop_noise_ = nbt.func_74762_e("drop_noise");
            this.drop_xdev_ = nbt.func_74762_e("drop_xdev");
            this.drop_ydev_ = nbt.func_74762_e("drop_ydev");
            this.drop_slot_index_ = nbt.func_74762_e("drop_slot_index");
            this.drop_count_ = MathHelper.func_76125_a((int)nbt.func_74762_e("drop_count"), (int)1, (int)32);
            this.drop_logic_ = nbt.func_74762_e("drop_logic");
            this.drop_period_ = nbt.func_74762_e("drop_period");
        }

        protected void writenbt(CompoundNBT nbt, boolean update_packet) {
            ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.stacks_);
            nbt.func_74757_a("powered", this.block_power_signal_);
            nbt.func_74768_a("open_timer", this.open_timer_);
            nbt.func_74768_a("drop_speed", this.drop_speed_);
            nbt.func_74768_a("drop_noise", this.drop_noise_);
            nbt.func_74768_a("drop_xdev", this.drop_xdev_);
            nbt.func_74768_a("drop_ydev", this.drop_ydev_);
            nbt.func_74768_a("drop_slot_index", this.drop_slot_index_);
            nbt.func_74768_a("drop_count", this.drop_count_);
            nbt.func_74768_a("drop_logic", this.drop_logic_);
            nbt.func_74768_a("drop_period", this.drop_period_);
        }

        public void block_updated() {
            boolean powered = this.field_145850_b.func_175640_z(this.field_174879_c);
            if (this.block_power_signal_ != powered) {
                this.block_power_updated_ = true;
            }
            this.block_power_signal_ = powered;
            this.tick_timer_ = 1;
        }

        public boolean is_input_slot(int index) {
            return index >= 0 && index < 12;
        }

        public void func_145839_a(CompoundNBT nbt) {
            super.func_145839_a(nbt);
            this.readnbt(nbt, false);
        }

        public CompoundNBT func_189515_b(CompoundNBT nbt) {
            super.func_189515_b(nbt);
            this.writenbt(nbt, false);
            return nbt;
        }

        public void func_145843_s() {
            super.func_145843_s();
            Arrays.stream(this.item_handlers).forEach(LazyOptional::invalidate);
        }

        public ITextComponent func_200200_C_() {
            Block block = this.func_195044_w().func_177230_c();
            return new StringTextComponent(block != null ? block.func_149739_a() : "Factory dropper");
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_200201_e() {
            return this.func_200200_C_();
        }

        public ITextComponent func_145748_c_() {
            return super.func_145748_c_();
        }

        public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
            return new DropperContainer(id, inventory, this, IWorldPosCallable.func_221488_a((World)this.field_145850_b, (BlockPos)this.field_174879_c), this.fields);
        }

        public int func_70302_i_() {
            return this.stacks_.size();
        }

        public boolean func_191420_l() {
            for (ItemStack stack : this.stacks_) {
                if (stack.func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public ItemStack func_70301_a(int index) {
            return index < this.func_70302_i_() ? (ItemStack)this.stacks_.get(index) : ItemStack.field_190927_a;
        }

        public ItemStack func_70298_a(int index, int count) {
            return ItemStackHelper.func_188382_a(this.stacks_, (int)index, (int)count);
        }

        public ItemStack func_70304_b(int index) {
            return ItemStackHelper.func_188383_a(this.stacks_, (int)index);
        }

        public void func_70299_a(int index, ItemStack stack) {
            this.stacks_.set(index, (Object)stack);
            if (stack.func_190916_E() > this.func_70297_j_()) {
                stack.func_190920_e(this.func_70297_j_());
            }
            if (this.tick_timer_ > 8) {
                this.tick_timer_ = 8;
            }
            this.func_70296_d();
        }

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
            super.func_70296_d();
        }

        public boolean func_70300_a(PlayerEntity player) {
            return this.func_174877_v().func_177951_i((Vec3i)player.func_180425_c()) < 36.0;
        }

        public void func_174889_b(PlayerEntity player) {
        }

        public void func_174886_c(PlayerEntity player) {
            this.func_70296_d();
        }

        public boolean func_94041_b(int index, ItemStack stack) {
            return true;
        }

        public void func_174888_l() {
            this.stacks_.clear();
        }

        public int[] func_180463_a(Direction side) {
            return SIDED_INV_SLOTS;
        }

        public boolean func_180462_a(int index, ItemStack stack, Direction direction) {
            return this.is_input_slot(index) && this.func_94041_b(index, stack);
        }

        public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
            return false;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return this.item_handlers[0].cast();
            }
            return super.getCapability(capability, facing);
        }

        private static void drop(World world, BlockPos pos, Direction facing, ItemStack stack, int speed_percent, int xdeviation, int ydeviation, int noise_percent) {
            double ofs = facing == Direction.DOWN ? 0.8 : 0.7;
            Vec3d v0 = new Vec3d((double)facing.func_82601_c(), (double)facing.func_96559_d(), (double)facing.func_82599_e());
            ItemEntity ei = new ItemEntity(world, (double)pos.func_177958_n() + 0.5 + ofs * v0.field_72450_a, (double)pos.func_177956_o() + 0.5 + ofs * v0.field_72448_b, (double)pos.func_177952_p() + 0.5 + ofs * v0.field_72449_c, stack);
            if (xdeviation != 0 || ydeviation != 0) {
                double vdx = 0.01 * (double)MathHelper.func_76125_a((int)xdeviation, (int)-100, (int)100);
                double vdy = 0.01 * (double)MathHelper.func_76125_a((int)ydeviation, (int)-100, (int)100);
                switch (facing) {
                    case DOWN: {
                        v0 = v0.func_72441_c(vdx, 0.0, -vdy);
                        break;
                    }
                    case NORTH: {
                        v0 = v0.func_72441_c(vdx, vdy, 0.0);
                        break;
                    }
                    case SOUTH: {
                        v0 = v0.func_72441_c(-vdx, vdy, 0.0);
                        break;
                    }
                    case EAST: {
                        v0 = v0.func_72441_c(0.0, vdy, vdx);
                        break;
                    }
                    case WEST: {
                        v0 = v0.func_72441_c(0.0, vdy, -vdx);
                        break;
                    }
                    case UP: {
                        v0 = v0.func_72441_c(vdx, 0.0, vdy);
                    }
                }
            }
            if (noise_percent > 0) {
                v0 = v0.func_72441_c((world.field_73012_v.nextDouble() - 0.5) * 0.001 * (double)noise_percent, (world.field_73012_v.nextDouble() - 0.5) * 0.001 * (double)noise_percent, (world.field_73012_v.nextDouble() - 0.5) * 0.001 * (double)noise_percent);
            }
            if (speed_percent < 5) {
                speed_percent = 5;
            }
            double speed = 0.01 * (double)speed_percent;
            if (noise_percent > 0) {
                speed += (world.field_73012_v.nextDouble() - 0.5) * 1.0E-4 * (double)noise_percent;
            }
            v0 = v0.func_72432_b().func_186678_a(speed);
            ei.func_213293_j(v0.field_72450_a, v0.field_72448_b, v0.field_72449_c);
            ei.field_70133_I = true;
            world.func_217376_c((Entity)ei);
        }

        private static Tuple<Boolean, List<ItemStack>> try_eject(World world, BlockPos pos, Direction facing, ItemStack[] stacks, int speed_percent, int xdeviation, int ydeviation, int noise_percent) {
            IItemHandler ih;
            TileEntity te;
            if (Arrays.stream(stacks).allMatch(e -> e.func_190926_b())) {
                return new Tuple((Object)false, Arrays.asList(stacks));
            }
            if (with_adjacent_item_insertion && (te = world.func_175625_s(pos.func_177972_a(facing))) != null && (ih = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing == null ? null : facing.func_176734_d()).orElse(null)) != null) {
                boolean inserted = false;
                ArrayList<ItemStack> remaining = new ArrayList<ItemStack>();
                for (int i = 0; i < stacks.length; ++i) {
                    ItemStack rs = Inventories.insert(ih, stacks[i].func_77946_l(), false);
                    if (rs.func_190916_E() < stacks[i].func_190916_E()) {
                        inserted = true;
                    }
                    if (rs.func_190926_b()) continue;
                    remaining.add(rs);
                }
                return new Tuple((Object)inserted, remaining);
            }
            for (int i = 0; i < stacks.length; ++i) {
                if (stacks[i].func_190926_b()) continue;
                DropperTileEntity.drop(world, pos, facing, stacks[i], speed_percent, xdeviation, ydeviation, noise_percent);
            }
            return new Tuple((Object)true, Collections.emptyList());
        }

        @Nullable
        BlockState update_blockstate() {
            boolean open;
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(state.func_177230_c() instanceof DropperBlock)) {
                return null;
            }
            boolean bl = open = this.open_timer_ > 0;
            if ((Boolean)state.func_177229_b((IProperty)DropperBlock.OPEN) != open) {
                state = (BlockState)state.func_206870_a((IProperty)DropperBlock.OPEN, (Comparable)Boolean.valueOf(open));
                this.field_145850_b.func_180501_a(this.field_174879_c, state, 18);
                if ((this.drop_logic_ & 8) == 0) {
                    if (open) {
                        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187879_gP, SoundCategory.BLOCKS, 0.08f, 3.0f);
                    } else {
                        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187877_gO, SoundCategory.BLOCKS, 0.08f, 3.0f);
                    }
                }
            }
            return state;
        }

        private static int next_slot(int i) {
            return i < 11 ? i + 1 : 0;
        }

        public void func_73660_a() {
            BlockState state;
            boolean tr;
            boolean filter_trigger;
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            if (--this.open_timer_ < 0) {
                this.open_timer_ = 0;
            }
            if (this.drop_timer_ > 0 && --this.drop_timer_ == 0) {
                this.func_70296_d();
            }
            if (--this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 32;
            if (!(this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof DropperBlock)) {
                return;
            }
            boolean continuous_mode = (this.drop_logic_ & 0x10) != 0;
            boolean dirty = this.block_power_updated_;
            boolean redstone_trigger = this.block_power_signal_ && (this.block_power_updated_ || continuous_mode);
            boolean droppable_slot_found = false;
            for (int i = 0; i < 12; ++i) {
                if (((ItemStack)this.stacks_.get(i)).func_190916_E() < this.drop_count_) continue;
                droppable_slot_found = true;
                break;
            }
            int filter_nset = 0;
            int[] last_filter_matches_ = (int[])this.filter_matches_.clone();
            boolean slot_assigned = false;
            block1: for (int ci = 0; ci < 3; ++ci) {
                this.filter_matches_[ci] = 0;
                ItemStack cmp_stack = (ItemStack)this.stacks_.get(12 + ci);
                if (cmp_stack.func_190926_b()) continue;
                this.filter_matches_[ci] = 1;
                int cmp_stack_count = cmp_stack.func_190916_E();
                int inventory_item_count = 0;
                int slot = this.drop_slot_index_;
                for (int i = 0; i < 12; ++i) {
                    ItemStack inp_stack = (ItemStack)this.stacks_.get(slot);
                    if (Inventories.areItemStacksDifferent(inp_stack, cmp_stack)) {
                        slot = DropperTileEntity.next_slot(slot);
                        continue;
                    }
                    if ((inventory_item_count += inp_stack.func_190916_E()) < cmp_stack_count) {
                        slot = DropperTileEntity.next_slot(slot);
                        continue;
                    }
                    this.filter_matches_[ci] = 2;
                    continue block1;
                }
            }
            int nmatched = 0;
            for (int i = 0; i < this.filter_matches_.length; ++i) {
                if (this.filter_matches_[i] > 0) {
                    ++filter_nset;
                }
                if (this.filter_matches_[i] > 1) {
                    ++nmatched;
                }
                if (this.filter_matches_[i] == last_filter_matches_[i]) continue;
                dirty = true;
            }
            boolean filter_defined = filter_nset > 0;
            boolean bl = filter_trigger = filter_nset > 0 && nmatched > 0;
            if ((this.drop_logic_ & 1) != 0 && nmatched != filter_nset) {
                filter_trigger = false;
            }
            boolean trigger = filter_defined ? ((this.drop_logic_ & 2) != 0 ? filter_trigger && redstone_trigger : filter_trigger || redstone_trigger) : redstone_trigger;
            if (this.triggered_) {
                this.triggered_ = false;
                trigger = true;
            }
            if (!droppable_slot_found) {
                if (this.open_timer_ > 10) {
                    this.open_timer_ = 10;
                }
            } else if (trigger || filter_trigger || redstone_trigger) {
                this.open_timer_ = 40;
            }
            this.block_power_updated_ = this.block_power_signal_ != (tr = this.field_145850_b.func_175640_z(this.field_174879_c));
            this.block_power_signal_ = tr;
            if (this.block_power_updated_) {
                dirty = true;
            }
            if ((state = this.update_blockstate()) == null) {
                this.block_power_signal_ = false;
                return;
            }
            if (trigger && this.drop_timer_ <= 0) {
                ItemStack[] drop_stacks = new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};
                if (!filter_trigger) {
                    for (int i = 0; i < 12; ++i) {
                        if (this.drop_slot_index_ >= 12) {
                            this.drop_slot_index_ = 0;
                        }
                        int ic = this.drop_slot_index_;
                        this.drop_slot_index_ = DropperTileEntity.next_slot(this.drop_slot_index_);
                        ItemStack ds = (ItemStack)this.stacks_.get(ic);
                        if (ds.func_190926_b() || ds.func_190916_E() < this.drop_count_) continue;
                        drop_stacks[0] = ds.func_77979_a(this.drop_count_);
                        this.stacks_.set(ic, (Object)ds);
                        break;
                    }
                } else {
                    for (int fi = 0; fi < this.filter_matches_.length; ++fi) {
                        if (this.filter_matches_[fi] <= 1) continue;
                        drop_stacks[fi] = ((ItemStack)this.stacks_.get(12 + fi)).func_77946_l();
                        int ntoremove = drop_stacks[fi].func_190916_E();
                        for (int i = 11; i >= 0 && ntoremove > 0; --i) {
                            ItemStack stack = (ItemStack)this.stacks_.get(i);
                            if (Inventories.areItemStacksDifferent(stack, drop_stacks[fi])) continue;
                            if (stack.func_190916_E() <= ntoremove) {
                                ntoremove -= stack.func_190916_E();
                                this.stacks_.set(i, (Object)ItemStack.field_190927_a);
                                continue;
                            }
                            stack.func_190918_g(ntoremove);
                            ntoremove = 0;
                            this.stacks_.set(i, (Object)stack);
                        }
                        if (ntoremove <= 0) continue;
                        drop_stacks[fi].func_190918_g(ntoremove);
                    }
                }
                Tuple<Boolean, List<ItemStack>> res = DropperTileEntity.try_eject(this.field_145850_b, this.field_174879_c, (Direction)state.func_177229_b((IProperty)DropperBlock.FACING), drop_stacks, this.drop_speed_, this.drop_xdev_, this.drop_ydev_, this.drop_noise_);
                boolean dropped = (Boolean)res.func_76341_a();
                List remaining = (List)res.func_76340_b();
                for (ItemStack st : remaining) {
                    if (this.slot_range_.insert(st).func_190926_b()) continue;
                    ModEngineersDecor.logger().debug("NOT ALL NON-DROPPED ITEMS PUT BACK:" + st);
                }
                if (dropped || !remaining.isEmpty()) {
                    dirty = true;
                }
                if (dropped) {
                    this.drop_timer_ = 10 + this.drop_period_ * 2;
                }
                if (dropped && (this.drop_logic_ & 4) == 0) {
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187889_gU, SoundCategory.BLOCKS, 0.1f, 4.0f);
                }
                for (int i = 0; i < 12 && ((ItemStack)this.stacks_.get(this.drop_slot_index_)).func_190926_b(); ++i) {
                    this.drop_slot_index_ = DropperTileEntity.next_slot(this.drop_slot_index_);
                }
            }
            if (dirty) {
                this.func_70296_d();
            }
            if (trigger && this.tick_timer_ > 10) {
                this.tick_timer_ = 10;
            }
        }

        static {
            for (int i = 0; i < 12; ++i) {
                DropperTileEntity.SIDED_INV_SLOTS[i] = i + 0;
            }
        }
    }

    public static class DropperBlock
    extends DecorBlock.Directed
    implements IDecorBlock {
        public static final BooleanProperty OPEN = DoorBlock.field_176519_b;

        public DropperBlock(long config, Block.Properties builder, AxisAlignedBB unrotatedAABB) {
            super(config, builder, unrotatedAABB);
        }

        @Override
        public StandardBlocks.IStandardBlock.RenderTypeHint getRenderTypeHint() {
            return StandardBlocks.IStandardBlock.RenderTypeHint.SOLID;
        }

        @Override
        public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
            return VoxelShapes.func_197868_b();
        }

        @Override
        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            super.func_206840_a(builder);
            builder.func_206894_a(new IProperty[]{OPEN});
        }

        @Override
        @Nullable
        public BlockState func_196258_a(BlockItemUseContext context) {
            return (BlockState)super.func_196258_a(context).func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false));
        }

        public boolean func_149740_M(BlockState state) {
            return true;
        }

        public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
            return Container.func_178144_a((TileEntity)world.func_175625_s(pos));
        }

        public boolean hasTileEntity(BlockState state) {
            return true;
        }

        @Nullable
        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return new DropperTileEntity();
        }

        public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
            if (world.field_72995_K) {
                return;
            }
            if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("tedata")) {
                return;
            }
            CompoundNBT te_nbt = stack.func_77978_p().func_74775_l("tedata");
            if (te_nbt.isEmpty()) {
                return;
            }
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof DropperTileEntity)) {
                return;
            }
            ((DropperTileEntity)te).readnbt(te_nbt, false);
            ((DropperTileEntity)te).reset_rtstate();
            ((DropperTileEntity)te).func_70296_d();
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, World world, BlockPos pos, TileEntity te, boolean explosion) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (world.field_72995_K) {
                return stacks;
            }
            if (!(te instanceof DropperTileEntity)) {
                return stacks;
            }
            if (!explosion) {
                ItemStack stack = new ItemStack((IItemProvider)this, 1);
                CompoundNBT te_nbt = ((DropperTileEntity)te).clear_getnbt();
                if (!te_nbt.isEmpty()) {
                    CompoundNBT nbt = new CompoundNBT();
                    nbt.func_218657_a("tedata", (INBT)te_nbt);
                    stack.func_77982_d(nbt);
                }
                stacks.add(stack);
            } else {
                for (ItemStack stack : ((DropperTileEntity)te).stacks_) {
                    if (stack.func_190926_b()) continue;
                    stacks.add(stack);
                }
                ((DropperTileEntity)te).reset_rtstate();
            }
            return stacks;
        }

        @Override
        public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof DropperTileEntity)) {
                return ActionResultType.FAIL;
            }
            if (!(player instanceof ServerPlayerEntity) && !(player instanceof FakePlayer)) {
                return ActionResultType.FAIL;
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)te));
            return ActionResultType.SUCCESS;
        }

        public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean unused) {
            if (!(world instanceof World) || world.field_72995_K) {
                return;
            }
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof DropperTileEntity)) {
                return;
            }
            ((DropperTileEntity)te).block_updated();
        }

        public boolean func_149744_f(BlockState state) {
            return true;
        }

        public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
            return 0;
        }

        public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
            return 0;
        }
    }
}

