/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.blocks.DecorBlock;
import wile.engineersdecor.blocks.IDecorBlock;
import wile.engineersdecor.libmc.blocks.StandardBlocks;

public class EdFluidFunnel {
    private static boolean with_device_fluid_handler_collection = false;

    public static void on_config(boolean with_tank_fluid_collection) {
        with_device_fluid_handler_collection = with_tank_fluid_collection;
        ModEngineersDecor.logger().info("Config fluid funnel: tank-fluid-collection:" + with_device_fluid_handler_collection);
    }

    public static class FluidFunnelTileEntity
    extends TileEntity
    implements ITickableTileEntity,
    ICapabilityProvider,
    IFluidTank {
        public static final int TANK_CAPACITY = 3000;
        public static final int TICK_INTERVAL = 10;
        public static final int COLLECTION_INTERVAL = 40;
        public static final int MAX_TRACK_RADIUS = 16;
        public static final int MAX_TRACKING_STEPS_PER_CYCLE = 72;
        public static final int MAX_TRACKING_STEPS_PER_CYCLE_INTENSIVE = 1024;
        public static final int MAX_TRACK_RADIUS_SQ = 256;
        public static final int INTENSIVE_SEARCH_TRIGGER_THRESHOLD = 16;
        private FluidStack tank_ = FluidStack.EMPTY;
        private int tick_timer_ = 0;
        private int collection_timer_ = 0;
        private int no_fluid_found_counter_ = 0;
        private int intensive_search_counter_ = 0;
        private int total_pick_counter_ = 0;
        private BlockPos last_pick_pos_ = BlockPos.field_177992_a;
        private ArrayList<Vec3i> search_offsets_ = null;
        private final LazyOptional<IFluidHandler> fluid_handler_ = LazyOptional.of(() -> new OutputFluidHandler(this));

        public void block_changed() {
            this.tick_timer_ = 10;
        }

        public FluidFunnelTileEntity() {
            this(ModContent.TET_SMALL_FLUID_FUNNEL);
        }

        public FluidFunnelTileEntity(TileEntityType<?> te_type) {
            super(te_type);
        }

        public void readnbt(CompoundNBT nbt) {
            this.tank_ = !nbt.func_74764_b("tank") ? FluidStack.EMPTY : FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt.func_74775_l("tank"));
        }

        public void writenbt(CompoundNBT nbt) {
            if (!this.tank_.isEmpty()) {
                nbt.func_218657_a("tank", (INBT)this.tank_.writeToNBT(new CompoundNBT()));
            }
        }

        public void func_145839_a(CompoundNBT nbt) {
            super.func_145839_a(nbt);
            this.readnbt(nbt);
        }

        public CompoundNBT func_189515_b(CompoundNBT nbt) {
            super.func_189515_b(nbt);
            this.writenbt(nbt);
            return nbt;
        }

        public void func_145843_s() {
            super.func_145843_s();
            this.fluid_handler_.invalidate();
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return this.fluid_handler_.cast();
            }
            return super.getCapability(capability, facing);
        }

        @Nonnull
        public FluidStack getFluid() {
            return this.tank_.copy();
        }

        public int getFluidAmount() {
            return this.tank_.getAmount();
        }

        public int getCapacity() {
            return 3000;
        }

        public boolean isFluidValid(FluidStack stack) {
            return true;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource == null || this.tank_.isEmpty()) {
                return FluidStack.EMPTY;
            }
            return !this.tank_.isFluidEqual(resource) ? FluidStack.EMPTY : this.drain(resource.getAmount(), action);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (this.tank_.isEmpty()) {
                return FluidStack.EMPTY;
            }
            FluidStack res = this.tank_.copy();
            maxDrain = MathHelper.func_76125_a((int)maxDrain, (int)0, (int)this.tank_.getAmount());
            res.setAmount(maxDrain);
            if (action != IFluidHandler.FluidAction.EXECUTE) {
                return res;
            }
            this.tank_.setAmount(this.tank_.getAmount() - maxDrain);
            if (this.tank_.getAmount() <= 0) {
                this.tank_ = FluidStack.EMPTY;
            }
            return res;
        }

        private IFluidState get_fluidstate(BlockPos pos) {
            Block collection_block = this.field_145850_b.func_180495_p(pos).func_177230_c();
            if (!(collection_block instanceof IFluidBlock || collection_block instanceof FlowingFluidBlock || collection_block instanceof IWaterLoggable)) {
                return Fluids.field_204541_a.func_207188_f();
            }
            return this.field_145850_b.func_204610_c(pos);
        }

        private boolean try_pick(BlockPos pos, IFluidState fluidstate) {
            FluidStack fs;
            if (!fluidstate.func_206889_d()) {
                return false;
            }
            IFluidHandler hnd = (IFluidHandler)FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)pos, null).orElse(null);
            if (hnd != null) {
                fs = hnd.drain(3000, IFluidHandler.FluidAction.EXECUTE);
            } else {
                fs = new FluidStack(fluidstate.func_206886_c(), 1000);
                BlockState state = this.field_145850_b.func_180495_p(pos);
                if (state instanceof IBucketPickupHandler) {
                    ((IBucketPickupHandler)state).func_204508_a((IWorld)this.field_145850_b, pos, state);
                } else {
                    this.field_145850_b.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                }
            }
            if (fs == null || fs.isEmpty()) {
                return false;
            }
            if (this.tank_.isEmpty()) {
                this.tank_ = fs.copy();
            } else if (this.tank_.isFluidEqual(fs)) {
                this.tank_.setAmount(MathHelper.func_76125_a((int)(this.tank_.getAmount() + fs.getAmount()), (int)0, (int)3000));
            } else {
                return false;
            }
            return true;
        }

        private boolean can_pick(BlockPos pos, IFluidState fluidstate) {
            if (fluidstate.func_206889_d()) {
                return true;
            }
            IFluidHandler hnd = (IFluidHandler)FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)pos, null).orElse(null);
            if (hnd == null) {
                return false;
            }
            FluidStack fs = hnd.drain(3000, IFluidHandler.FluidAction.SIMULATE);
            return fs != null && !fs.isEmpty() && fluidstate.func_206886_c().func_207187_a(fs.getFluid());
        }

        private void rebuild_search_offsets(boolean intensive) {
            this.search_offsets_ = new ArrayList(9);
            this.search_offsets_.add(new Vec3i(0, 1, 0));
            ArrayList<Vec3i> ofs = new ArrayList<Vec3i>(Arrays.asList(new Vec3i(-1, 0, 0), new Vec3i(1, 0, 0), new Vec3i(0, 0, -1), new Vec3i(0, 0, 1)));
            if (intensive || this.total_pick_counter_ > 50) {
                Collections.shuffle(ofs);
            }
            this.search_offsets_.addAll(ofs);
            if (intensive) {
                ofs = new ArrayList<Vec3i>(Arrays.asList(new Vec3i(-1, 1, 0), new Vec3i(1, 1, 0), new Vec3i(0, 1, -1), new Vec3i(0, 1, 1)));
                Collections.shuffle(ofs);
                this.search_offsets_.addAll(ofs);
            }
        }

        private boolean try_collect(BlockPos collection_pos) {
            int max;
            boolean intensive;
            IFluidState collection_fluidstate = this.get_fluidstate(collection_pos);
            if (collection_fluidstate.func_206888_e()) {
                return false;
            }
            Fluid fluid_to_collect = collection_fluidstate.func_206886_c();
            if (!this.tank_.isEmpty() && !this.tank_.getFluid().func_207187_a(fluid_to_collect)) {
                return false;
            }
            if (this.try_pick(collection_pos, collection_fluidstate)) {
                this.last_pick_pos_ = collection_pos;
                return true;
            }
            if (this.last_pick_pos_ == null || this.last_pick_pos_.func_177951_i((Vec3i)collection_pos) > 256.0) {
                this.last_pick_pos_ = collection_pos;
                this.search_offsets_ = null;
            }
            BlockPos pos = this.last_pick_pos_;
            HashSet<BlockPos> checked = new HashSet<BlockPos>();
            Stack<BlockPos> trail = new Stack<BlockPos>();
            trail.add(pos);
            checked.add(pos);
            int steps = 0;
            boolean bl = intensive = this.no_fluid_found_counter_ >= 16;
            if (intensive) {
                this.no_fluid_found_counter_ = 0;
                ++this.intensive_search_counter_;
            }
            if (this.search_offsets_ == null) {
                this.rebuild_search_offsets(intensive);
            }
            int n = max = intensive ? 1024 : 72;
            while (++steps <= max) {
                int num_adjacent = 0;
                for (int i = 0; i < this.search_offsets_.size(); ++i) {
                    BlockPos p = pos.func_177971_a(this.search_offsets_.get(i));
                    if (checked.contains(p)) continue;
                    checked.add(p);
                    ++steps;
                    IFluidState fluidstate = this.get_fluidstate(p);
                    if (!fluidstate.func_206886_c().func_207187_a(fluid_to_collect)) continue;
                    ++num_adjacent;
                    pos = p;
                    trail.push(pos);
                    if (steps < 512) {
                        int max_surface_search = 512 - steps;
                        for (int k = 0; k < max_surface_search; ++k) {
                            IFluidState fs = this.get_fluidstate(pos.func_177984_a());
                            if (!this.can_pick(pos.func_177984_a(), fs)) break;
                            fluidstate = fs;
                            pos = pos.func_177984_a();
                            trail.push(pos);
                        }
                    }
                    if (!this.try_pick(pos, fluidstate)) continue;
                    this.last_pick_pos_ = pos;
                    this.no_fluid_found_counter_ = 0;
                    this.search_offsets_ = null;
                    if (++this.total_pick_counter_ > 50 && this.field_145850_b.field_73012_v.nextInt(10) == 0) {
                        this.last_pick_pos_ = collection_pos;
                    }
                    return true;
                }
                if (trail.isEmpty()) break;
                if (num_adjacent != 0) continue;
                pos = (BlockPos)trail.pop();
            }
            if (this.intensive_search_counter_ > 2) {
                this.field_145850_b.func_217377_a(pos, false);
            }
            this.last_pick_pos_ = collection_pos;
            this.search_offsets_ = null;
            ++this.no_fluid_found_counter_;
            return false;
        }

        public void func_73660_a() {
            int fill_level;
            IFluidHandler fh;
            if (this.field_145850_b.field_72995_K || --this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 10;
            this.collection_timer_ += 10;
            BlockState funnel_state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(funnel_state.func_177230_c() instanceof FluidFunnelBlock)) {
                return;
            }
            boolean dirty = false;
            if (this.collection_timer_ >= 40 && (this.tank_ == null || this.tank_.getAmount() <= 2000)) {
                this.collection_timer_ = 0;
                if (!this.field_145850_b.func_175640_z(this.field_174879_c)) {
                    TileEntity te;
                    if (this.last_pick_pos_ == null) {
                        this.last_pick_pos_ = this.field_174879_c.func_177984_a();
                    }
                    TileEntity tileEntity = te = with_device_fluid_handler_collection ? this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a()) : null;
                    if (te != null) {
                        IFluidHandler fh2 = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.DOWN).orElse(null);
                        if (fh2 == null) {
                            te = null;
                        } else if (this.tank_.isEmpty()) {
                            FluidStack fs = fh2.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                            if (fs != null && !fs.isEmpty()) {
                                this.tank_ = fs.copy();
                            }
                            dirty = true;
                        } else {
                            FluidStack todrain = new FluidStack(this.tank_.getFluid(), 1000);
                            FluidStack fs = fh2.drain(todrain, IFluidHandler.FluidAction.EXECUTE);
                            if (fs != null && !fs.isEmpty()) {
                                this.tank_.setAmount(this.tank_.getAmount() + fs.getAmount());
                            }
                            dirty = true;
                        }
                    }
                    if (te == null && this.try_collect(this.field_174879_c.func_177984_a())) {
                        dirty = true;
                    }
                }
            }
            if (this.tank_.getAmount() >= 1000 && (fh = (IFluidHandler)FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177977_b(), (Direction)Direction.UP).orElse(null)) != null) {
                FluidStack fs = new FluidStack(this.tank_.getFluid(), 1000);
                int nfilled = MathHelper.func_76125_a((int)fh.fill(fs, IFluidHandler.FluidAction.EXECUTE), (int)0, (int)1000);
                this.tank_.shrink(nfilled);
                dirty = true;
            }
            int n = fill_level = this.tank_ == null ? 0 : MathHelper.func_76125_a((int)(this.tank_.getAmount() / 1000), (int)0, (int)3);
            if ((Integer)funnel_state.func_177229_b((IProperty)FluidFunnelBlock.FILL_LEVEL) != fill_level) {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)funnel_state.func_206870_a((IProperty)FluidFunnelBlock.FILL_LEVEL, (Comparable)Integer.valueOf(fill_level)), 18);
            }
            if (dirty) {
                this.func_70296_d();
            }
        }

        private static class OutputFluidHandler
        implements IFluidHandler {
            private final FluidFunnelTileEntity te;

            OutputFluidHandler(FluidFunnelTileEntity parent) {
                this.te = parent;
            }

            public int getTanks() {
                return 1;
            }

            public FluidStack getFluidInTank(int tank) {
                return this.te.tank_.copy();
            }

            public int getTankCapacity(int tank) {
                return 3000;
            }

            public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
                return true;
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                return 0;
            }

            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                return this.te.drain(resource, action);
            }

            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                return this.te.drain(maxDrain, action);
            }
        }
    }

    public static class FluidFunnelBlock
    extends DecorBlock.Normal
    implements IDecorBlock {
        public static final int FILL_LEVEL_MAX = 3;
        public static final IntegerProperty FILL_LEVEL = IntegerProperty.func_177719_a((String)"level", (int)0, (int)3);

        public FluidFunnelBlock(long config, Block.Properties builder, AxisAlignedBB[] unrotatedAABB) {
            super(config, builder, unrotatedAABB);
        }

        @Override
        public StandardBlocks.IStandardBlock.RenderTypeHint getRenderTypeHint() {
            return StandardBlocks.IStandardBlock.RenderTypeHint.CUTOUT;
        }

        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            super.func_206840_a(builder);
            builder.func_206894_a(new IProperty[]{FILL_LEVEL});
        }

        @Override
        @Nullable
        public BlockState func_196258_a(BlockItemUseContext context) {
            return (BlockState)super.func_196258_a(context).func_206870_a((IProperty)FILL_LEVEL, (Comparable)Integer.valueOf(0));
        }

        public boolean hasTileEntity(BlockState state) {
            return true;
        }

        @Nullable
        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return new FluidFunnelTileEntity();
        }

        public boolean func_149740_M(BlockState state) {
            return true;
        }

        public int func_180641_l(BlockState state, World world, BlockPos pos) {
            return MathHelper.func_76125_a((int)((Integer)state.func_177229_b((IProperty)FILL_LEVEL) * 5), (int)0, (int)15);
        }

        public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
            if (world.field_72995_K) {
                return;
            }
            if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("tedata")) {
                return;
            }
            CompoundNBT te_nbt = stack.func_77978_p().func_74775_l("tedata");
            if (te_nbt.isEmpty()) {
                return;
            }
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof FluidFunnelTileEntity)) {
                return;
            }
            ((FluidFunnelTileEntity)te).readnbt(te_nbt);
            ((FluidFunnelTileEntity)te).func_70296_d();
            world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)FILL_LEVEL, (Comparable)Integer.valueOf(0)));
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, World world, BlockPos pos, TileEntity te, boolean explosion) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (world.field_72995_K) {
                return stacks;
            }
            if (!(te instanceof FluidFunnelTileEntity)) {
                return stacks;
            }
            if (!explosion) {
                ItemStack stack = new ItemStack((IItemProvider)this, 1);
                CompoundNBT te_nbt = new CompoundNBT();
                ((FluidFunnelTileEntity)te).writenbt(te_nbt);
                if (!te_nbt.isEmpty()) {
                    CompoundNBT nbt = new CompoundNBT();
                    nbt.func_218657_a("tedata", (INBT)te_nbt);
                    stack.func_77982_d(nbt);
                }
                stacks.add(stack);
            } else {
                stacks.add(new ItemStack((IItemProvider)this, 1));
            }
            return stacks;
        }

        @Override
        public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof FluidFunnelTileEntity)) {
                return ActionResultType.FAIL;
            }
            return FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (World)world, (BlockPos)pos, (Direction)rayTraceResult.func_216354_b()) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
        }

        public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean unused) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof FluidFunnelTileEntity) {
                ((FluidFunnelTileEntity)te).block_changed();
            }
        }
    }
}

