/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.blocks.DecorBlock;
import wile.engineersdecor.blocks.IDecorBlock;
import wile.engineersdecor.detail.TreeCutting;
import wile.engineersdecor.libmc.detail.Auxiliaries;
import wile.engineersdecor.libmc.detail.Overlay;

public class EdTreeCutter {

    public static class TreeCutterTileEntity
    extends TileEntity
    implements ITickableTileEntity,
    IEnergyStorage {
        public static final int IDLE_TICK_INTERVAL = 40;
        public static final int TICK_INTERVAL = 5;
        public static final int BOOST_FACTOR = 6;
        public static final int DEFAULT_BOOST_ENERGY = 64;
        public static final int DEFAULT_CUTTING_TIME_NEEDED = 60;
        private static int boost_energy_consumption = 64;
        private static int energy_max = 1280;
        private static int cutting_time_needed = 1200;
        private static boolean requires_power = false;
        private int tick_timer_;
        private int active_timer_;
        private int proc_time_elapsed_;
        private int energy_;
        protected LazyOptional<IEnergyStorage> energy_handler_ = LazyOptional.of(() -> this);

        public static void on_config(int boost_energy_per_tick, int cutting_time_seconds, boolean power_required) {
            boost_energy_consumption = 5 * MathHelper.func_76125_a((int)boost_energy_per_tick, (int)4, (int)4096);
            energy_max = Math.max(boost_energy_consumption * 10, 10000);
            cutting_time_needed = 20 * MathHelper.func_76125_a((int)cutting_time_seconds, (int)10, (int)240);
            requires_power = power_required;
            ModEngineersDecor.logger().info("Config tree cutter: Boost energy consumption:" + boost_energy_consumption + "rf/t" + (requires_power ? " (power required for operation) " : "") + ", cutting time " + cutting_time_needed + "t.");
        }

        public TreeCutterTileEntity() {
            super(ModContent.TET_SMALL_TREE_CUTTER);
        }

        public TreeCutterTileEntity(TileEntityType<?> te_type) {
            super(te_type);
        }

        public void readnbt(CompoundNBT nbt) {
            this.energy_ = nbt.func_74762_e("energy");
        }

        private void writenbt(CompoundNBT nbt) {
            nbt.func_74768_a("energy", this.energy_);
        }

        public void state_message(PlayerEntity player) {
            String progress = "0";
            if (this.active_timer_ > 0 && cutting_time_needed > 0 && this.active_timer_ > 0) {
                progress = Integer.toString((int)MathHelper.func_151237_a((double)((double)this.proc_time_elapsed_ / (double)cutting_time_needed * 100.0), (double)0.0, (double)100.0));
            }
            String soc = Integer.toString(MathHelper.func_76125_a((int)(this.energy_ * 100 / energy_max), (int)0, (int)100));
            Overlay.show(player, (ITextComponent)Auxiliaries.localizable("block.engineersdecor.small_tree_cutter.status", null, soc, energy_max, progress, cutting_time_needed / 20));
        }

        public void func_145839_a(CompoundNBT nbt) {
            super.func_145839_a(nbt);
            this.readnbt(nbt);
        }

        public CompoundNBT func_189515_b(CompoundNBT nbt) {
            super.func_189515_b(nbt);
            this.writenbt(nbt);
            return nbt;
        }

        public void func_145843_s() {
            super.func_145843_s();
            this.energy_handler_.invalidate();
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }

        public int getMaxEnergyStored() {
            return boost_energy_consumption * 2;
        }

        public int getEnergyStored() {
            return this.energy_;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            maxReceive = MathHelper.func_76125_a((int)maxReceive, (int)0, (int)Math.max(energy_max - this.energy_, 0));
            if (!simulate) {
                this.energy_ += maxReceive;
            }
            return maxReceive;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityEnergy.ENERGY) {
                return this.energy_handler_.cast();
            }
            return super.getCapability(capability, facing);
        }

        public void func_73660_a() {
            if (--this.tick_timer_ > 0) {
                return;
            }
            BlockState device_state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(device_state.func_177230_c() instanceof TreeCutterBlock)) {
                this.tick_timer_ = 5;
                return;
            }
            if (this.field_145850_b.field_72995_K) {
                if (!((Boolean)device_state.func_177229_b((IProperty)TreeCutterBlock.ACTIVE)).booleanValue()) {
                    this.tick_timer_ = 5;
                } else {
                    this.tick_timer_ = 1;
                    this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187889_gU, SoundCategory.BLOCKS, 0.1f, 1.0f, false);
                }
            } else {
                boolean active;
                this.tick_timer_ = 5;
                BlockPos tree_pos = this.field_174879_c.func_177972_a((Direction)device_state.func_177229_b((IProperty)TreeCutterBlock.HORIZONTAL_FACING));
                BlockState tree_state = this.field_145850_b.func_180495_p(tree_pos);
                if (!TreeCutting.canChop(tree_state) || this.field_145850_b.func_175640_z(this.field_174879_c)) {
                    if (((Boolean)device_state.func_177229_b((IProperty)TreeCutterBlock.ACTIVE)).booleanValue()) {
                        this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)device_state.func_206870_a((IProperty)TreeCutterBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
                    }
                    this.proc_time_elapsed_ = 0;
                    this.active_timer_ = 0;
                    this.tick_timer_ = 40;
                    return;
                }
                this.proc_time_elapsed_ += 5;
                if (this.energy_ >= boost_energy_consumption) {
                    this.energy_ -= boost_energy_consumption;
                    this.proc_time_elapsed_ += 30;
                    this.active_timer_ = 2;
                } else if (!requires_power) {
                    this.active_timer_ = 1024;
                } else if (this.active_timer_ > 0) {
                    --this.active_timer_;
                }
                boolean bl = active = this.active_timer_ > 0;
                if (requires_power && !active) {
                    this.proc_time_elapsed_ = Math.max(0, this.proc_time_elapsed_ - 10);
                }
                if (this.proc_time_elapsed_ >= cutting_time_needed) {
                    this.proc_time_elapsed_ = 0;
                    TreeCutting.chopTree(this.field_145850_b, tree_state, tree_pos, 512, false);
                    this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187881_gQ, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    active = false;
                }
                if ((Boolean)device_state.func_177229_b((IProperty)TreeCutterBlock.ACTIVE) != active) {
                    this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)device_state.func_206870_a((IProperty)TreeCutterBlock.ACTIVE, (Comparable)Boolean.valueOf(active)), 3);
                }
            }
        }
    }

    public static class TreeCutterBlock
    extends DecorBlock.Horizontal
    implements IDecorBlock {
        public static final BooleanProperty ACTIVE = BooleanProperty.func_177716_a((String)"active");

        public TreeCutterBlock(long config, Block.Properties builder, AxisAlignedBB[] unrotatedAABB) {
            super(config, builder, unrotatedAABB);
        }

        @Override
        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            super.func_206840_a(builder);
            builder.func_206894_a(new IProperty[]{ACTIVE});
        }

        @Override
        @Nullable
        public BlockState func_196258_a(BlockItemUseContext context) {
            return (BlockState)super.func_196258_a(context).func_206870_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false));
        }

        public boolean hasTileEntity(BlockState state) {
            return true;
        }

        @Nullable
        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return new TreeCutterTileEntity();
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_180655_c(BlockState state, World world, BlockPos pos, Random rnd) {
            if (state.func_177230_c() != this || !((Boolean)state.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
                return;
            }
            double rv = rnd.nextDouble();
            if (rv > 0.8) {
                return;
            }
            double x = 0.5 + (double)pos.func_177958_n();
            double y = 0.5 + (double)pos.func_177956_o();
            double z = 0.5 + (double)pos.func_177952_p();
            double xc = 0.52;
            double xr = rnd.nextDouble() * 0.4 - 0.2;
            double yr = y - 0.3 + rnd.nextDouble() * 0.2;
            switch ((Direction)state.func_177229_b((IProperty)HORIZONTAL_FACING)) {
                case WEST: {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x - 0.52, yr, z + xr, 0.0, 0.0, 0.0);
                    break;
                }
                case EAST: {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.52, yr, z + xr, 0.0, 0.0, 0.0);
                    break;
                }
                case NORTH: {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + xr, yr, z - 0.52, 0.0, 0.0, 0.0);
                    break;
                }
                default: {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + xr, yr, z + 0.52, 0.0, 0.0, 0.0);
                }
            }
        }

        @Override
        public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TreeCutterTileEntity) {
                ((TreeCutterTileEntity)te).state_message(player);
            }
            return ActionResultType.SUCCESS;
        }
    }
}

