/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor;

import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Logger;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.blocks.DecorBlock;
import wile.engineersdecor.blocks.EdBreaker;
import wile.engineersdecor.blocks.EdChair;
import wile.engineersdecor.blocks.EdCraftingTable;
import wile.engineersdecor.blocks.EdDoubleGateBlock;
import wile.engineersdecor.blocks.EdDropper;
import wile.engineersdecor.blocks.EdElectricalFurnace;
import wile.engineersdecor.blocks.EdFenceBlock;
import wile.engineersdecor.blocks.EdFloorGratingBlock;
import wile.engineersdecor.blocks.EdFluidAccumulator;
import wile.engineersdecor.blocks.EdFluidBarrel;
import wile.engineersdecor.blocks.EdFluidFunnel;
import wile.engineersdecor.blocks.EdFurnace;
import wile.engineersdecor.blocks.EdHopper;
import wile.engineersdecor.blocks.EdHorizontalSupportBlock;
import wile.engineersdecor.blocks.EdLabeledCrate;
import wile.engineersdecor.blocks.EdLadderBlock;
import wile.engineersdecor.blocks.EdMilker;
import wile.engineersdecor.blocks.EdMineralSmelter;
import wile.engineersdecor.blocks.EdPipeValve;
import wile.engineersdecor.blocks.EdPlacer;
import wile.engineersdecor.blocks.EdSlabBlock;
import wile.engineersdecor.blocks.EdSlabSliceBlock;
import wile.engineersdecor.blocks.EdSolarPanel;
import wile.engineersdecor.blocks.EdStairsBlock;
import wile.engineersdecor.blocks.EdStraightPoleBlock;
import wile.engineersdecor.blocks.EdTreeCutter;
import wile.engineersdecor.blocks.EdWallBlock;
import wile.engineersdecor.blocks.EdWasteIncinerator;
import wile.engineersdecor.blocks.EdWindowBlock;
import wile.engineersdecor.blocks.IDecorBlock;
import wile.engineersdecor.libmc.blocks.StandardBlocks;
import wile.engineersdecor.libmc.detail.Auxiliaries;

public class ModConfig {
    private static final Logger LOGGER = ModEngineersDecor.logger();
    private static final String MODID = "engineersdecor";
    public static final CommonConfig COMMON;
    public static final ServerConfig SERVER;
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec COMMON_CONFIG_SPEC;
    public static final ForgeConfigSpec SERVER_CONFIG_SPEC;
    public static final ForgeConfigSpec CLIENT_CONFIG_SPEC;
    private static final CompoundNBT server_config_;
    private static HashSet<String> optouts_;
    private static boolean with_experimental_features_;
    private static boolean without_recipes_;
    public static boolean without_crafting_table;
    public static boolean immersiveengineering_installed;
    public static boolean without_direct_slab_pickup;
    public static boolean with_creative_mode_device_drops;

    public static final boolean isOptedOut(@Nullable Block block) {
        return ModConfig.isOptedOut(block.func_199767_j());
    }

    public static final boolean isOptedOut(@Nullable Item item) {
        return item != null && optouts_.contains(item.getRegistryName().func_110623_a());
    }

    public static boolean withExperimental() {
        return with_experimental_features_;
    }

    public static boolean withoutRecipes() {
        return without_recipes_;
    }

    public static final CompoundNBT getServerConfig() {
        return server_config_;
    }

    private static final void updateOptouts() {
        int i;
        ArrayList<String> includes_ = new ArrayList<String>();
        ArrayList<String> excludes_ = new ArrayList<String>();
        String inc = ((String)ModConfig.SERVER.pattern_includes.get()).toLowerCase().replaceAll("engineersdecor:", "").replaceAll("[^*_,a-z0-9]", "");
        if (ModConfig.SERVER.pattern_includes.get() != inc) {
            ModConfig.SERVER.pattern_includes.set((Object)inc);
        }
        if (!inc.isEmpty()) {
            LOGGER.info("Config pattern includes: '" + inc + "'");
        }
        String[] incl = inc.split(",");
        includes_.clear();
        for (i = 0; i < incl.length; ++i) {
            incl[i] = incl[i].replaceAll("[*]", ".*?");
            if (incl[i].isEmpty()) continue;
            includes_.add(incl[i]);
        }
        String exc = ((String)ModConfig.SERVER.pattern_excludes.get()).toLowerCase().replaceAll("engineersdecor:", "").replaceAll("[^*_,a-z0-9]", "");
        if (!exc.isEmpty()) {
            LOGGER.info("Config pattern excludes: '" + exc + "'");
        }
        String[] excl = exc.split(",");
        excludes_.clear();
        for (i = 0; i < excl.length; ++i) {
            excl[i] = excl[i].replaceAll("[*]", ".*?");
            if (excl[i].isEmpty()) continue;
            excludes_.add(excl[i]);
        }
        boolean with_log_details = false;
        HashSet optouts = new HashSet();
        ModContent.getRegisteredItems().stream().filter(item -> {
            if (item == null) {
                return true;
            }
            if (SERVER == null) {
                return false;
            }
            return false;
        }).forEach(e -> optouts.add(e.getRegistryName().func_110623_a()));
        ModContent.getRegisteredBlocks().stream().filter(block -> {
            if (block == null) {
                return true;
            }
            if (block == ModContent.SIGN_MODLOGO) {
                return true;
            }
            if (COMMON == null) {
                return false;
            }
            try {
                if (!((Boolean)ModConfig.SERVER.with_experimental.get()).booleanValue()) {
                    if (block instanceof Auxiliaries.IExperimentalFeature) {
                        return true;
                    }
                    if (ModContent.isExperimentalBlock(block)) {
                        return true;
                    }
                }
                if (!immersiveengineering_installed) {
                    if (block instanceof IDecorBlock && (((IDecorBlock)block).config() & Long.MIN_VALUE) != 0L) {
                        return true;
                    }
                    if (block instanceof DecorBlock.Normal && (((DecorBlock.Normal)block).config & Long.MIN_VALUE) != 0L) {
                        return true;
                    }
                    if (block instanceof StandardBlocks.BaseBlock && (((StandardBlocks.BaseBlock)block).config & Long.MIN_VALUE) != 0L) {
                        return true;
                    }
                }
                String rn = block.getRegistryName().func_110623_a();
                try {
                    for (String e : includes_) {
                        if (!rn.matches(e)) continue;
                        if (with_log_details) {
                            LOGGER.info("Optout force include: " + rn);
                        }
                        return false;
                    }
                    for (String e : excludes_) {
                        if (!rn.matches(e)) continue;
                        if (with_log_details) {
                            LOGGER.info("Optout force exclude: " + rn);
                        }
                        return true;
                    }
                }
                catch (Throwable ex) {
                    LOGGER.error("optout include pattern failed, disabling.");
                    includes_.clear();
                    excludes_.clear();
                }
                if (block instanceof EdCraftingTable.CraftingTableBlock) {
                    return (Boolean)ModConfig.SERVER.without_crafting_table.get();
                }
                if (block instanceof EdElectricalFurnace.ElectricalFurnaceBlock) {
                    return (Boolean)ModConfig.SERVER.without_electrical_furnace.get();
                }
                if (block instanceof EdFurnace.FurnaceBlock && !(block instanceof EdElectricalFurnace.ElectricalFurnaceBlock)) {
                    return (Boolean)ModConfig.SERVER.without_lab_furnace.get();
                }
                if (block instanceof EdFluidAccumulator.FluidAccumulatorBlock) {
                    return (Boolean)ModConfig.SERVER.without_passive_fluid_accumulator.get();
                }
                if (block instanceof EdWasteIncinerator.WasteIncineratorBlock) {
                    return (Boolean)ModConfig.SERVER.without_waste_incinerator.get();
                }
                if (block instanceof EdDropper.DropperBlock) {
                    return (Boolean)ModConfig.SERVER.without_factory_dropper.get();
                }
                if (block instanceof EdPlacer.PlacerBlock) {
                    return (Boolean)ModConfig.SERVER.without_factory_placer.get();
                }
                if (block instanceof EdBreaker.BreakerBlock) {
                    return (Boolean)ModConfig.SERVER.without_block_breaker.get();
                }
                if (block instanceof EdSlabSliceBlock) {
                    return (Boolean)ModConfig.SERVER.without_halfslabs.get();
                }
                if (block instanceof EdLadderBlock) {
                    return (Boolean)ModConfig.SERVER.without_ladders.get();
                }
                if (block instanceof EdWindowBlock) {
                    return (Boolean)ModConfig.SERVER.without_windows.get();
                }
                if (block instanceof EdPipeValve.PipeValveBlock) {
                    return (Boolean)ModConfig.SERVER.without_valves.get();
                }
                if (block instanceof EdHorizontalSupportBlock) {
                    return (Boolean)ModConfig.SERVER.without_hsupports.get();
                }
                if (block instanceof EdFloorGratingBlock) {
                    return (Boolean)ModConfig.SERVER.without_floor_grating.get();
                }
                if (block instanceof EdHopper.HopperBlock) {
                    return (Boolean)ModConfig.SERVER.without_factory_hopper.get();
                }
                if (block instanceof EdFluidFunnel.FluidFunnelBlock) {
                    return (Boolean)ModConfig.SERVER.without_fluid_funnel.get();
                }
                if (block instanceof EdSolarPanel.SolarPanelBlock) {
                    return (Boolean)ModConfig.SERVER.without_solar_panel.get();
                }
                if (block instanceof EdMineralSmelter.MineralSmelterBlock) {
                    return (Boolean)ModConfig.SERVER.without_mineral_smelter.get();
                }
                if (block instanceof EdMilker.MilkerBlock) {
                    return (Boolean)ModConfig.SERVER.without_milking_machine.get();
                }
                if (block instanceof EdTreeCutter.TreeCutterBlock) {
                    return (Boolean)ModConfig.SERVER.without_tree_cutter.get();
                }
                if (block instanceof EdLabeledCrate.LabeledCrateBlock) {
                    return (Boolean)ModConfig.SERVER.without_labeled_crate.get();
                }
                if (((Boolean)ModConfig.SERVER.without_slabs.get()).booleanValue() && block instanceof EdSlabBlock) {
                    return true;
                }
                if (((Boolean)ModConfig.SERVER.without_stairs.get()).booleanValue() && block instanceof EdStairsBlock) {
                    return true;
                }
                if (((Boolean)ModConfig.SERVER.without_walls.get()).booleanValue() && block instanceof EdWallBlock) {
                    return true;
                }
                if (((Boolean)ModConfig.SERVER.without_poles.get()).booleanValue() && block instanceof EdStraightPoleBlock) {
                    return true;
                }
                if (((Boolean)ModConfig.SERVER.without_clinker_bricks.get()).booleanValue() && rn.startsWith("clinker_brick_")) {
                    return true;
                }
                if (((Boolean)ModConfig.SERVER.without_slag_bricks.get()).booleanValue() && rn.startsWith("slag_brick_")) {
                    return true;
                }
                if (((Boolean)ModConfig.SERVER.without_rebar_concrete.get()).booleanValue() && rn.startsWith("rebar_concrete")) {
                    return true;
                }
                if (((Boolean)ModConfig.SERVER.without_gas_concrete.get()).booleanValue() && rn.startsWith("gas_concrete")) {
                    return true;
                }
                if (((Boolean)ModConfig.SERVER.without_ie_concrete_wall.get()).booleanValue() && rn.startsWith("ie_concrete_wall")) {
                    return true;
                }
                if (((Boolean)ModConfig.SERVER.without_panzer_glass.get()).booleanValue() && rn.startsWith("panzerglass_")) {
                    return true;
                }
                if (((Boolean)ModConfig.SERVER.without_light_sources.get()).booleanValue() && rn.endsWith("_light")) {
                    return true;
                }
                if (((Boolean)ModConfig.SERVER.without_sign_plates.get()).booleanValue() && rn.startsWith("sign_")) {
                    return true;
                }
                if (((Boolean)ModConfig.SERVER.without_treated_wood_furniture.get()).booleanValue()) {
                    if (block instanceof EdChair.ChairBlock) {
                        return true;
                    }
                    if (rn.equals("treated_wood_table")) {
                        return true;
                    }
                    if (rn.equals("treated_wood_stool")) {
                        return true;
                    }
                    if (rn.equals("treated_wood_windowsill")) {
                        return true;
                    }
                    if (rn.equals("treated_wood_broad_windowsill")) {
                        return true;
                    }
                    if (rn.equals("treated_wood_side_table")) {
                        return true;
                    }
                }
                if (((Boolean)ModConfig.SERVER.without_metal_furniture.get()).booleanValue() && rn.equals("steel_table")) {
                    return true;
                }
                if (((Boolean)ModConfig.SERVER.without_fences.get()).booleanValue()) {
                    if (block instanceof EdFenceBlock) {
                        return true;
                    }
                    if (block instanceof EdDoubleGateBlock) {
                        return true;
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.error("Exception evaluating the optout config: '" + ex.getMessage() + "'");
            }
            return false;
        }).forEach(e -> optouts.add(e.getRegistryName().func_110623_a()));
        optouts_ = optouts;
    }

    public static final void apply() {
        with_experimental_features_ = (Boolean)ModConfig.SERVER.with_experimental.get();
        if (with_experimental_features_) {
            LOGGER.info("Config: EXPERIMENTAL FEATURES ENABLED.");
        }
        immersiveengineering_installed = Auxiliaries.isModLoaded("immersiveengineering");
        ModConfig.updateOptouts();
        without_crafting_table = ModConfig.isOptedOut(ModContent.TREATED_WOOD_CRAFTING_TABLE);
        without_recipes_ = (Boolean)ModConfig.SERVER.without_recipes.get();
        without_direct_slab_pickup = (Boolean)ModConfig.SERVER.without_direct_slab_pickup.get();
        EdFurnace.FurnaceTileEntity.on_config((Integer)ModConfig.SERVER.furnace_smelting_speed_percent.get(), (Integer)ModConfig.SERVER.furnace_fuel_efficiency_percent.get(), (Integer)ModConfig.SERVER.furnace_boost_energy_consumption.get());
        EdChair.on_config((Boolean)ModConfig.SERVER.without_chair_sitting.get(), (Boolean)ModConfig.SERVER.without_mob_chair_sitting.get(), (Double)ModConfig.SERVER.chair_mob_sitting_probability_percent.get(), (Double)ModConfig.SERVER.chair_mob_standup_probability_percent.get());
        EdLadderBlock.on_config((Boolean)ModConfig.SERVER.without_ladder_speed_boost.get());
        EdCraftingTable.on_config((Boolean)ModConfig.SERVER.without_crafting_table_history.get(), false, (Boolean)ModConfig.SERVER.with_crafting_quickmove_buttons.get(), (Boolean)ModConfig.SERVER.without_crafting_mouse_scrolling.get());
        EdPipeValve.on_config((Integer)ModConfig.SERVER.pipevalve_max_flowrate.get(), (Integer)ModConfig.SERVER.pipevalve_redstone_gain.get());
        EdElectricalFurnace.ElectricalFurnaceTileEntity.on_config((int)((Integer)ModConfig.SERVER.e_furnace_speed_percent.get()), (int)((Integer)ModConfig.SERVER.e_furnace_power_consumption.get()), (Boolean)ModConfig.SERVER.e_furnace_automatic_pulling.get());
        EdSolarPanel.SolarPanelTileEntity.on_config((Integer)ModConfig.SERVER.small_solar_panel_peak_production.get());
        EdBreaker.BreakerTileEntity.on_config((Integer)ModConfig.SERVER.block_breaker_power_consumption.get(), (Integer)ModConfig.SERVER.block_breaker_reluctance.get(), (Integer)ModConfig.SERVER.block_breaker_min_breaking_time.get(), (Boolean)ModConfig.SERVER.block_breaker_requires_power.get());
        EdTreeCutter.TreeCutterTileEntity.on_config((Integer)ModConfig.SERVER.tree_cuttter_energy_consumption.get(), (Integer)ModConfig.SERVER.tree_cuttter_cutting_time_needed.get(), (Boolean)ModConfig.SERVER.tree_cuttter_requires_power.get());
        EdMilker.MilkerTileEntity.on_config((Integer)ModConfig.SERVER.milking_machine_energy_consumption.get(), (Integer)ModConfig.SERVER.milking_machine_milking_delay.get());
        EdSlabBlock.on_config((Boolean)ModConfig.SERVER.without_direct_slab_pickup.get() == false);
        EdSlabSliceBlock.on_config((Boolean)ModConfig.SERVER.without_direct_slab_pickup.get() == false);
        EdLabeledCrate.on_config(false);
        EdFluidFunnel.on_config(with_experimental_features_);
        EdDropper.on_config(with_experimental_features_);
        EdFluidBarrel.on_config(12000, 1000);
        server_config_.func_74757_a("tree_cuttter_requires_power", ((Boolean)ModConfig.SERVER.tree_cuttter_requires_power.get()).booleanValue());
        server_config_.func_74757_a("block_breaker_requires_power", ((Boolean)ModConfig.SERVER.block_breaker_requires_power.get()).booleanValue());
        String s = String.join((CharSequence)",", optouts_);
        server_config_.func_74778_a("optout", s);
        if (!s.isEmpty()) {
            LOGGER.info("Opt-outs:" + s);
        }
    }

    static {
        Pair common_ = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_CONFIG_SPEC = (ForgeConfigSpec)common_.getRight();
        COMMON = (CommonConfig)common_.getLeft();
        Pair server_ = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_CONFIG_SPEC = (ForgeConfigSpec)server_.getRight();
        SERVER = (ServerConfig)server_.getLeft();
        Pair client_ = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_CONFIG_SPEC = (ForgeConfigSpec)client_.getRight();
        CLIENT = (ClientConfig)client_.getLeft();
        server_config_ = new CompoundNBT();
        optouts_ = new HashSet();
        with_experimental_features_ = false;
        without_recipes_ = false;
        without_crafting_table = false;
        immersiveengineering_installed = false;
        without_direct_slab_pickup = false;
        with_creative_mode_device_drops = false;
    }

    public static class ServerConfig {
        public final ForgeConfigSpec.ConfigValue<String> pattern_excludes;
        public final ForgeConfigSpec.ConfigValue<String> pattern_includes;
        public final ForgeConfigSpec.BooleanValue without_clinker_bricks;
        public final ForgeConfigSpec.BooleanValue without_slag_bricks;
        public final ForgeConfigSpec.BooleanValue without_rebar_concrete;
        public final ForgeConfigSpec.BooleanValue without_gas_concrete;
        public final ForgeConfigSpec.BooleanValue without_walls;
        public final ForgeConfigSpec.BooleanValue without_stairs;
        public final ForgeConfigSpec.BooleanValue without_ie_concrete_wall;
        public final ForgeConfigSpec.BooleanValue without_panzer_glass;
        public final ForgeConfigSpec.BooleanValue without_ladders;
        public final ForgeConfigSpec.BooleanValue without_treated_wood_furniture;
        public final ForgeConfigSpec.BooleanValue without_metal_furniture;
        public final ForgeConfigSpec.BooleanValue without_windows;
        public final ForgeConfigSpec.BooleanValue without_light_sources;
        public final ForgeConfigSpec.BooleanValue without_slabs;
        public final ForgeConfigSpec.BooleanValue without_halfslabs;
        public final ForgeConfigSpec.BooleanValue without_poles;
        public final ForgeConfigSpec.BooleanValue without_hsupports;
        public final ForgeConfigSpec.BooleanValue without_sign_plates;
        public final ForgeConfigSpec.BooleanValue without_floor_grating;
        public final ForgeConfigSpec.BooleanValue without_crafting_table;
        public final ForgeConfigSpec.BooleanValue without_lab_furnace;
        public final ForgeConfigSpec.BooleanValue without_electrical_furnace;
        public final ForgeConfigSpec.BooleanValue without_valves;
        public final ForgeConfigSpec.BooleanValue without_passive_fluid_accumulator;
        public final ForgeConfigSpec.BooleanValue without_waste_incinerator;
        public final ForgeConfigSpec.BooleanValue without_factory_dropper;
        public final ForgeConfigSpec.BooleanValue without_factory_hopper;
        public final ForgeConfigSpec.BooleanValue without_factory_placer;
        public final ForgeConfigSpec.BooleanValue without_block_breaker;
        public final ForgeConfigSpec.BooleanValue without_solar_panel;
        public final ForgeConfigSpec.BooleanValue without_fluid_funnel;
        public final ForgeConfigSpec.BooleanValue without_mineral_smelter;
        public final ForgeConfigSpec.BooleanValue without_milking_machine;
        public final ForgeConfigSpec.BooleanValue without_tree_cutter;
        public final ForgeConfigSpec.BooleanValue without_labeled_crate;
        public final ForgeConfigSpec.BooleanValue without_fences;
        public final ForgeConfigSpec.BooleanValue without_chair_sitting;
        public final ForgeConfigSpec.BooleanValue without_mob_chair_sitting;
        public final ForgeConfigSpec.BooleanValue without_ladder_speed_boost;
        public final ForgeConfigSpec.BooleanValue without_crafting_table_history;
        public final ForgeConfigSpec.BooleanValue without_direct_slab_pickup;
        public final ForgeConfigSpec.BooleanValue with_creative_mode_device_drops;
        public final ForgeConfigSpec.BooleanValue with_experimental;
        public final ForgeConfigSpec.BooleanValue without_recipes;
        public final ForgeConfigSpec.IntValue furnace_smelting_speed_percent;
        public final ForgeConfigSpec.IntValue furnace_fuel_efficiency_percent;
        public final ForgeConfigSpec.IntValue furnace_boost_energy_consumption;
        public final ForgeConfigSpec.IntValue e_furnace_speed_percent;
        public final ForgeConfigSpec.IntValue e_furnace_power_consumption;
        public final ForgeConfigSpec.IntValue small_solar_panel_peak_production;
        public final ForgeConfigSpec.BooleanValue e_furnace_automatic_pulling;
        public final ForgeConfigSpec.DoubleValue chair_mob_sitting_probability_percent;
        public final ForgeConfigSpec.DoubleValue chair_mob_standup_probability_percent;
        public final ForgeConfigSpec.BooleanValue with_crafting_quickmove_buttons;
        public final ForgeConfigSpec.BooleanValue without_crafting_mouse_scrolling;
        public final ForgeConfigSpec.IntValue pipevalve_max_flowrate;
        public final ForgeConfigSpec.IntValue pipevalve_redstone_gain;
        public final ForgeConfigSpec.IntValue block_breaker_power_consumption;
        public final ForgeConfigSpec.IntValue block_breaker_reluctance;
        public final ForgeConfigSpec.IntValue block_breaker_min_breaking_time;
        public final ForgeConfigSpec.BooleanValue block_breaker_requires_power;
        public final ForgeConfigSpec.IntValue tree_cuttter_energy_consumption;
        public final ForgeConfigSpec.IntValue tree_cuttter_cutting_time_needed;
        public final ForgeConfigSpec.BooleanValue tree_cuttter_requires_power;
        public final ForgeConfigSpec.IntValue milking_machine_energy_consumption;
        public final ForgeConfigSpec.IntValue milking_machine_milking_delay;

        ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings affecting the logical server side.").push("server");
            builder.comment("Opt-out settings").push("optout");
            this.pattern_excludes = builder.translation("engineersdecor.config.pattern_excludes").comment("Opt-out any block by its registry name ('*' wildcard matching, comma separated list, whitespaces ignored. You must match the whole name, means maybe add '*' also at the begin and end. Example: '*wood*,*steel*' excludes everything that has 'wood' or 'steel' in the registry name. The matching result is also traced in the log file. ").define("pattern_excludes", (Object)"");
            this.pattern_includes = builder.translation("engineersdecor.config.pattern_includes").comment("Prevent blocks from being opt'ed by registry name ('*' wildcard matching, comma separated list, whitespaces ignored. Evaluated before all other opt-out checks. You must match the whole name, means maybe add '*' also at the begin and end. Example: '*wood*,*steel*' includes everything that has 'wood' or 'steel' in the registry name.The matching result is also traced in the log file.").define("pattern_includes", (Object)"");
            this.without_clinker_bricks = builder.translation("engineersdecor.config.without_clinker_bricks").comment("Disable clinker bricks and derived blocks.").define("without_clinker_bricks", false);
            this.without_slag_bricks = builder.translation("engineersdecor.config.without_slag_bricks").comment("Disable slag bricks and derived blocks.").define("without_slag_bricks", false);
            this.without_rebar_concrete = builder.translation("engineersdecor.config.without_rebar_concrete").comment("Disable rebar concrete and derived blocks.").define("without_rebar_concrete", false);
            this.without_gas_concrete = builder.translation("engineersdecor.config.without_gas_concrete").comment("Disable gas concrete and derived blocks.").define("without_gas_concrete", false);
            this.without_walls = builder.translation("engineersdecor.config.without_walls").comment("Disable all mod wall blocks.").define("without_walls", false);
            this.without_stairs = builder.translation("engineersdecor.config.without_stairs").comment("Disable all mod stairs blocks.").define("without_stairs", false);
            this.without_ie_concrete_wall = builder.translation("engineersdecor.config.without_ie_concrete_wall").comment("Disable IE concrete wall.").define("without_ie_concrete_wall", false);
            this.without_panzer_glass = builder.translation("engineersdecor.config.without_panzer_glass").comment("Disable panzer glass and derived blocks.").define("without_panzer_glass", false);
            this.without_crafting_table = builder.translation("engineersdecor.config.without_crafting_table").comment("Disable treated wood crafting table.").define("without_crafting_table", false);
            this.without_lab_furnace = builder.translation("engineersdecor.config.without_lab_furnace").comment("Disable small lab furnace.").define("without_lab_furnace", false);
            this.without_electrical_furnace = builder.translation("engineersdecor.config.without_electrical_furnace").comment("Disable small electrical pass-through furnace.").define("without_electrical_furnace", false);
            this.without_treated_wood_furniture = builder.translation("engineersdecor.config.without_treated_wood_furniture").comment("Disable treated wood table, stool, windowsill, etc.").define("without_treated_wood_furniture", false);
            this.without_metal_furniture = builder.translation("engineersdecor.config.without_metal_furniture").comment("Disable metal tables, etc.").define("without_metal_furniture", false);
            this.without_windows = builder.translation("engineersdecor.config.without_windows").comment("Disable treated wood window, etc.").define("without_windows", false);
            this.without_light_sources = builder.translation("engineersdecor.config.without_light_sources").comment("Disable light sources").define("without_light_sources", false);
            this.without_ladders = builder.translation("engineersdecor.config.without_ladders").comment("Disable ladders").define("without_ladders", false);
            this.without_chair_sitting = builder.translation("engineersdecor.config.without_chair_sitting").comment("Disable possibility to sit on stools and chairs.").define("without_chair_sitting", false);
            this.without_mob_chair_sitting = builder.translation("engineersdecor.config.without_mob_chair_sitting").comment("Disable that mobs will sit on chairs and stools.").define("without_mob_chair_sitting", false);
            this.without_ladder_speed_boost = builder.translation("engineersdecor.config.without_ladder_speed_boost").comment("Disable the speed boost of ladders in this mod.").define("without_ladder_speed_boost", false);
            this.without_crafting_table_history = builder.translation("engineersdecor.config.without_crafting_table_history").comment("Disable history refabrication feature of the treated wood crafting table.").define("without_crafting_table_history", false);
            this.without_valves = builder.translation("engineersdecor.config.without_valves").comment("Disable check valve, and redstone controlled valves.").define("without_valves", false);
            this.without_passive_fluid_accumulator = builder.translation("engineersdecor.config.without_passive_fluid_accumulator").comment("Disable the passive fluid accumulator.").define("without_passive_fluid_accumulator", false);
            this.without_waste_incinerator = builder.translation("engineersdecor.config.without_waste_incinerator").comment("Disable item disposal/trash/void incinerator device.").define("without_waste_incinerator", false);
            this.without_sign_plates = builder.translation("engineersdecor.config.without_sign_plates").comment("Disable decorative sign plates (caution, hazards, etc).").define("without_sign_plates", false);
            this.without_floor_grating = builder.translation("engineersdecor.config.without_floor_grating").comment("Disable floor gratings.").define("without_floor_grating", false);
            this.without_factory_dropper = builder.translation("engineersdecor.config.without_factory_dropper").comment("Disable the factory dropper.").define("without_factory_dropper", false);
            this.without_factory_hopper = builder.translation("engineersdecor.config.without_factory_hopper").comment("Disable the factory hopper.").define("without_factory_hopper", false);
            this.without_factory_placer = builder.translation("engineersdecor.config.without_factory_placer").comment("Disable the factory placer.").define("without_factory_placer", false);
            this.without_block_breaker = builder.translation("engineersdecor.config.without_block_breaker").comment("Disable the small block breaker.").define("without_block_breaker", false);
            this.without_solar_panel = builder.translation("engineersdecor.config.without_solar_panel").comment("Disable the small solar panel.").define("without_solar_panel", false);
            this.without_fluid_funnel = builder.translation("engineersdecor.config.without_fluid_funnel").comment("Disable the small fluid collection funnel.").define("without_fluid_funnel", false);
            this.without_mineral_smelter = builder.translation("engineersdecor.config.without_mineral_smelter").comment("Disable the small mineral smelter.").define("without_mineral_smelter", false);
            this.without_milking_machine = builder.translation("engineersdecor.config.without_milking_machine").comment("Disable the small milking machine.").define("without_milking_machine", false);
            this.without_tree_cutter = builder.translation("engineersdecor.config.without_tree_cutter").comment("Disable the small tree cutter.").define("without_tree_cutter", false);
            this.without_labeled_crate = builder.translation("engineersdecor.config.without_labeled_crate").comment("Disable labeled crate.").define("without_labeled_crate", false);
            this.without_slabs = builder.translation("engineersdecor.config.without_slabs").comment("Disable horizontal half-block slab.").define("without_slabs", false);
            this.without_halfslabs = builder.translation("engineersdecor.config.without_halfslabs").comment("Disable stackable 1/8 block slices.").define("without_halfslabs", false);
            this.without_poles = builder.translation("engineersdecor.config.without_poles").comment("Disable poles of any material.").define("without_poles", false);
            this.without_hsupports = builder.translation("engineersdecor.config.without_hsupports").comment("Disable horizontal supports like the double-T support.").define("without_hsupports", false);
            this.without_recipes = builder.translation("engineersdecor.config.without_recipes").comment("Disable all internal recipes, allowing to use alternative pack recipes.").define("without_recipes", false);
            this.without_fences = builder.translation("engineersdecor.config.without_fences").comment("Disable all fences and fence gates.").define("without_fences", false);
            builder.pop();
            builder.comment("Miscellaneous settings").push("miscellaneous");
            this.with_experimental = builder.translation("engineersdecor.config.with_experimental").comment("Enables experimental features. Use at own risk.").define("with_experimental", false);
            this.without_direct_slab_pickup = builder.translation("engineersdecor.config.without_direct_slab_pickup").comment("Disable directly picking up layers from slabs and slab  slices by left clicking while looking up/down.").define("without_direct_slab_pickup", false);
            this.with_creative_mode_device_drops = builder.translation("engineersdecor.config.with_creative_mode_device_drops").comment("Enable that devices are dropped as item also in creative mode, allowing  to relocate them with contents and settings.").define("with_creative_mode_device_drops", false);
            builder.pop();
            builder.comment("Tweaks").push("tweaks");
            this.furnace_smelting_speed_percent = builder.translation("engineersdecor.config.furnace_smelting_speed_percent").comment("Defines, in percent, how fast the lab furnace smelts compared to a vanilla furnace. 100% means vanilla furnace speed, 150% means the lab furnace is faster. The value can be changed on-the-fly for tuning.").defineInRange("furnace_smelting_speed_percent", 130, 50, 800);
            this.furnace_fuel_efficiency_percent = builder.translation("engineersdecor.config.furnace_fuel_efficiency_percent").comment("Defines, in percent, how fuel efficient the lab furnace is, compared to a vanilla furnace. 100% means vanilla furnace consumiton, 200% means the lab furnace needs about half the fuel of a vanilla furnace, The value can be changed on-the-fly for tuning.").defineInRange("furnace_fuel_efficiency_percent", 100, 50, 400);
            this.furnace_boost_energy_consumption = builder.translation("engineersdecor.config.furnace_boost_energy_consumption").comment("Defines the energy consumption (per tick) for speeding up the smelting process. If IE is installed, an external heater has to be inserted into an auxiliary slot of the lab furnace. The power source needs to be able to provide at least 4 times this consumption (fixed threshold value). The value can be changed on-the-fly for tuning. The default value corresponds to the IE heater consumption.").defineInRange("furnace_boost_energy_consumption", 24, 2, 1024);
            this.chair_mob_sitting_probability_percent = builder.translation("engineersdecor.config.chair_mob_sitting_probability_percent").comment("Defines, in percent, how high the probability is that a mob sits on a chair when colliding with it. Can be changed on-the-fly for tuning.").defineInRange("chair_mob_sitting_probability_percent", 10.0, 0.0, 80.0);
            this.chair_mob_standup_probability_percent = builder.translation("engineersdecor.config.chair_mob_standup_probability_percent").comment("Defines, in percent, probable it is that a mob leaves a chair when sitting on it. The 'dice is rolled' about every 20 ticks. There is also a minimum Sitting time of about 3s. The config value can be changed on-the-fly for tuning.").defineInRange("chair_mob_standup_probability_percent", 1.0, 0.001, 10.0);
            this.with_crafting_quickmove_buttons = builder.translation("engineersdecor.config.with_crafting_quickmove_buttons").comment("Enables small quick-move arrows from/to player/block storage. Makes the UI a bit too busy, therefore disabled by default.").define("with_crafting_quickmove_buttons", false);
            this.without_crafting_mouse_scrolling = builder.translation("engineersdecor.config.without_crafting_mouse_scrolling").comment("Disables increasing/decreasing the crafting grid items by scrolling over the crafting result slot.").define("without_crafting_mouse_scrolling", false);
            this.pipevalve_max_flowrate = builder.translation("engineersdecor.config.pipevalve_max_flowrate").comment("Defines how many millibuckets can be transferred (per tick) through the valves. That is technically the 'storage size' specified for blocks that want to fill fluids into the valve (the valve has no container and forward that to the output block), The value can be changed on-the-fly for tuning. ").defineInRange("pipevalve_max_flowrate", 1000, 1, 32000);
            this.pipevalve_redstone_gain = builder.translation("engineersdecor.config.pipevalve_redstone_gain").comment("Defines how many millibuckets per redstone signal strength can be transferred per tick through the analog redstone controlled valves. Note: power 0 is always off, power 15 is always the max flow rate. Between power 1 and 14 this scaler will result in a flow = 'redstone slope' * 'current redstone power'. The value can be changed on-the-fly for tuning. ").defineInRange("pipevalve_redstone_gain", 20, 1, 32000);
            this.e_furnace_speed_percent = builder.translation("engineersdecor.config.e_furnace_speed_percent").comment("Defines, in percent, how fast the electrical furnace smelts compared to a vanilla furnace. 100% means vanilla furnace speed, 150% means the electrical furnace is faster. The value can be changed on-the-fly for tuning.").defineInRange("e_furnace_speed_percent", 200, 50, 800);
            this.e_furnace_power_consumption = builder.translation("engineersdecor.config.e_furnace_power_consumption").comment("Defines how much RF per tick the the electrical furnace consumed (average) for smelting. The feeders transferring items from/to adjacent have this consumption/8 for each stack transaction. The default value is only slightly higher than a furnace with an IE external heater (and no burning fuel inside).The config value can be changed on-the-fly for tuning.").defineInRange("e_furnace_power_consumption", 16, 8, 4096);
            this.e_furnace_automatic_pulling = builder.translation("engineersdecor.config.e_furnace_automatic_pulling").comment("Defines if the electrical furnace automatically pulls items from an inventory at the input side.The config value can be changed on-the-fly for tuning.").define("e_furnace_automatic_pulling", false);
            this.small_solar_panel_peak_production = builder.translation("engineersdecor.config.small_solar_panel_peak_production").comment("Defines the peak power production (at noon) of the Small Solar Panel. Note that the agerage power is much less, as no power is produced at all during the night, and the power curve is nonlinear rising/falling during the day. Bad weather conditions also decrease the production. The config value can be changed on-the-fly for tuning.").defineInRange("small_solar_panel_peak_production", 40, 2, 4096);
            this.block_breaker_power_consumption = builder.translation("engineersdecor.config.block_breaker_power_consumption").comment("Defines how much RF power the Small Block Breaker requires to magnificently increase the processing speed. The config value can be changed on-the-fly for tuning.").defineInRange("block_breaker_power_consumption", 64, 4, 1024);
            this.block_breaker_reluctance = builder.translation("engineersdecor.config.block_breaker_reluctance").comment("Defines how much time the Small Block Breaker needs per block hardness, means: 'reluctance' * hardness + min_time, you change the 'reluctance' here.The unit is ticks/hardness. The config value can be changed on-the-fly for tuning.").defineInRange("block_breaker_reluctance", 17, 5, 50);
            this.block_breaker_min_breaking_time = builder.translation("engineersdecor.config.block_breaker_min_breaking_time").comment("Defines how much time the Small Block Breaker needs at least, better said it's an offset: 'reluctance' * hardness + min_time, you change the 'min_time' here, value in ticks.The config value can be changed on-the-fly for tuning.").defineInRange("block_breaker_min_breaking_time", 15, 10, 100);
            this.block_breaker_requires_power = builder.translation("engineersdecor.config.block_breaker_requires_power").comment("Defines if the Small Block Breaker does not work without RF power.").define("block_breaker_requires_power", false);
            this.tree_cuttter_energy_consumption = builder.translation("engineersdecor.config.tree_cuttter_energy_consumption").comment("Defines how much RF power the Small Tree Cutter requires to magnificently increase the processing speed. The config value can be changed on-the-fly for tuning.").defineInRange("tree_cuttter_energy_consumption", 64, 4, 1024);
            this.tree_cuttter_cutting_time_needed = builder.translation("engineersdecor.config.tree_cuttter_cutting_time_needed").comment("Defines how much time the Small Tree Cutter needs to cut a tree without RF power. The value is in seconds. With energy it is 6 times faster. The config value can be changed on-the-fly for tuning.").defineInRange("tree_cuttter_cutting_time_needed", 60, 10, 240);
            this.tree_cuttter_requires_power = builder.translation("engineersdecor.config.tree_cuttter_requires_power").comment("Defines if the Small Tree Cutter does not work without RF power.").define("tree_cuttter_requires_power", false);
            this.milking_machine_energy_consumption = builder.translation("engineersdecor.config.milking_machine_energy_consumption").comment("Defines how much time the Small Milking Machine needs work. Note this is a permanent standby power, not only when the device does something. Use zero to disable energy dependency and energy handling of the machine. The config value can be changed on-the-fly for tuning.").defineInRange("milking_machine_energy_consumption", 0, 0, 1024);
            this.milking_machine_milking_delay = builder.translation("engineersdecor.config.milking_machine_milking_delay").comment("Defines (for each individual cow) the minimum time between milking.").defineInRange("milking_machine_milking_delay", 4000, 1000, 24000);
            builder.pop();
        }
    }

    public static class CommonConfig {
        CommonConfig(ForgeConfigSpec.Builder builder) {
        }
    }

    public static class ClientConfig {
        public final ForgeConfigSpec.BooleanValue without_tooltips;
        public final ForgeConfigSpec.BooleanValue without_ters;

        ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings not loaded on servers.").push("client");
            builder.comment("Opt-out settings").push("optout");
            this.without_tooltips = builder.translation("engineersdecor.config.without_tooltips").comment("Disable CTRL-SHIFT item tooltip display.").define("without_tooltips", false);
            this.without_ters = builder.translation("engineersdecor.config.without_ters").comment("Disable all TERs (tile entity renderers).").define("without_ters", false);
            builder.pop();
        }
    }
}

