/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor;

import net.minecraft.block.Block;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wile.engineersdecor.ModConfig;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.blocks.EdCraftingTable;
import wile.engineersdecor.blocks.EdLadderBlock;
import wile.engineersdecor.libmc.datagen.LootTableGen;
import wile.engineersdecor.libmc.detail.Auxiliaries;
import wile.engineersdecor.libmc.detail.Networking;
import wile.engineersdecor.libmc.detail.OptionalRecipeCondition;
import wile.engineersdecor.libmc.detail.Overlay;

@Mod(value="engineersdecor")
public class ModEngineersDecor {
    public static final String MODID = "engineersdecor";
    public static final String MODNAME = "Engineer's Decor";
    public static final int VERSION_DATAFIXER = 0;
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean config_loaded = false;
    public static final ItemGroup ITEMGROUP = new ItemGroup("tabengineersdecor"){

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ModContent.SIGN_MODLOGO);
        }
    };

    public ModEngineersDecor() {
        Auxiliaries.init(MODID, LOGGER, ModConfig::getServerConfig);
        Auxiliaries.logGitVersion(MODNAME);
        OptionalRecipeCondition.init(MODID, LOGGER);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onSendImc);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onRecvImc);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, ModConfig.SERVER_CONFIG_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ModConfig.CLIENT_CONFIG_SPEC);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static final Logger logger() {
        return LOGGER;
    }

    private void onSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Registering recipe condition processor ...");
        CraftingHelper.register((IConditionSerializer)OptionalRecipeCondition.Serializer.INSTANCE);
        Networking.init(MODID);
        if (config_loaded) {
            try {
                ModEngineersDecor.logger().info("Applying loaded config file.");
                ModConfig.apply();
            }
            catch (Throwable e) {
                ModEngineersDecor.logger().error("Failed to apply config: " + e.getMessage());
            }
        } else {
            ModEngineersDecor.logger().info("Cannot apply config, load event was not casted yet.");
        }
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        ModContent.registerContainerGuis(event);
        ModContent.registerTileEntityRenderers(event);
        ModContent.processContentClientSide(event);
        Overlay.register();
    }

    private void onSendImc(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"inventorysorter", (String)"containerblacklist", () -> ModContent.CT_TREATED_WOOD_CRAFTING_TABLE.getRegistryName());
        InterModComms.sendTo((String)"inventorysorter", (String)"slotblacklist", () -> EdCraftingTable.CraftingOutputSlot.class.getName());
        InterModComms.sendTo((String)"inventorysorter", (String)"slotblacklist", () -> EdCraftingTable.CraftingGridSlot.class.getName());
    }

    private void onRecvImc(InterModProcessEvent event) {
    }

    @SubscribeEvent
    public void onPlayerEvent(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        if (player.field_70170_p == null) {
            return;
        }
        if (player.func_70617_f_()) {
            EdLadderBlock.onPlayerUpdateEvent(player);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ForgeEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> event) {
            ModContent.registerBlocks(event);
        }

        @SubscribeEvent
        public static void onItemRegistry(RegistryEvent.Register<Item> event) {
            ModContent.registerBlockItems(event);
        }

        @SubscribeEvent
        public static void onTileEntityRegistry(RegistryEvent.Register<TileEntityType<?>> event) {
            ModContent.registerTileEntities(event);
        }

        @SubscribeEvent
        public static void onRegisterEntityTypes(RegistryEvent.Register<EntityType<?>> event) {
            ModContent.registerEntities(event);
        }

        @SubscribeEvent
        public static void onRegisterContainerTypes(RegistryEvent.Register<ContainerType<?>> event) {
            ModContent.registerContainers(event);
        }

        public static void onServerStarting(FMLServerStartingEvent event) {
        }

        @SubscribeEvent
        public static void onConfigLoad(ModConfig.Loading configEvent) {
            config_loaded = true;
        }

        @SubscribeEvent
        public static void onConfigReload(ModConfig.Reloading configEvent) {
            try {
                ModEngineersDecor.logger().info("Config file changed {}", (Object)configEvent.getConfig().getFileName());
                ModConfig.apply();
            }
            catch (Throwable e) {
                ModEngineersDecor.logger().error("Failed to load changed config: " + e.getMessage());
            }
        }

        @SubscribeEvent
        public static void onDataGeneration(GatherDataEvent event) {
            event.getGenerator().func_200390_a((IDataProvider)new LootTableGen(event.getGenerator(), ModContent::allBlocks));
        }
    }
}

