/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import wile.engineersdecor.blocks.DecorBlock;
import wile.engineersdecor.blocks.IDecorBlock;
import wile.engineersdecor.libmc.detail.Auxiliaries;

public class EdDoubleGateBlock
extends DecorBlock.HorizontalWaterLoggable
implements IDecorBlock {
    public static final IntegerProperty SEGMENT = IntegerProperty.func_177719_a((String)"segment", (int)0, (int)1);
    public static final BooleanProperty OPEN = FenceGateBlock.field_176466_a;
    public static final int SEGMENT_LOWER = 0;
    public static final int SEGMENT_UPPER = 1;
    protected final ArrayList<VoxelShape> collision_shapes_;

    public EdDoubleGateBlock(long config, AbstractBlock.Properties properties, AxisAlignedBB aabb) {
        this(config, properties, new AxisAlignedBB[]{aabb});
    }

    public EdDoubleGateBlock(long config, AbstractBlock.Properties properties, AxisAlignedBB[] aabbs) {
        super(config, properties, aabbs);
        AxisAlignedBB[] caabbs = new AxisAlignedBB[aabbs.length];
        for (int i = 0; i < caabbs.length; ++i) {
            caabbs[i] = aabbs[i].func_72321_a(0.0, 0.5, 0.0);
        }
        this.collision_shapes_ = new ArrayList<VoxelShape>(Arrays.asList(VoxelShapes.func_197868_b(), VoxelShapes.func_197868_b(), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(caabbs, Direction.NORTH, true)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(caabbs, Direction.SOUTH, true)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(caabbs, Direction.WEST, true)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(caabbs, Direction.EAST, true)), VoxelShapes.func_197868_b(), VoxelShapes.func_197868_b()));
    }

    @Override
    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
        return (Boolean)state.func_177229_b((Property)OPEN) != false ? VoxelShapes.func_197880_a() : this.collision_shapes_.get(((Direction)state.func_177229_b((Property)HORIZONTAL_FACING)).func_176745_a() & 7);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{SEGMENT}).func_206894_a(new Property[]{OPEN});
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getInitialState(super.func_196258_a(context), (IWorld)context.func_195991_k(), context.func_195995_a());
    }

    @Override
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        return this.getInitialState(super.func_196271_a(state, facing, facingState, world, pos, facingPos), world, pos);
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (rayTraceResult.func_216354_b() == Direction.UP || rayTraceResult.func_216354_b() == Direction.DOWN && player.func_184586_b(hand).func_77973_b() == this.func_199767_j()) {
            return ActionResultType.PASS;
        }
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        boolean open = (Boolean)state.func_177229_b((Property)OPEN) == false;
        world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(open)), 26);
        if ((Integer)state.func_177229_b((Property)SEGMENT) == 1) {
            BlockState adjacent = world.func_180495_p(pos.func_177977_b());
            if (adjacent.func_177230_c() == this) {
                world.func_180501_a(pos.func_177977_b(), (BlockState)adjacent.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(open)), 26);
            }
        } else {
            BlockState adjacent = world.func_180495_p(pos.func_177984_a());
            if (adjacent.func_177230_c() == this) {
                world.func_180501_a(pos.func_177984_a(), (BlockState)adjacent.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(open)), 26);
            }
        }
        world.func_184133_a(null, pos, open ? SoundEvents.field_187611_cI : SoundEvents.field_187608_cH, SoundCategory.BLOCKS, 0.7f, 1.4f);
        return ActionResultType.SUCCESS;
    }

    public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos pos, PathType type) {
        return (Boolean)state.func_177229_b((Property)OPEN);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockState adjacent;
        BlockPos adjacent_pos;
        if (world.field_72995_K) {
            return;
        }
        boolean powered = false;
        if ((Integer)state.func_177229_b((Property)SEGMENT) == 1) {
            adjacent_pos = pos.func_177977_b();
            adjacent = world.func_180495_p(adjacent_pos);
            if (adjacent.func_177230_c() != this) {
                adjacent = null;
            }
            if (world.func_175651_c(pos.func_177984_a(), Direction.UP) > 0) {
                powered = true;
            } else if (adjacent != null && world.func_175640_z(pos.func_177979_c(2))) {
                powered = true;
            }
        } else {
            adjacent_pos = pos.func_177984_a();
            adjacent = world.func_180495_p(adjacent_pos);
            if (adjacent.func_177230_c() != this) {
                adjacent = null;
            }
            if (world.func_175640_z(pos)) {
                powered = true;
            } else if (adjacent != null && world.func_175651_c(pos.func_177981_b(2), Direction.UP) > 0) {
                powered = true;
            }
        }
        boolean sound = false;
        if (powered != (Boolean)state.func_177229_b((Property)OPEN)) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(powered)), 26);
            sound = true;
        }
        if (adjacent != null && powered != (Boolean)adjacent.func_177229_b((Property)OPEN)) {
            world.func_180501_a(adjacent_pos, (BlockState)adjacent.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(powered)), 26);
            sound = true;
        }
        if (sound) {
            world.func_184133_a(null, pos, powered ? SoundEvents.field_187611_cI : SoundEvents.field_187608_cH, SoundCategory.BLOCKS, 0.7f, 1.4f);
        }
    }

    private BlockState getInitialState(BlockState state, IWorld world, BlockPos pos) {
        BlockState down = world.func_180495_p(pos.func_177977_b());
        if (down.func_177230_c() == this) {
            return (BlockState)((BlockState)((BlockState)state.func_206870_a((Property)SEGMENT, (Comparable)Integer.valueOf(1))).func_206870_a((Property)OPEN, down.func_177229_b((Property)OPEN))).func_206870_a((Property)HORIZONTAL_FACING, down.func_177229_b((Property)HORIZONTAL_FACING));
        }
        BlockState up = world.func_180495_p(pos.func_177984_a());
        if (up.func_177230_c() == this) {
            return (BlockState)((BlockState)((BlockState)state.func_206870_a((Property)SEGMENT, (Comparable)Integer.valueOf(0))).func_206870_a((Property)OPEN, up.func_177229_b((Property)OPEN))).func_206870_a((Property)HORIZONTAL_FACING, up.func_177229_b((Property)HORIZONTAL_FACING));
        }
        return (BlockState)((BlockState)state.func_206870_a((Property)SEGMENT, (Comparable)Integer.valueOf(0))).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false));
    }
}

