/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import wile.engineersdecor.blocks.DecorBlock;
import wile.engineersdecor.blocks.IDecorBlock;
import wile.engineersdecor.libmc.blocks.StandardBlocks;

public class EdHatchBlock
extends DecorBlock.HorizontalWaterLoggable
implements IDecorBlock {
    public static final BooleanProperty OPEN = BlockStateProperties.field_208193_t;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    protected final ArrayList<VoxelShape> vshapes_open;

    public EdHatchBlock(long config, AbstractBlock.Properties builder, AxisAlignedBB unrotatedAABBClosed, AxisAlignedBB unrotatedAABBOpen) {
        super(config, builder, unrotatedAABBClosed);
        this.vshapes_open = EdHatchBlock.makeHorizontalShapeLookup(new AxisAlignedBB[]{unrotatedAABBOpen});
        this.func_180632_j((BlockState)((BlockState)super.func_176223_P().func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public EdHatchBlock(long config, AbstractBlock.Properties builder, AxisAlignedBB[] unrotatedAABBsClosed, AxisAlignedBB[] unrotatedAABBsOpen) {
        super(config, builder, unrotatedAABBsClosed);
        this.vshapes_open = EdHatchBlock.makeHorizontalShapeLookup(unrotatedAABBsOpen);
    }

    @Override
    public StandardBlocks.IStandardBlock.RenderTypeHint getRenderTypeHint() {
        return StandardBlocks.IStandardBlock.RenderTypeHint.CUTOUT;
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader source, BlockPos pos, ISelectionContext selectionContext) {
        return (Boolean)state.func_177229_b((Property)OPEN) != false ? this.vshapes_open.get(((Direction)state.func_177229_b((Property)HORIZONTAL_FACING)).func_176745_a() & 7) : super.func_220053_a(state, source, pos, selectionContext);
    }

    @Override
    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)OPEN);
    }

    public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos pos, PathType type) {
        return (Boolean)state.func_177229_b((Property)OPEN);
    }

    public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        return (Boolean)state.func_177229_b((Property)OPEN);
    }

    public boolean canCreatureSpawn(BlockState state, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, @Nullable EntityType<?> entityType) {
        return false;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{OPEN, POWERED});
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (world.field_72995_K) {
            return ActionResultType.CONSUME;
        }
        boolean open = (Boolean)state.func_177229_b((Property)OPEN) == false;
        world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
        world.func_184133_a(null, pos, open ? SoundEvents.field_187611_cI : SoundEvents.field_187608_cH, SoundCategory.BLOCKS, 0.7f, 1.4f);
        return ActionResultType.SUCCESS;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (world.field_72995_K || !(state.func_177230_c() instanceof EdHatchBlock)) {
            return;
        }
        boolean powered = world.func_175640_z(pos);
        if (powered == (Boolean)state.func_177229_b((Property)POWERED)) {
            return;
        }
        if (powered != (Boolean)state.func_177229_b((Property)OPEN)) {
            world.func_184133_a(null, pos, powered ? SoundEvents.field_187611_cI : SoundEvents.field_187608_cH, SoundCategory.BLOCKS, 0.7f, 1.4f);
        }
        world.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(powered))).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 3);
    }
}

