/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.blocks.DecorBlock;
import wile.engineersdecor.blocks.EdStraightPoleBlock;
import wile.engineersdecor.blocks.IDecorBlock;
import wile.engineersdecor.libmc.blocks.StandardBlocks;
import wile.engineersdecor.libmc.detail.Auxiliaries;

public class EdHorizontalSupportBlock
extends DecorBlock.WaterLoggable
implements IDecorBlock {
    public static final BooleanProperty EASTWEST = BooleanProperty.func_177716_a((String)"eastwest");
    public static final BooleanProperty LEFTBEAM = BooleanProperty.func_177716_a((String)"leftbeam");
    public static final BooleanProperty RIGHTBEAM = BooleanProperty.func_177716_a((String)"rightbeam");
    public static final IntegerProperty DOWNCONNECT = IntegerProperty.func_177719_a((String)"downconnect", (int)0, (int)2);
    protected final ArrayList<VoxelShape> AABBs;

    public EdHorizontalSupportBlock(long config, AbstractBlock.Properties builder, AxisAlignedBB unrotatedAABB) {
        super(config | 0x10L, builder);
        this.AABBs = new ArrayList<VoxelShape>(Arrays.asList(VoxelShapes.func_197881_a((AxisAlignedBB)Auxiliaries.getRotatedAABB(unrotatedAABB.func_72314_b(0.125, 0.0, 0.0), Direction.NORTH, true)), VoxelShapes.func_197881_a((AxisAlignedBB)Auxiliaries.getRotatedAABB(unrotatedAABB.func_72314_b(0.125, 0.0, 0.0), Direction.WEST, true)), VoxelShapes.func_197881_a((AxisAlignedBB)Auxiliaries.getRotatedAABB(unrotatedAABB, Direction.NORTH, true)), VoxelShapes.func_197881_a((AxisAlignedBB)Auxiliaries.getRotatedAABB(unrotatedAABB, Direction.WEST, true))));
    }

    @Override
    public StandardBlocks.IStandardBlock.RenderTypeHint getRenderTypeHint() {
        return StandardBlocks.IStandardBlock.RenderTypeHint.CUTOUT;
    }

    @Override
    public boolean func_181623_g() {
        return false;
    }

    public boolean canCreatureSpawn(BlockState state, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, @Nullable EntityType<?> entityType) {
        return false;
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader source, BlockPos pos, ISelectionContext selectionContext) {
        return this.AABBs.get((Boolean)state.func_177229_b((Property)EASTWEST) != false ? 1 : 0);
    }

    @Override
    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
        return this.func_220053_a(state, world, pos, selectionContext);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{EASTWEST, RIGHTBEAM, LEFTBEAM, DOWNCONNECT});
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.temp_block_update_until_better((BlockState)super.func_196258_a(context).func_206870_a((Property)EASTWEST, (Comparable)Boolean.valueOf(context.func_195992_f().func_176740_k() == Direction.Axis.X)), (IWorld)context.func_195991_k(), context.func_195995_a());
    }

    private BlockState temp_block_update_until_better(BlockState state, IWorld world, BlockPos pos) {
        boolean ew = (Boolean)state.func_177229_b((Property)EASTWEST);
        BlockState rstate = world.func_180495_p(!ew ? pos.func_177974_f() : pos.func_177968_d());
        BlockState lstate = world.func_180495_p(!ew ? pos.func_177976_e() : pos.func_177978_c());
        BlockState dstate = world.func_180495_p(pos.func_177977_b());
        int down_connector = 0;
        if (dstate.func_177230_c() instanceof EdStraightPoleBlock) {
            Direction dfacing = (Direction)dstate.func_177229_b((Property)EdStraightPoleBlock.FACING);
            EdStraightPoleBlock pole = (EdStraightPoleBlock)dstate.func_177230_c();
            if (dfacing.func_176740_k() == Direction.Axis.Y) {
                if (pole == ModContent.THICK_STEEL_POLE || pole == ModContent.THICK_STEEL_POLE_HEAD && dfacing == Direction.UP) {
                    down_connector = 2;
                } else if (pole == ModContent.THIN_STEEL_POLE || pole == ModContent.THIN_STEEL_POLE_HEAD && dfacing == Direction.UP) {
                    down_connector = 1;
                }
            }
        }
        return (BlockState)((BlockState)((BlockState)state.func_206870_a((Property)RIGHTBEAM, (Comparable)Boolean.valueOf(rstate.func_177230_c() == this && (Boolean)rstate.func_177229_b((Property)EASTWEST) != ew))).func_206870_a((Property)LEFTBEAM, (Comparable)Boolean.valueOf(lstate.func_177230_c() == this && (Boolean)lstate.func_177229_b((Property)EASTWEST) != ew))).func_206870_a((Property)DOWNCONNECT, (Comparable)Integer.valueOf(down_connector));
    }

    @Override
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        return this.temp_block_update_until_better(state, world, pos);
    }

    @Deprecated
    public void neighborChanged(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        world.func_175656_a(pos, this.temp_block_update_until_better(state, (IWorld)world, pos));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return rot == Rotation.CLOCKWISE_180 ? state : (BlockState)state.func_206870_a((Property)EASTWEST, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((Property)EASTWEST) == false));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state;
    }
}

