/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.engineersdecor.blocks.IDecorBlock;
import wile.engineersdecor.libmc.blocks.StandardBlocks;
import wile.engineersdecor.libmc.detail.Auxiliaries;

public class EdLadderBlock
extends LadderBlock
implements IDecorBlock {
    protected static final AxisAlignedBB EDLADDER_UNROTATED_AABB = Auxiliaries.getPixeledAABB(3.0, 0.0, 0.0, 13.0, 16.0, 3.0);
    protected static final VoxelShape EDLADDER_SOUTH_AABB = VoxelShapes.func_197881_a((AxisAlignedBB)Auxiliaries.getRotatedAABB(EDLADDER_UNROTATED_AABB, Direction.SOUTH, false));
    protected static final VoxelShape EDLADDER_EAST_AABB = VoxelShapes.func_197881_a((AxisAlignedBB)Auxiliaries.getRotatedAABB(EDLADDER_UNROTATED_AABB, Direction.EAST, false));
    protected static final VoxelShape EDLADDER_WEST_AABB = VoxelShapes.func_197881_a((AxisAlignedBB)Auxiliaries.getRotatedAABB(EDLADDER_UNROTATED_AABB, Direction.WEST, false));
    protected static final VoxelShape EDLADDER_NORTH_AABB = VoxelShapes.func_197881_a((AxisAlignedBB)Auxiliaries.getRotatedAABB(EDLADDER_UNROTATED_AABB, Direction.NORTH, false));
    private static boolean without_speed_boost_ = false;

    public static void on_config(boolean without_speed_boost) {
        without_speed_boost_ = without_speed_boost;
    }

    public EdLadderBlock(long config, AbstractBlock.Properties builder) {
        super(builder);
    }

    @Override
    public StandardBlocks.IStandardBlock.RenderTypeHint getRenderTypeHint() {
        return StandardBlocks.IStandardBlock.RenderTypeHint.CUTOUT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        Auxiliaries.Tooltip.addInformation(stack, world, tooltip, flag, true);
    }

    public VoxelShape getShape(BlockState state, IBlockReader worldIn, BlockPos pos) {
        switch ((Direction)state.func_177229_b((Property)field_176382_a)) {
            case NORTH: {
                return EDLADDER_NORTH_AABB;
            }
            case SOUTH: {
                return EDLADDER_SOUTH_AABB;
            }
            case WEST: {
                return EDLADDER_WEST_AABB;
            }
        }
        return EDLADDER_EAST_AABB;
    }

    public boolean func_181623_g() {
        return false;
    }

    public boolean canCreatureSpawn(BlockState state, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, @Nullable EntityType<?> entityType) {
        return false;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.NORMAL;
    }

    public static void onPlayerUpdateEvent(PlayerEntity player) {
        if (without_speed_boost_ || player.func_233570_aj_() || !player.func_70617_f_() || player.func_226271_bk_() || player.func_175149_v()) {
            return;
        }
        double lvy = player.func_70040_Z().field_72448_b;
        if (Math.abs(lvy) < 0.94) {
            return;
        }
        BlockPos pos = player.func_233580_cy_();
        BlockState state = player.field_70170_p.func_180495_p(pos);
        if (!(state.func_177230_c() instanceof EdLadderBlock)) {
            return;
        }
        player.field_70143_R = 0.0f;
        player.func_213295_a(state, new Vector3d(0.2, lvy > 0.0 ? 3.0 : 6.0, 0.2));
    }
}

