/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.blocks.DecorBlock;
import wile.engineersdecor.blocks.IDecorBlock;
import wile.engineersdecor.libmc.detail.Auxiliaries;
import wile.engineersdecor.libmc.detail.Overlay;

public class EdSolarPanel {

    public static class SolarPanelTileEntity
    extends TileEntity
    implements ITickableTileEntity,
    ICapabilityProvider,
    IEnergyStorage {
        public static final int DEFAULT_PEAK_POWER = 40;
        public static final int TICK_INTERVAL = 8;
        public static final int ACCUMULATION_INTERVAL = 4;
        private static final Direction[] transfer_directions_ = new Direction[]{Direction.DOWN, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.NORTH};
        private static int peak_power_per_tick_ = 40;
        private static int max_power_storage_ = 64000;
        private static int max_feed_power = 8192;
        private int tick_timer_ = 0;
        private int recalc_timer_ = 0;
        private int accumulated_power_ = 0;
        private int current_production_ = 0;
        private int current_feedin_ = 0;
        private boolean output_enabled_ = false;
        protected LazyOptional<IEnergyStorage> energy_handler_ = LazyOptional.of(() -> this);

        public static void on_config(int peak_power_per_tick) {
            peak_power_per_tick_ = MathHelper.func_76125_a((int)peak_power_per_tick, (int)2, (int)8192);
            ModEngineersDecor.logger().info("Config small solar panel: Peak production:" + peak_power_per_tick_ + "/tick");
        }

        public SolarPanelTileEntity() {
            this(ModContent.TET_SMALL_SOLAR_PANEL);
        }

        public SolarPanelTileEntity(TileEntityType<?> te_type) {
            super(te_type);
        }

        public void readnbt(CompoundNBT nbt, boolean update_packet) {
            this.accumulated_power_ = nbt.func_74762_e("energy");
        }

        protected void writenbt(CompoundNBT nbt, boolean update_packet) {
            nbt.func_74768_a("energy", this.accumulated_power_);
        }

        public void state_message(PlayerEntity player) {
            String soc = Integer.toString(MathHelper.func_76125_a((int)(this.accumulated_power_ * 100 / max_power_storage_), (int)0, (int)100));
            Overlay.show(player, (ITextComponent)Auxiliaries.localizable("block.engineersdecor.small_solar_panel.status", null, soc, max_power_storage_, this.current_production_, this.current_feedin_));
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return false;
        }

        public int getMaxEnergyStored() {
            return max_power_storage_;
        }

        public int getEnergyStored() {
            return this.accumulated_power_;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int p = Math.min(this.accumulated_power_, maxExtract);
            if (!simulate) {
                this.accumulated_power_ -= p;
            }
            return p;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityEnergy.ENERGY) {
                return this.energy_handler_.cast();
            }
            return super.getCapability(capability, facing);
        }

        public void func_230337_a_(BlockState state, CompoundNBT nbt) {
            super.func_230337_a_(state, nbt);
            this.readnbt(nbt, false);
        }

        public CompoundNBT func_189515_b(CompoundNBT nbt) {
            super.func_189515_b(nbt);
            this.writenbt(nbt, false);
            return nbt;
        }

        public void func_145843_s() {
            super.func_145843_s();
            this.energy_handler_.invalidate();
        }

        public void func_73660_a() {
            if (this.field_145850_b.field_72995_K || --this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 8;
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(state.func_177230_c() instanceof SolarPanelBlock)) {
                return;
            }
            this.current_feedin_ = 0;
            if (this.output_enabled_) {
                for (int i = 0; i < transfer_directions_.length && this.accumulated_power_ > 0; ++i) {
                    IEnergyStorage es;
                    Direction f = transfer_directions_[i];
                    TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(f));
                    if (te == null || (es = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, f.func_176734_d()).orElse(null)) == null || !es.canReceive()) continue;
                    int fed = es.receiveEnergy(Math.min(this.accumulated_power_, max_feed_power * 8), false);
                    this.accumulated_power_ = MathHelper.func_76125_a((int)(this.accumulated_power_ - fed), (int)0, (int)this.accumulated_power_);
                    this.current_feedin_ += fed;
                }
            }
            this.current_feedin_ /= 8;
            if (this.accumulated_power_ <= 0 || this.current_feedin_ <= 0) {
                this.output_enabled_ = false;
            }
            if (!this.field_145850_b.func_175710_j(this.field_174879_c)) {
                this.tick_timer_ = 40;
                this.current_production_ = 0;
                if ((Integer)state.func_177229_b((Property)SolarPanelBlock.EXPOSITION) != 2) {
                    this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)SolarPanelBlock.EXPOSITION, (Comparable)Integer.valueOf(2)));
                }
                return;
            }
            if (--this.recalc_timer_ > 0) {
                return;
            }
            this.recalc_timer_ = 4 + (int)(Math.random() + 0.5);
            int theta = ((int)((double)this.field_145850_b.func_72929_e(1.0f) * 57.29577951308232) + 90) % 360;
            int e = 2;
            if (theta > 340) {
                e = 2;
            } else if (theta < 45) {
                e = 0;
            } else if (theta < 80) {
                e = 1;
            } else if (theta < 100) {
                e = 2;
            } else if (theta < 135) {
                e = 3;
            } else if (theta < 190) {
                e = 4;
            }
            BlockState nstate = (BlockState)state.func_206870_a((Property)SolarPanelBlock.EXPOSITION, (Comparable)Integer.valueOf(e));
            if (nstate != state) {
                this.field_145850_b.func_180501_a(this.field_174879_c, nstate, 3);
            }
            double eff = 1.0 - ((double)this.field_145850_b.func_72867_j(1.0f) * 0.6 + (double)this.field_145850_b.func_72819_i(1.0f) * 0.3);
            double ll = (double)this.field_145850_b.func_225524_e_().func_215569_a(LightType.SKY).func_215611_b(this.func_174877_v()) / 15.0;
            double rf = Math.sin(1.5707963267948966 * Math.sqrt((double)(theta < 0 || theta > 180 ? 0 : (theta > 90 ? 180 - theta : theta)) / 90.0));
            this.current_production_ = (int)(Math.min(rf * rf * eff * ll, 1.0) * (double)peak_power_per_tick_);
            this.accumulated_power_ = Math.min(this.accumulated_power_ + this.current_production_ * 32, max_power_storage_);
            if (this.accumulated_power_ >= max_power_storage_ / 5) {
                this.output_enabled_ = true;
            }
        }
    }

    public static class SolarPanelBlock
    extends DecorBlock.Normal
    implements IDecorBlock {
        public static final IntegerProperty EXPOSITION = IntegerProperty.func_177719_a((String)"exposition", (int)0, (int)4);

        public SolarPanelBlock(long config, AbstractBlock.Properties builder, AxisAlignedBB[] unrotatedAABB) {
            super(config, builder, unrotatedAABB);
            this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)EXPOSITION, (Comparable)Integer.valueOf(1)));
        }

        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            super.func_206840_a(builder);
            builder.func_206894_a(new Property[]{EXPOSITION});
        }

        public boolean hasTileEntity(BlockState state) {
            return true;
        }

        @Nullable
        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return new SolarPanelTileEntity();
        }

        @Override
        public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof SolarPanelTileEntity) {
                ((SolarPanelTileEntity)te).state_message(player);
            }
            return ActionResultType.SUCCESS;
        }
    }
}

