/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.detail;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import org.apache.logging.log4j.Logger;
import wile.engineersdecor.ModEngineersDecor;

public class TreeCutting {
    private static Logger LOGGER = ModEngineersDecor.logger();
    private static final List<Vector3i> hoffsets = ImmutableList.of((Object)new Vector3i(1, 0, 0), (Object)new Vector3i(1, 0, 1), (Object)new Vector3i(0, 0, 1), (Object)new Vector3i(-1, 0, 1), (Object)new Vector3i(-1, 0, 0), (Object)new Vector3i(-1, 0, -1), (Object)new Vector3i(0, 0, -1), (Object)new Vector3i(1, 0, -1));

    public static boolean canChop(BlockState state) {
        return TreeCutting.isLog(state);
    }

    private static boolean isLog(BlockState state) {
        return state.func_177230_c().func_203417_a((ITag)BlockTags.field_200031_h) || state.func_177230_c().getTags().contains(new ResourceLocation("minecraft", "logs"));
    }

    private static boolean isSameLog(BlockState a, BlockState b) {
        return a.func_177230_c() == b.func_177230_c();
    }

    private static boolean isLeaves(BlockState state) {
        if (state.func_177230_c() instanceof LeavesBlock) {
            return true;
        }
        return state.func_177230_c().getTags().contains(new ResourceLocation("minecraft", "leaves"));
    }

    private static List<BlockPos> findBlocksAround(World world, BlockPos centerPos, BlockState leaf_type_state, Set<BlockPos> checked, int recursion_left) {
        ArrayList<BlockPos> to_decay = new ArrayList<BlockPos>();
        for (int y = -1; y <= 1; ++y) {
            BlockPos layer = centerPos.func_177982_a(0, y, 0);
            for (Vector3i v : hoffsets) {
                BlockPos pos = layer.func_177971_a(v);
                if (checked.contains(pos) || world.func_180495_p(pos).func_177230_c() != leaf_type_state.func_177230_c()) continue;
                checked.add(pos);
                to_decay.add(pos);
                if (recursion_left <= 0) continue;
                to_decay.addAll(TreeCutting.findBlocksAround(world, pos, leaf_type_state, checked, recursion_left - 1));
            }
        }
        return to_decay;
    }

    private static void breakBlock(World world, BlockPos pos) {
        Block.func_220075_c((BlockState)world.func_180495_p(pos), (World)world, (BlockPos)pos);
        if (world.func_180501_a(pos, world.func_204610_c(pos).func_206883_i(), 11)) {
            // empty if block
        }
    }

    public static int chopTree(World world, BlockState broken_state, BlockPos startPos, int max_blocks_to_break, boolean without_target_block) {
        if (world.field_72995_K || !TreeCutting.isLog(broken_state)) {
            return 0;
        }
        long ymin = startPos.func_177956_o();
        long max_leaf_distance = 6L;
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        ArrayList<BlockPos> to_break = new ArrayList<BlockPos>();
        ArrayList<BlockPos> to_decay = new ArrayList<BlockPos>();
        checked.add(startPos);
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        LinkedList<BlockPos> upqueue = new LinkedList<BlockPos>();
        queue.add(startPos);
        int cutlevel = 0;
        int steps_left = 64;
        while (!queue.isEmpty() && --steps_left >= 0) {
            BlockPos pos = (BlockPos)queue.removeFirst();
            BlockPos uppos = pos.func_177984_a();
            BlockState upstate = world.func_180495_p(uppos);
            if (!checked.contains(uppos)) {
                checked.add(uppos);
                if (TreeCutting.isSameLog(upstate, broken_state)) {
                    upqueue.add(uppos);
                    to_break.add(uppos);
                    steps_left = 64;
                } else {
                    boolean isleaf = TreeCutting.isLeaves(upstate);
                    if (isleaf || world.func_175623_d(uppos) || upstate.func_177230_c() instanceof VineBlock) {
                        if (isleaf) {
                            to_decay.add(uppos);
                        }
                        for (Vector3i v : hoffsets) {
                            BlockPos p = uppos.func_177971_a(v);
                            if (checked.contains(p)) continue;
                            checked.add(p);
                            BlockState st = world.func_180495_p(p);
                            Block bl = st.func_177230_c();
                            if (TreeCutting.isSameLog(st, broken_state)) {
                                queue.add(p);
                                to_break.add(p);
                                continue;
                            }
                            if (!TreeCutting.isLeaves(st)) continue;
                            to_decay.add(p);
                        }
                    }
                }
            }
            for (Vector3i v : hoffsets) {
                BlockPos p = pos.func_177971_a(v);
                if (checked.contains(p)) continue;
                checked.add(p);
                if (p.func_177951_i((Vector3i)new BlockPos(startPos.func_177958_n(), p.func_177956_o(), startPos.func_177952_p())) > (double)(3 + cutlevel * cutlevel)) continue;
                BlockState st = world.func_180495_p(p);
                Block bl = st.func_177230_c();
                if (TreeCutting.isSameLog(st, broken_state)) {
                    queue.add(p);
                    to_break.add(p);
                    continue;
                }
                if (!TreeCutting.isLeaves(st)) continue;
                to_decay.add(p);
            }
            if (!queue.isEmpty() || upqueue.isEmpty()) continue;
            queue = upqueue;
            upqueue = new LinkedList();
            ++cutlevel;
        }
        for (BlockPos pos : to_decay) {
            int dist = 1;
            to_break.addAll(TreeCutting.findBlocksAround(world, pos, broken_state, checked, dist));
        }
        if (!to_decay.isEmpty()) {
            BlockState leaf_type_state = world.func_180495_p((BlockPos)to_decay.get(0));
            ArrayList<BlockPos> leafs = to_decay;
            to_decay = new ArrayList();
            for (BlockPos pos : leafs) {
                int dist = 2;
                to_decay.add(pos);
                to_decay.addAll(TreeCutting.findBlocksAround(world, pos, leaf_type_state, checked, dist));
            }
        }
        if (without_target_block) {
            checked.remove(startPos);
        } else {
            to_break.add(startPos);
        }
        for (BlockPos pos : to_break) {
            TreeCutting.breakBlock(world, pos);
        }
        for (BlockPos pos : to_decay) {
            TreeCutting.breakBlock(world, pos);
        }
        return MathHelper.func_76125_a((int)(to_break.size() * 6 / 5 + to_decay.size() / 10 - 1), (int)1, (int)65535);
    }
}

