/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.libmc.blocks;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.WallHeight;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.engineersdecor.libmc.blocks.StandardBlocks;
import wile.engineersdecor.libmc.detail.Auxiliaries;

public class VariantWallBlock
extends WallBlock
implements StandardBlocks.IStandardBlock {
    public static final BooleanProperty UP = BlockStateProperties.field_208149_B;
    public static final EnumProperty<WallHeight> WALL_EAST = BlockStateProperties.field_235908_S_;
    public static final EnumProperty<WallHeight> WALL_NORTH = BlockStateProperties.field_235909_T_;
    public static final EnumProperty<WallHeight> WALL_SOUTH = BlockStateProperties.field_235910_U_;
    public static final EnumProperty<WallHeight> WALL_WEST = BlockStateProperties.field_235911_V_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final IntegerProperty TEXTURE_VARIANT = IntegerProperty.func_177719_a((String)"tvariant", (int)0, (int)7);
    private final Map<BlockState, VoxelShape> shape_voxels = this.buildWallShapes(4.0, 16.0, 4.0, 0.0, 16.0, 16.0);
    private final Map<BlockState, VoxelShape> collision_shape_voxels = this.buildWallShapes(6.0, 16.0, 5.0, 0.0, 24.0, 24.0);
    private final long config;

    public VariantWallBlock(long config, AbstractBlock.Properties builder) {
        super(builder);
        this.config = config;
    }

    @Override
    public long config() {
        return this.config;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        Auxiliaries.Tooltip.addInformation(stack, world, tooltip, flag, true);
    }

    private static VoxelShape combinedShape(VoxelShape pole, WallHeight height, VoxelShape low, VoxelShape high) {
        if (height == WallHeight.TALL) {
            return VoxelShapes.func_197872_a((VoxelShape)pole, (VoxelShape)high);
        }
        if (height == WallHeight.LOW) {
            return VoxelShapes.func_197872_a((VoxelShape)pole, (VoxelShape)low);
        }
        return pole;
    }

    protected Map<BlockState, VoxelShape> buildWallShapes(double pole_width, double pole_height, double side_width, double side_min_y, double side_max_low_y, double side_max_tall_y) {
        double px0 = 8.0 - pole_width;
        double px1 = 8.0 + pole_width;
        double sx0 = 8.0 - side_width;
        double sx1 = 8.0 + side_width;
        VoxelShape vp = Block.func_208617_a((double)px0, (double)0.0, (double)px0, (double)px1, (double)pole_height, (double)px1);
        VoxelShape vs1 = Block.func_208617_a((double)sx0, (double)side_min_y, (double)0.0, (double)sx1, (double)side_max_low_y, (double)sx1);
        VoxelShape vs2 = Block.func_208617_a((double)sx0, (double)side_min_y, (double)sx0, (double)sx1, (double)side_max_low_y, (double)16.0);
        VoxelShape vs3 = Block.func_208617_a((double)0.0, (double)side_min_y, (double)sx0, (double)sx1, (double)side_max_low_y, (double)sx1);
        VoxelShape vs4 = Block.func_208617_a((double)sx0, (double)side_min_y, (double)sx0, (double)16.0, (double)side_max_low_y, (double)sx1);
        VoxelShape vs5 = Block.func_208617_a((double)sx0, (double)side_min_y, (double)0.0, (double)sx1, (double)side_max_tall_y, (double)sx1);
        VoxelShape vs6 = Block.func_208617_a((double)sx0, (double)side_min_y, (double)sx0, (double)sx1, (double)side_max_tall_y, (double)16.0);
        VoxelShape vs7 = Block.func_208617_a((double)0.0, (double)side_min_y, (double)sx0, (double)sx1, (double)side_max_tall_y, (double)sx1);
        VoxelShape vs8 = Block.func_208617_a((double)sx0, (double)side_min_y, (double)sx0, (double)16.0, (double)side_max_tall_y, (double)sx1);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Boolean up : UP.func_177700_c()) {
            for (WallHeight wh_east : WALL_EAST.func_177700_c()) {
                for (WallHeight wh_north : WALL_NORTH.func_177700_c()) {
                    for (WallHeight wh_west : WALL_WEST.func_177700_c()) {
                        for (WallHeight wh_south : WALL_SOUTH.func_177700_c()) {
                            VoxelShape shape = VoxelShapes.func_197880_a();
                            shape = VariantWallBlock.combinedShape(shape, wh_east, vs4, vs8);
                            shape = VariantWallBlock.combinedShape(shape, wh_west, vs3, vs7);
                            shape = VariantWallBlock.combinedShape(shape, wh_north, vs1, vs5);
                            shape = VariantWallBlock.combinedShape(shape, wh_south, vs2, vs6);
                            if (up.booleanValue()) {
                                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)vp);
                            }
                            BlockState bs = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)UP, (Comparable)up)).func_206870_a(WALL_EAST, (Comparable)wh_east)).func_206870_a(WALL_NORTH, (Comparable)wh_north)).func_206870_a(WALL_WEST, (Comparable)wh_west)).func_206870_a(WALL_SOUTH, (Comparable)wh_south);
                            VoxelShape tvs = shape;
                            TEXTURE_VARIANT.func_177700_c().forEach(tv -> {
                                builder.put(((BlockState)bs.func_206870_a((Property)TEXTURE_VARIANT, (Comparable)tv)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), (Object)tvs);
                                builder.put(((BlockState)bs.func_206870_a((Property)TEXTURE_VARIANT, (Comparable)tv)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), (Object)tvs);
                            });
                        }
                    }
                }
            }
        }
        return builder.build();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
        return this.shape_voxels.getOrDefault(state, VoxelShapes.func_197868_b());
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
        return this.collision_shape_voxels.getOrDefault(state, VoxelShapes.func_197868_b());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{TEXTURE_VARIANT});
    }

    private boolean attachesTo(BlockState facingState, IWorldReader world, BlockPos facingPos, Direction side) {
        Block block = facingState.func_177230_c();
        if (block instanceof FenceGateBlock || block instanceof WallBlock) {
            return true;
        }
        BlockState oppositeState = world.func_180495_p(facingPos.func_177967_a(side, 2));
        if (!(oppositeState.func_177230_c() instanceof VariantWallBlock)) {
            return false;
        }
        return facingState.func_215686_e((IBlockReader)world, facingPos) && VariantWallBlock.func_220056_d((BlockState)facingState, (IBlockReader)world, (BlockPos)facingPos, (Direction)side);
    }

    protected WallHeight selectWallHeight(IWorldReader world, BlockPos pos, Direction direction) {
        return WallHeight.LOW;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        FluidState fs = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean n = this.attachesTo(world.func_180495_p(pos.func_177978_c()), (IWorldReader)world, pos.func_177978_c(), Direction.SOUTH);
        boolean e = this.attachesTo(world.func_180495_p(pos.func_177974_f()), (IWorldReader)world, pos.func_177974_f(), Direction.WEST);
        boolean s = this.attachesTo(world.func_180495_p(pos.func_177968_d()), (IWorldReader)world, pos.func_177968_d(), Direction.NORTH);
        boolean w = this.attachesTo(world.func_180495_p(pos.func_177976_e()), (IWorldReader)world, pos.func_177976_e(), Direction.EAST);
        boolean not_straight = !(n && s && !e && !w || !n && !s && e && w);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)UP, (Comparable)Boolean.valueOf(not_straight))).func_206870_a(WALL_NORTH, (Comparable)(n ? this.selectWallHeight((IWorldReader)world, pos, Direction.NORTH) : WallHeight.NONE))).func_206870_a(WALL_EAST, (Comparable)(e ? this.selectWallHeight((IWorldReader)world, pos, Direction.EAST) : WallHeight.NONE))).func_206870_a(WALL_SOUTH, (Comparable)(s ? this.selectWallHeight((IWorldReader)world, pos, Direction.SOUTH) : WallHeight.NONE))).func_206870_a(WALL_WEST, (Comparable)(w ? this.selectWallHeight((IWorldReader)world, pos, Direction.WEST) : WallHeight.NONE))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fs.func_206886_c() == Fluids.field_204546_a));
    }

    public BlockState func_196271_a(BlockState state, Direction side, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        boolean s;
        boolean e;
        boolean n;
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        if (side == Direction.DOWN) {
            return super.func_196271_a(state, side, facingState, world, pos, facingPos);
        }
        boolean bl = side == Direction.NORTH ? this.attachesTo(facingState, (IWorldReader)world, facingPos, side) : (n = state.func_177229_b(WALL_NORTH) != WallHeight.NONE);
        boolean bl2 = side == Direction.EAST ? this.attachesTo(facingState, (IWorldReader)world, facingPos, side) : (e = state.func_177229_b(WALL_EAST) != WallHeight.NONE);
        boolean bl3 = side == Direction.SOUTH ? this.attachesTo(facingState, (IWorldReader)world, facingPos, side) : (s = state.func_177229_b(WALL_SOUTH) != WallHeight.NONE);
        boolean w = side == Direction.WEST ? this.attachesTo(facingState, (IWorldReader)world, facingPos, side) : state.func_177229_b(WALL_WEST) != WallHeight.NONE;
        boolean not_straight = !(n && s && !e && !w || !n && !s && e && w);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)UP, (Comparable)Boolean.valueOf(not_straight))).func_206870_a(WALL_NORTH, (Comparable)(n ? this.selectWallHeight((IWorldReader)world, pos, Direction.NORTH) : WallHeight.NONE))).func_206870_a(WALL_EAST, (Comparable)(e ? this.selectWallHeight((IWorldReader)world, pos, Direction.EAST) : WallHeight.NONE))).func_206870_a(WALL_SOUTH, (Comparable)(s ? this.selectWallHeight((IWorldReader)world, pos, Direction.SOUTH) : WallHeight.NONE))).func_206870_a(WALL_WEST, (Comparable)(w ? this.selectWallHeight((IWorldReader)world, pos, Direction.WEST) : WallHeight.NONE))).func_206870_a((Property)TEXTURE_VARIANT, (Comparable)Integer.valueOf((int)MathHelper.func_180186_a((Vector3i)pos) & 7));
    }

    public boolean canCreatureSpawn(BlockState state, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, @Nullable EntityType<?> entityType) {
        return false;
    }

    public boolean func_181623_g() {
        return false;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.NORMAL;
    }
}

