/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.equiptooltips;

import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.silentchaos512.equiptooltips.TooltipHandler;
import net.silentchaos512.gems.api.ITool;
import net.silentchaos512.gems.item.tool.ItemGemBow;
import net.silentchaos512.gems.item.tool.ItemGemShield;
import slimeknights.tconstruct.library.tools.AoeToolCore;
import slimeknights.tconstruct.library.tools.SwordCore;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.tools.ranged.BowCore;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class EquipmentStats {
    private final ItemStack stack;
    private ItemType itemType = ItemType.UNKNOWN;
    private float armorProtection = 0.0f;
    private float armorToughness = 0.0f;
    private int durability = 0;
    private int enchantability = 0;
    private int harvestLevel = -1;
    private float harvestSpeed = 0.0f;
    private float magicDamage = 0.0f;
    private float magicProtection = 0.0f;
    private float meleeDamage = 0.0f;
    private float meleeSpeed = 0.0f;
    private float rangedDamage = 0.0f;
    private float rangedSpeed = 0.0f;
    protected static final UUID ATTACK_DAMAGE_MODIFIER = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    protected static final UUID ATTACK_SPEED_MODIFIER = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};

    public EquipmentStats(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            throw new IllegalArgumentException("stack may not be invalid");
        }
        this.stack = stack;
        Item item = stack.func_77973_b();
        this.determineItemType(item);
        this.armorProtection = this.getProtection(stack);
        this.armorToughness = this.getToughness(stack);
        this.durability = stack.func_77984_f() ? stack.func_77958_k() : 0;
        this.enchantability = item.getItemEnchantability(stack);
        this.harvestLevel = this.getHarvestLevel(stack);
        this.harvestSpeed = this.getHarvestSpeed(stack);
        this.magicDamage = this.getMagicDamage(stack);
        this.magicProtection = TooltipHandler.instance.isSilentsGemsLoaded && item instanceof ItemGemShield ? 100.0f * net.silentchaos512.gems.util.ToolHelper.getMagicProtection((ItemStack)stack) : 0.0f;
        this.meleeDamage = this.getMeleeDamage(stack);
        this.meleeSpeed = this.getMeleeSpeed(stack);
        this.rangedDamage = TooltipHandler.instance.isSilentsGemsLoaded && item instanceof ItemGemBow ? 2.0f + ((ItemGemBow)item).getArrowDamage(stack) : 2.0f;
        this.rangedSpeed = TooltipHandler.instance.isSilentsGemsLoaded && item instanceof ItemGemBow ? ((ItemGemBow)item).getDrawSpeedForDisplay(stack) : 1.0f;
    }

    private int getHarvestLevel(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (TooltipHandler.instance.isTinkersLoaded && item instanceof ToolCore) {
            return ToolHelper.getHarvestLevelStat((ItemStack)stack);
        }
        if (!(item instanceof ItemTool)) {
            return -1;
        }
        ItemTool itemTool = (ItemTool)item;
        IBlockState state = this.getBlockForTool(stack);
        int maxLevel = -1;
        for (String toolClass : itemTool.getToolClasses(stack)) {
            int harvestLevel = itemTool.getHarvestLevel(stack, toolClass, null, state);
            maxLevel = Math.max(maxLevel, harvestLevel);
        }
        return maxLevel;
    }

    private float getHarvestSpeed(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (TooltipHandler.instance.isTinkersLoaded && item instanceof ToolCore) {
            return ToolHelper.getMiningSpeedStat((ItemStack)stack);
        }
        IBlockState state = this.getBlockForTool(stack);
        try {
            return item.func_150893_a(stack, state);
        }
        catch (NullPointerException ex) {
            return 0.0f;
        }
    }

    private IBlockState getBlockForTool(ItemStack stack) {
        Item item = stack.func_77973_b();
        Set toolClasses = item.getToolClasses(stack);
        IBlockState state = item instanceof ItemSpade || toolClasses.contains("shovel") ? Blocks.field_150346_d.func_176223_P() : (item instanceof ItemAxe || toolClasses.contains("axe") ? Blocks.field_150364_r.func_176223_P() : (item instanceof ItemShears ? Blocks.field_150325_L.func_176223_P() : Blocks.field_150348_b.func_176223_P()));
        return state;
    }

    private float getMeleeDamage(ItemStack stack) {
        Multimap multimap = stack.func_111283_C(EntityEquipmentSlot.MAINHAND);
        for (Map.Entry entry : multimap.entries()) {
            AttributeModifier mod = (AttributeModifier)entry.getValue();
            if (!mod.func_111167_a().equals(ATTACK_DAMAGE_MODIFIER)) continue;
            return (float)mod.func_111164_d() + 1.0f;
        }
        return 0.0f;
    }

    private float getMagicDamage(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (TooltipHandler.instance.isSilentsGemsLoaded && item instanceof ITool && ((ITool)item).isCaster(stack)) {
            return ((ITool)item).getMagicDamage(stack) + 1.0f;
        }
        return 0.0f;
    }

    private float getMeleeSpeed(ItemStack stack) {
        Multimap multimap = stack.func_111283_C(EntityEquipmentSlot.MAINHAND);
        for (Map.Entry entry : multimap.entries()) {
            AttributeModifier mod = (AttributeModifier)entry.getValue();
            if (!mod.func_111167_a().equals(ATTACK_SPEED_MODIFIER)) continue;
            return (float)mod.func_111164_d() + 4.0f;
        }
        return 0.0f;
    }

    private float getProtection(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ItemArmor)) {
            return 0.0f;
        }
        ItemArmor itemArmor = (ItemArmor)stack.func_77973_b();
        EntityEquipmentSlot slot = itemArmor.field_77881_a;
        UUID uuid = ARMOR_MODIFIERS[slot.func_188454_b()];
        Multimap multimap = stack.func_111283_C(slot);
        for (Map.Entry entry : multimap.entries()) {
            String key = (String)entry.getKey();
            AttributeModifier mod = (AttributeModifier)entry.getValue();
            if (!key.equals(SharedMonsterAttributes.field_188791_g.func_111108_a()) || !mod.func_111167_a().equals(uuid)) continue;
            return (float)mod.func_111164_d();
        }
        return 0.0f;
    }

    private float getToughness(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ItemArmor)) {
            return 0.0f;
        }
        ItemArmor itemArmor = (ItemArmor)stack.func_77973_b();
        EntityEquipmentSlot slot = itemArmor.field_77881_a;
        UUID uuid = ARMOR_MODIFIERS[slot.func_188454_b()];
        Multimap multimap = stack.func_111283_C(slot);
        for (Map.Entry entry : multimap.entries()) {
            String key = (String)entry.getKey();
            AttributeModifier mod = (AttributeModifier)entry.getValue();
            if (!key.equals(SharedMonsterAttributes.field_189429_h.func_111108_a()) || !mod.func_111167_a().equals(uuid)) continue;
            return (float)mod.func_111164_d();
        }
        return 0.0f;
    }

    private void determineItemType(Item item) {
        boolean isTinkersBow;
        boolean isTinkersHarvestTool = TooltipHandler.instance.isTinkersLoaded && item instanceof AoeToolCore;
        boolean isTinkersWeapon = TooltipHandler.instance.isTinkersLoaded && item instanceof SwordCore;
        boolean bl = isTinkersBow = TooltipHandler.instance.isTinkersLoaded && item instanceof BowCore;
        this.itemType = item instanceof ItemArmor ? ItemType.ARMOR : (item instanceof ItemAxe ? ItemType.AXE : (item instanceof ItemBow || isTinkersBow ? ItemType.BOW : (item instanceof ItemFishingRod ? ItemType.FISHING_ROD : (item instanceof ItemHoe ? ItemType.HOE : (item instanceof ItemPickaxe || isTinkersHarvestTool ? ItemType.PICKAXE : (item instanceof ItemShears ? ItemType.SHEARS : (item instanceof ItemShield ? ItemType.SHIELD : (item instanceof ItemSpade ? ItemType.SHOVEL : (item instanceof ItemSword || isTinkersWeapon ? ItemType.SWORD : (item instanceof ItemTool ? ItemType.GENERIC_HARVEST : (this.stack.func_77984_f() ? ItemType.GENERIC_DAMAGEABLE : ItemType.UNKNOWN)))))))))));
    }

    public float getStat(ItemStat stat) {
        switch (stat) {
            case ARMOR_PROTECTION: {
                return this.armorProtection;
            }
            case ARMOR_TOUGHNESS: {
                return this.armorToughness;
            }
            case DURABILITY: {
                return this.durability;
            }
            case ENCHANTABILITY: {
                return this.enchantability;
            }
            case HARVEST_LEVEL: {
                return this.harvestLevel;
            }
            case HARVEST_SPEED: {
                return this.harvestSpeed;
            }
            case MAGIC_DAMAGE: {
                return this.magicDamage;
            }
            case MAGIC_PROTECTION: {
                return this.magicProtection;
            }
            case MELEE_DAMAGE: {
                return this.meleeDamage;
            }
            case MELEE_SPEED: {
                return this.meleeSpeed;
            }
            case RANGED_DAMAGE: {
                return this.rangedDamage;
            }
            case RANGED_SPEED: {
                return this.rangedSpeed;
            }
        }
        throw new IllegalArgumentException("Unknown stat: " + stat.name());
    }

    public ItemType getItemType() {
        return this.itemType;
    }

    public float getArmorProtection() {
        return this.armorProtection;
    }

    public float getArmorToughness() {
        return this.armorToughness;
    }

    public int getDurability() {
        return this.durability;
    }

    public int getEnchantability() {
        return this.enchantability;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }

    public float getHarvestSpeed() {
        return this.harvestSpeed;
    }

    public float getMagicDamage() {
        return this.magicDamage;
    }

    public float getMagicProtection() {
        return this.magicProtection;
    }

    public float getMeleeDamage() {
        return this.meleeDamage;
    }

    public float getMeleeSpeed() {
        return this.meleeSpeed;
    }

    public float getRangedDamage() {
        return this.rangedDamage;
    }

    public float getRangedSpeed() {
        return this.rangedSpeed;
    }

    public static enum ItemType {
        ARMOR("armor", ItemStat.DURABILITY, ItemStat.ARMOR_PROTECTION, ItemStat.ARMOR_TOUGHNESS),
        AXE("axe", ItemStat.DURABILITY, ItemStat.HARVEST_SPEED, ItemStat.MELEE_DAMAGE, ItemStat.MELEE_SPEED),
        BOW("bow", ItemStat.DURABILITY, ItemStat.RANGED_DAMAGE, ItemStat.RANGED_SPEED),
        FISHING_ROD("fishing_rod", ItemStat.DURABILITY),
        GENERIC_DAMAGEABLE("generic_damageable", ItemStat.DURABILITY),
        GENERIC_HARVEST("generic_harvest", ItemStat.DURABILITY, ItemStat.HARVEST_SPEED),
        HOE("hoe", ItemStat.DURABILITY),
        PICKAXE("pickaxe", ItemStat.DURABILITY, ItemStat.HARVEST_LEVEL, ItemStat.HARVEST_SPEED),
        SHEARS("shears", ItemStat.DURABILITY, ItemStat.HARVEST_SPEED),
        SHIELD("shield", ItemStat.DURABILITY, ItemStat.MAGIC_PROTECTION),
        SHOVEL("shovel", ItemStat.DURABILITY, ItemStat.HARVEST_LEVEL, ItemStat.HARVEST_SPEED),
        SWORD("sword", ItemStat.DURABILITY, ItemStat.MELEE_DAMAGE, ItemStat.MAGIC_DAMAGE, ItemStat.MELEE_SPEED),
        UNKNOWN("unknown", ItemStat.DURABILITY);

        public final String key;
        public final ItemStat[] displayStats;

        private ItemType(String key, ItemStat ... itemStats) {
            this.key = key;
            this.displayStats = itemStats;
        }
    }

    public static enum ItemStat {
        ARMOR_PROTECTION(6),
        ARMOR_TOUGHNESS(7, 0.0f, false),
        DURABILITY(0, 0.0f, false),
        ENCHANTABILITY(10),
        HARVEST_LEVEL(1, -1.0f, false),
        HARVEST_SPEED(2),
        MAGIC_DAMAGE(4, 0.0f, false),
        MAGIC_PROTECTION(9, 0.0f, false),
        MELEE_DAMAGE(3),
        MELEE_SPEED(5),
        RANGED_DAMAGE(8),
        RANGED_SPEED(5);

        public final int iconIndex;
        public final float defaultValue;
        public final boolean displayIfDefault;

        private ItemStat(int iconIndex) {
            this(iconIndex, 0.0f, true);
        }

        private ItemStat(int iconIndex, float defaultValue, boolean displayIfDefault) {
            this.iconIndex = iconIndex;
            this.defaultValue = defaultValue;
            this.displayIfDefault = displayIfDefault;
        }

        public boolean shouldRender(EquipmentStats stats) {
            if (this.displayIfDefault) {
                return true;
            }
            float value = stats.getStat(this);
            return value > this.defaultValue;
        }
    }
}

