/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.equiptooltips;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.silentchaos512.equiptooltips.Config;
import net.silentchaos512.equiptooltips.EquipmentStats;
import org.lwjgl.input.Keyboard;

public class TooltipHandler
extends Gui {
    public static final ResourceLocation TEXTURE = new ResourceLocation("equipmenttooltips", "textures/gui/hud.png");
    public static final TooltipHandler instance = new TooltipHandler();
    private int lastWidth = 0;
    public final boolean isTinkersLoaded = Loader.isModLoaded((String)"tconstruct");
    public final boolean isSilentsGemsLoaded = Loader.isModLoaded((String)"silentgems");
    public static final String FORMAT_INT = "%d";
    public static final String FORMAT_FLOAT = "%.2f";

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRenderTooltip(RenderTooltipEvent.PostText event) {
        ItemStack stack;
        if (Config.DISPLAY_CHECK_KEY) {
            boolean shiftPressed;
            boolean bl = shiftPressed = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
            if (Config.DISPLAY_HIDE_ON_KEY && shiftPressed || !Config.DISPLAY_HIDE_ON_KEY && !shiftPressed) {
                return;
            }
        }
        if ((stack = event.getStack()).func_190926_b()) {
            return;
        }
        EquipmentStats hoveredStats = new EquipmentStats(stack);
        if (hoveredStats.getItemType() == EquipmentStats.ItemType.UNKNOWN) {
            return;
        }
        this.renderBackground(event);
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fontRenderer = event.getFontRenderer();
        ItemStack currentEquip = ItemStack.field_190927_a;
        if (hoveredStats.getItemType() == EquipmentStats.ItemType.ARMOR) {
            EntityEquipmentSlot slot = ((ItemArmor)stack.func_77973_b()).field_77881_a;
            for (ItemStack itemstack : mc.field_71439_g.func_184193_aE()) {
                Item item = itemstack.func_77973_b();
                if (itemstack.func_190926_b() || !(item instanceof ItemArmor) || ((ItemArmor)item).field_77881_a != slot) continue;
                currentEquip = itemstack;
            }
        } else {
            currentEquip = mc.field_71439_g.func_184614_ca();
        }
        EquipmentStats equippedStats = currentEquip.func_190926_b() ? null : new EquipmentStats(currentEquip);
        double scale = 0.75;
        int x = (int)((double)(event.getX() + Config.POSITION_X_OFFSET) / scale);
        int y = (int)((double)(event.getY() - 16 + Config.POSITION_Y_OFFSET) / scale);
        if (Config.POSITION_ON_BOTTOM) {
            y = (int)((double)y + ((double)event.getHeight() / scale + 28.0));
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
        mc.field_71446_o.func_110577_a(TEXTURE);
        for (EquipmentStats.ItemStat stat : hoveredStats.getItemType().displayStats) {
            if (!stat.shouldRender(hoveredStats)) continue;
            x = this.renderStat(mc, fontRenderer, x, y, stat, hoveredStats, equippedStats);
        }
        this.lastWidth = (int)((double)x * scale - (double)event.getX());
        GlStateManager.func_179121_F();
    }

    private int renderStat(Minecraft mc, FontRenderer fontRenderer, int x, int y, EquipmentStats.ItemStat stat, EquipmentStats hovered, @Nullable EquipmentStats equipped) {
        if (!stat.shouldRender(hovered)) {
            return x;
        }
        mc.field_71446_o.func_110577_a(TEXTURE);
        this.func_73729_b(x, y, 16 * stat.iconIndex, 240, 16, 16);
        float hoveredStat = hovered.getStat(stat);
        float equippedStat = equipped == null ? stat.defaultValue : equipped.getStat(stat);
        String text = this.formatStat(hoveredStat);
        fontRenderer.func_175063_a(text, (float)(x += 18), (float)(y + 5), 0xFFFFFF);
        x += fontRenderer.func_78256_a(text);
        mc.field_71446_o.func_110577_a(TEXTURE);
        if (equipped == null || hovered.getItemType() != equipped.getItemType()) {
            x += 5;
        } else if (hoveredStat > equippedStat) {
            this.func_73729_b(x, y, 224, 240, 16, 16);
            x += 18;
        } else if (hoveredStat < equippedStat) {
            this.func_73729_b(x, y, 240, 240, 16, 16);
            x += 18;
        } else {
            this.func_73729_b(x, y, 208, 240, 16, 16);
            x += 18;
        }
        return x;
    }

    private String formatStat(float value) {
        if (value == (float)((int)value)) {
            return String.format(FORMAT_INT, (int)value);
        }
        return String.format(FORMAT_FLOAT, Float.valueOf(value));
    }

    private void renderBackground(RenderTooltipEvent.PostText event) {
        int left = event.getX() - 1 + Config.POSITION_X_OFFSET;
        int top = event.getY() - 17 + Config.POSITION_Y_OFFSET;
        int right = Math.max(event.getX() + this.lastWidth, event.getX() + event.getWidth() + 1) + Config.POSITION_X_OFFSET;
        int bottom = event.getY() - 4 + Config.POSITION_Y_OFFSET;
        if (Config.POSITION_ON_BOTTOM) {
            top += event.getHeight() + 21;
            bottom += event.getHeight() + 21;
        }
        TooltipHandler.func_73734_a((int)left, (int)top, (int)right, (int)bottom, (int)Config.BACKGROUND_COLOR);
    }
}

