/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.equiptooltips;

import java.util.function.Supplier;
import net.silentchaos512.equiptooltips.EquipmentStats;
import net.silentchaos512.gear.api.stats.CommonItemStats;

public enum ItemStat {
    ARMOR_PROTECTION(6, () -> () -> CommonItemStats.ARMOR),
    ARMOR_TOUGHNESS(7, 0.0f, false, () -> () -> CommonItemStats.ARMOR_TOUGHNESS),
    DURABILITY(0, 0.0f, false, () -> () -> CommonItemStats.DURABILITY),
    ENCHANTABILITY(10, () -> () -> CommonItemStats.ENCHANTABILITY),
    HARVEST_LEVEL(1, -1.0f, false, () -> () -> CommonItemStats.HARVEST_LEVEL),
    HARVEST_SPEED(2, () -> () -> CommonItemStats.HARVEST_SPEED),
    MAGIC_DAMAGE(4, 0.0f, false, () -> () -> CommonItemStats.MAGIC_DAMAGE),
    MELEE_DAMAGE(3, () -> () -> CommonItemStats.MELEE_DAMAGE),
    MELEE_SPEED(5, () -> () -> CommonItemStats.ATTACK_SPEED),
    RANGED_DAMAGE(8, () -> () -> CommonItemStats.RANGED_DAMAGE),
    RANGED_SPEED(5, () -> () -> CommonItemStats.RANGED_SPEED);

    public final int iconIndex;
    public final float defaultValue;
    public final boolean displayIfDefault;
    public final Supplier<Supplier<net.silentchaos512.gear.api.stats.ItemStat>> silentGearStat;

    private ItemStat(int iconIndex, Supplier<Supplier<net.silentchaos512.gear.api.stats.ItemStat>> silentGearStat) {
        this(iconIndex, 0.0f, true, silentGearStat);
    }

    private ItemStat(int iconIndex, float defaultValue, boolean displayIfDefault, Supplier<Supplier<net.silentchaos512.gear.api.stats.ItemStat>> silentGearStat) {
        this.iconIndex = iconIndex;
        this.defaultValue = defaultValue;
        this.displayIfDefault = displayIfDefault;
        this.silentGearStat = silentGearStat;
    }

    public boolean shouldRender(EquipmentStats stats) {
        if (this.displayIfDefault) {
            return true;
        }
        float value = stats.getStat(this);
        return value > this.defaultValue;
    }
}

