/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.equiptooltips;

import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.item.ICoreRangedWeapon;
import net.silentchaos512.gear.api.parts.MaterialGrade;
import net.silentchaos512.gear.api.parts.PartType;
import net.silentchaos512.gear.api.stats.CommonItemStats;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.parts.PartData;
import net.silentchaos512.gear.util.GearData;

final class SGearCompat {
    private SGearCompat() {
        throw new IllegalAccessError("Utility class");
    }

    static String getGradeString(ItemStack stack) {
        MaterialGrade grade = MaterialGrade.fromStack((ItemStack)stack);
        return grade.name();
    }

    static int getPartTier(ItemStack stack) {
        PartData part = PartData.fromStackFast((ItemStack)stack);
        return part != null ? part.getPart().getTier() : -1;
    }

    static boolean isMainPart(ItemStack stack) {
        PartData part = PartData.fromStackFast((ItemStack)stack);
        return part != null && part.getType() == PartType.MAIN;
    }

    static boolean isGearItem(ItemStack stack) {
        return stack.func_77973_b() instanceof ICoreItem;
    }

    static boolean isGearRangedWeapon(ItemStack stack) {
        return stack.func_77973_b() instanceof ICoreRangedWeapon;
    }

    static float getMagicDamageStat(ItemStack stack) {
        return GearData.getStat((ItemStack)stack, (ItemStat)CommonItemStats.MAGIC_DAMAGE);
    }

    static float getRangedDamage(ItemStack stack) {
        return GearData.getStat((ItemStack)stack, (ItemStat)CommonItemStats.RANGED_DAMAGE);
    }

    public static float getRangedSpeed(ItemStack stack) {
        return GearData.getStat((ItemStack)stack, (ItemStat)CommonItemStats.RANGED_SPEED);
    }

    public static float getStat(ItemStack stack, Supplier<Supplier<ItemStat>> stat) {
        PartData part;
        if (SGearCompat.isMainPart(stack) && (part = PartData.from((ItemStack)stack)) != null) {
            return part.computeStat(stat.get().get());
        }
        return GearData.getStat((ItemStack)stack, (ItemStat)stat.get().get());
    }
}

