/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.equiptooltips;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.silentchaos512.equiptooltips.Config;
import net.silentchaos512.equiptooltips.EquipmentStats;
import net.silentchaos512.equiptooltips.ItemStat;
import net.silentchaos512.equiptooltips.ItemType;

public class TooltipHandler
extends Gui {
    public static final ResourceLocation TEXTURE = new ResourceLocation("equipmenttooltips", "textures/gui/hud.png");
    public static final TooltipHandler INSTANCE = new TooltipHandler();
    private int lastWidth = 0;
    public final boolean isTinkersLoaded;
    private static final String FORMAT_INT = "%d";
    private static final String FORMAT_FLOAT = "%.2f";

    public TooltipHandler() {
        this.isTinkersLoaded = false;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRenderTooltip(RenderTooltipEvent.PostText event) {
        ItemStack stack = event.getStack();
        if (stack.func_190926_b()) {
            return;
        }
        EquipmentStats hoveredStats = new EquipmentStats(stack);
        if (hoveredStats.getItemType() == ItemType.UNKNOWN) {
            return;
        }
        this.renderBackground(event);
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fontRenderer = event.getFontRenderer();
        ItemStack currentEquip = ItemStack.field_190927_a;
        if (hoveredStats.getItemType() == ItemType.ARMOR) {
            EntityEquipmentSlot slot = ((ItemArmor)stack.func_77973_b()).func_185083_B_();
            for (ItemStack itemstack : mc.field_71439_g.func_184193_aE()) {
                Item item = itemstack.func_77973_b();
                if (itemstack.func_190926_b() || !(item instanceof ItemArmor) || ((ItemArmor)item).func_185083_B_() != slot) continue;
                currentEquip = itemstack;
            }
        } else if (hoveredStats.getItemType() != ItemType.SGEAR_PART) {
            currentEquip = mc.field_71439_g.func_184614_ca();
        }
        EquipmentStats equippedStats = currentEquip.func_190926_b() ? null : new EquipmentStats(currentEquip);
        double scale = 0.75;
        int x = (int)((double)(event.getX() + Config.POSITION_X_OFFSET) / scale);
        int y = (int)((double)(event.getY() - 16 + Config.POSITION_Y_OFFSET) / scale);
        if (Config.POSITION_ON_BOTTOM) {
            y = (int)((double)y + ((double)event.getHeight() / scale + 28.0));
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
        mc.field_71446_o.func_110577_a(TEXTURE);
        for (ItemStat stat : hoveredStats.getItemType().displayStats) {
            if (!stat.shouldRender(hoveredStats)) continue;
            x = this.renderStat(mc, fontRenderer, x, y, stat, hoveredStats, equippedStats);
        }
        this.lastWidth = (int)((double)x * scale - (double)event.getX());
        GlStateManager.func_179121_F();
    }

    private int renderStat(Minecraft mc, FontRenderer fontRenderer, int x, int y, ItemStat stat, EquipmentStats hovered, @Nullable EquipmentStats equipped) {
        if (!stat.shouldRender(hovered)) {
            return x;
        }
        mc.field_71446_o.func_110577_a(TEXTURE);
        this.func_73729_b(x, y, 16 * stat.iconIndex, 240, 16, 16);
        float hoveredStat = hovered.getStat(stat);
        float equippedStat = equipped == null ? stat.defaultValue : equipped.getStat(stat);
        String text = TooltipHandler.formatStat(hoveredStat);
        fontRenderer.func_175063_a(text, (float)(x += 18), (float)(y + 5), 0xFFFFFF);
        x += fontRenderer.func_78256_a(text);
        mc.field_71446_o.func_110577_a(TEXTURE);
        if (equipped == null || hovered.getItemType() != equipped.getItemType()) {
            x += 5;
        } else if (hoveredStat > equippedStat) {
            this.func_73729_b(x, y, 224, 240, 16, 16);
            x += 18;
        } else if (hoveredStat < equippedStat) {
            this.func_73729_b(x, y, 240, 240, 16, 16);
            x += 18;
        } else {
            this.func_73729_b(x, y, 208, 240, 16, 16);
            x += 18;
        }
        return x;
    }

    private static String formatStat(float value) {
        if (value == (float)((int)value)) {
            return String.format(FORMAT_INT, (int)value);
        }
        return String.format(FORMAT_FLOAT, Float.valueOf(value));
    }

    private void renderBackground(RenderTooltipEvent.PostText event) {
        int left = event.getX() - 1 + Config.POSITION_X_OFFSET;
        int top = event.getY() - 17 + Config.POSITION_Y_OFFSET;
        int right = Math.max(event.getX() + this.lastWidth, event.getX() + event.getWidth() + 1) + Config.POSITION_X_OFFSET;
        int bottom = event.getY() - 4 + Config.POSITION_Y_OFFSET;
        if (Config.POSITION_ON_BOTTOM) {
            top += event.getHeight() + 21;
            bottom += event.getHeight() + 21;
        }
        TooltipHandler.func_73734_a((int)left, (int)top, (int)right, (int)bottom, (int)Config.BACKGROUND_COLOR);
    }
}

