/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.equiptooltips;

import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.AxeItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraftforge.common.ToolType;
import net.silentchaos512.equiptooltips.ItemStat;
import net.silentchaos512.equiptooltips.ItemType;
import net.silentchaos512.equiptooltips.SGearProxy;

public class EquipmentStats {
    private final ItemStack stack;
    private ItemType itemType = ItemType.UNKNOWN;
    private final float armorProtection;
    private final float armorToughness;
    private final int durability;
    private final int enchantability;
    private final int harvestLevel;
    private final float harvestSpeed;
    private final float magicDamage;
    private final float meleeDamage;
    private final float meleeSpeed;
    private final float rangedDamage;
    private final float rangedSpeed;
    private static final UUID ATTACK_DAMAGE_MODIFIER = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    private static final UUID ATTACK_SPEED_MODIFIER = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};

    public EquipmentStats(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            throw new IllegalArgumentException("stack may not be invalid");
        }
        this.stack = stack;
        Item item = stack.func_77973_b();
        this.determineItemType(item);
        this.armorProtection = EquipmentStats.getProtection(stack);
        this.armorToughness = EquipmentStats.getToughness(stack);
        this.durability = this.getDurability(stack);
        this.enchantability = item.getItemEnchantability(stack);
        this.harvestLevel = EquipmentStats.getHarvestLevel(stack);
        this.harvestSpeed = EquipmentStats.getHarvestSpeed(stack);
        this.magicDamage = EquipmentStats.getMagicDamage(stack);
        this.meleeDamage = EquipmentStats.getMeleeDamage(stack);
        this.meleeSpeed = EquipmentStats.getMeleeSpeed(stack);
        this.rangedDamage = EquipmentStats.getRangedDamage(stack);
        this.rangedSpeed = EquipmentStats.getRangedSpeed(stack);
    }

    private int getDurability(@Nonnull ItemStack stack) {
        if (SGearProxy.isMainPart(stack)) {
            return (int)SGearProxy.getStat(stack, ItemStat.DURABILITY.silentGearStat);
        }
        return stack.func_77984_f() ? stack.func_77958_k() : 0;
    }

    private static int getHarvestLevel(ItemStack stack) {
        if (SGearProxy.isMainPart(stack)) {
            return (int)SGearProxy.getStat(stack, ItemStat.HARVEST_LEVEL.silentGearStat);
        }
        Item item = stack.func_77973_b();
        if (!(item instanceof ToolItem)) {
            return -1;
        }
        int maxLevel = -1;
        for (ToolType toolClass : item.getToolTypes(stack)) {
            int harvestLevel = item.getHarvestLevel(stack, toolClass, null, null);
            maxLevel = Math.max(maxLevel, harvestLevel);
        }
        return maxLevel;
    }

    private static float getHarvestSpeed(ItemStack stack) {
        if (SGearProxy.isMainPart(stack)) {
            return SGearProxy.getStat(stack, ItemStat.HARVEST_SPEED.silentGearStat);
        }
        Item item = stack.func_77973_b();
        BlockState state = EquipmentStats.getBlockForTool(stack);
        try {
            return item.func_150893_a(stack, state);
        }
        catch (NullPointerException ex) {
            return 0.0f;
        }
    }

    private static BlockState getBlockForTool(ItemStack stack) {
        Item item = stack.func_77973_b();
        Set toolClasses = item.getToolTypes(stack);
        BlockState state = item instanceof ShovelItem || toolClasses.contains(ToolType.SHOVEL) ? Blocks.field_150346_d.func_176223_P() : (item instanceof AxeItem || toolClasses.contains(ToolType.AXE) ? Blocks.field_196617_K.func_176223_P() : (item instanceof ShearsItem ? Blocks.field_196556_aL.func_176223_P() : Blocks.field_150348_b.func_176223_P()));
        return state;
    }

    private static float getMeleeDamage(ItemStack stack) {
        if (SGearProxy.isMainPart(stack)) {
            return SGearProxy.getStat(stack, ItemStat.MELEE_DAMAGE.silentGearStat);
        }
        Multimap multimap = stack.func_111283_C(EquipmentSlotType.MAINHAND);
        for (Map.Entry entry : multimap.entries()) {
            AttributeModifier mod = (AttributeModifier)entry.getValue();
            if (mod == null || !ATTACK_DAMAGE_MODIFIER.equals(mod.func_111167_a())) continue;
            return (float)mod.func_111164_d() + 1.0f;
        }
        return 0.0f;
    }

    private static float getMagicDamage(ItemStack stack) {
        if (SGearProxy.isMainPart(stack)) {
            return SGearProxy.getStat(stack, ItemStat.MAGIC_DAMAGE.silentGearStat);
        }
        return 0.0f;
    }

    private static float getMeleeSpeed(ItemStack stack) {
        if (SGearProxy.isMainPart(stack)) {
            return SGearProxy.getStat(stack, ItemStat.MELEE_SPEED.silentGearStat);
        }
        Multimap multimap = stack.func_111283_C(EquipmentSlotType.MAINHAND);
        for (Map.Entry entry : multimap.entries()) {
            AttributeModifier mod = (AttributeModifier)entry.getValue();
            if (mod == null || !mod.func_111167_a().equals(ATTACK_SPEED_MODIFIER)) continue;
            return (float)mod.func_111164_d() + 4.0f;
        }
        return 0.0f;
    }

    private static float getProtection(ItemStack stack) {
        if (SGearProxy.isMainPart(stack)) {
            return SGearProxy.getStat(stack, ItemStat.ARMOR_PROTECTION.silentGearStat);
        }
        if (!(stack.func_77973_b() instanceof ArmorItem)) {
            return 0.0f;
        }
        ArmorItem armorItem = (ArmorItem)stack.func_77973_b();
        EquipmentSlotType slot = armorItem.func_185083_B_();
        UUID uuid = ARMOR_MODIFIERS[slot.func_188454_b()];
        Multimap multimap = stack.func_111283_C(slot);
        for (Map.Entry entry : multimap.entries()) {
            String key = (String)entry.getKey();
            AttributeModifier mod = (AttributeModifier)entry.getValue();
            if (mod == null || !key.equals(SharedMonsterAttributes.field_188791_g.func_111108_a()) || !mod.func_111167_a().equals(uuid)) continue;
            return (float)mod.func_111164_d();
        }
        return 0.0f;
    }

    private static float getToughness(ItemStack stack) {
        if (SGearProxy.isMainPart(stack)) {
            return SGearProxy.getStat(stack, ItemStat.ARMOR_TOUGHNESS.silentGearStat);
        }
        if (!(stack.func_77973_b() instanceof ArmorItem)) {
            return 0.0f;
        }
        ArmorItem armorItem = (ArmorItem)stack.func_77973_b();
        EquipmentSlotType slot = armorItem.func_185083_B_();
        UUID uuid = ARMOR_MODIFIERS[slot.func_188454_b()];
        Multimap multimap = stack.func_111283_C(slot);
        for (Map.Entry entry : multimap.entries()) {
            String key = (String)entry.getKey();
            AttributeModifier mod = (AttributeModifier)entry.getValue();
            if (mod == null || !key.equals(SharedMonsterAttributes.field_189429_h.func_111108_a()) || !mod.func_111167_a().equals(uuid)) continue;
            return (float)mod.func_111164_d();
        }
        return 0.0f;
    }

    private static float getRangedDamage(ItemStack stack) {
        if (SGearProxy.isMainPart(stack)) {
            return SGearProxy.getStat(stack, ItemStat.RANGED_DAMAGE.silentGearStat);
        }
        if (SGearProxy.isGearRangedWeapon(stack)) {
            return SGearProxy.getRangedDamage(stack);
        }
        if (stack.func_77973_b() instanceof BowItem) {
            return 2.0f;
        }
        return 0.0f;
    }

    private static float getRangedSpeed(ItemStack stack) {
        if (SGearProxy.isMainPart(stack)) {
            return SGearProxy.getStat(stack, ItemStat.RANGED_SPEED.silentGearStat);
        }
        if (SGearProxy.isGearRangedWeapon(stack)) {
            return SGearProxy.getRangedSpeed(stack);
        }
        if (stack.func_77973_b() instanceof BowItem) {
            return 1.0f;
        }
        return 0.0f;
    }

    private void determineItemType(Item item) {
        boolean isTinkersHarvestTool = false;
        boolean isTinkersWeapon = false;
        boolean isTinkersBow = false;
        Set toolTypes = item.getToolTypes(this.stack);
        this.itemType = SGearProxy.isMainPart(this.stack) ? ItemType.SGEAR_PART : (item instanceof PickaxeItem || toolTypes.contains(ToolType.PICKAXE) || isTinkersHarvestTool ? ItemType.PICKAXE : (item instanceof ShovelItem || toolTypes.contains(ToolType.SHOVEL) ? ItemType.SHOVEL : (item instanceof AxeItem || toolTypes.contains(ToolType.AXE) ? ItemType.AXE : (item instanceof SwordItem || isTinkersWeapon ? ItemType.SWORD : (item instanceof BowItem || isTinkersBow ? ItemType.BOW : (item instanceof ArmorItem ? ItemType.ARMOR : (item instanceof HoeItem ? ItemType.HOE : (item instanceof FishingRodItem ? ItemType.FISHING_ROD : (item instanceof ShearsItem ? ItemType.SHEARS : (item instanceof ToolItem ? ItemType.GENERIC_HARVEST : (this.stack.func_77984_f() ? ItemType.GENERIC_DAMAGEABLE : ItemType.UNKNOWN)))))))))));
    }

    public float getStat(ItemStat stat) {
        switch (stat) {
            case ARMOR_PROTECTION: {
                return this.armorProtection;
            }
            case ARMOR_TOUGHNESS: {
                return this.armorToughness;
            }
            case DURABILITY: {
                return this.durability;
            }
            case ENCHANTABILITY: {
                return this.enchantability;
            }
            case HARVEST_LEVEL: {
                return this.harvestLevel;
            }
            case HARVEST_SPEED: {
                return this.harvestSpeed;
            }
            case MAGIC_DAMAGE: {
                return this.magicDamage;
            }
            case MELEE_DAMAGE: {
                return this.meleeDamage;
            }
            case MELEE_SPEED: {
                return this.meleeSpeed;
            }
            case RANGED_DAMAGE: {
                return this.rangedDamage;
            }
            case RANGED_SPEED: {
                return this.rangedSpeed;
            }
        }
        throw new IllegalArgumentException("Unknown stat: " + stat.name());
    }

    public ItemType getItemType() {
        return this.itemType;
    }

    public float getArmorProtection() {
        return this.armorProtection;
    }

    public float getArmorToughness() {
        return this.armorToughness;
    }

    public int getDurability() {
        return this.durability;
    }

    public int getEnchantability() {
        return this.enchantability;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }

    public float getHarvestSpeed() {
        return this.harvestSpeed;
    }

    public float getMagicDamage() {
        return this.magicDamage;
    }

    public float getMeleeDamage() {
        return this.meleeDamage;
    }

    public float getMeleeSpeed() {
        return this.meleeSpeed;
    }

    public float getRangedDamage() {
        return this.rangedDamage;
    }

    public float getRangedSpeed() {
        return this.rangedSpeed;
    }
}

