/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials;

import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public final class EssentialsConfig {
    public static Configuration config;
    public static Property addWrench;
    public static Property wrenchTypes;
    public static Property saddleRecipe;
    public static Property nametagRecipe;
    public static Property obsidianKit;
    public static Property pistonRecipe;
    public static Property brazierRange;
    public static Property itemChuteRotary;
    public static Property fertileSoilRate;
    private static final ArrayList<Property> SYNCED_PROPERTIES;
    public static NBTTagCompound syncPropNBT;
    private static final String CAT_INTERNAL = "Internal";
    private static final String CAT_RECIPES = "Recipes";

    protected static void init(FMLPreInitializationEvent e) {
        config = new Configuration(e.getSuggestedConfigurationFile());
        config.load();
        saddleRecipe = config.get(CAT_RECIPES, "Add a recipe for saddles (Default true)?", true);
        nametagRecipe = config.get(CAT_RECIPES, "Add a recipe for nametags (Default true)?", true);
        pistonRecipe = config.get(CAT_RECIPES, "Add a recipe for pistons (Default true)?", true);
        obsidianKit = config.get(CAT_RECIPES, "Add a recipe for obsidian cutting kits (Default true)?", true);
        addWrench = config.get(CAT_INTERNAL, "Show the wrench in the creative menu? (Default true)", true);
        SYNCED_PROPERTIES.add(addWrench);
        wrenchTypes = config.get(CAT_INTERNAL, "Item ids for wrench items. Should be in format 'modid:itemregistryname', ex. minecraft:apple or crossroads:wrench.", new String[]{"essentials:wrench", "crossroads:liech_wrench", "actuallyadditions:itemlaserwrench", "appliedenergistics2:certus_quartz_wrench", "appliedenergistics2:nether_quartz_wrench", "base:wrench", "enderio:itemyetawrench", "extrautils2:wrench", "bigreactors:wrench", "forestry:wrench", "progressiveautomation:wrench", "thermalfoundation:wrench", "redstonearsenal:tool.wrench_flux", "rftools:smartwrench", "immersiveengineering:tool"});
        SYNCED_PROPERTIES.add(wrenchTypes);
        brazierRange = config.get(CAT_INTERNAL, "Range of the brazier witch-blocking effect. Set to 0 to disable. (Default 64)", 64, null, 0, 512);
        SYNCED_PROPERTIES.add(brazierRange);
        itemChuteRotary = config.get(CAT_INTERNAL, "Should the Item Chute require Crossroads rotary power when Crossroads is installed? (Default false)", false);
        SYNCED_PROPERTIES.add(itemChuteRotary);
        fertileSoilRate = config.get(CAT_INTERNAL, "% chance of Fertile Soil creating a plant per growth tick. (Default 100)", 100.0, "0 to 100", 0.0, 100.0);
    }

    public static boolean getConfigBool(Property prop, boolean client) {
        if (prop.getType() != Property.Type.BOOLEAN || prop.isList()) {
            throw new ClassCastException("essentials: Incorrect config property type.");
        }
        if (!client || syncPropNBT == null) {
            return prop.getBoolean();
        }
        int index = SYNCED_PROPERTIES.indexOf(prop);
        if (index == -1) {
            return prop.getBoolean();
        }
        return syncPropNBT.func_74767_n("p_" + index);
    }

    public static double getConfigDouble(Property prop, boolean client) {
        if (prop.getType() != Property.Type.DOUBLE || prop.isList()) {
            throw new ClassCastException("essentials: Incorrect config property type.");
        }
        if (!client || syncPropNBT == null) {
            return prop.getDouble();
        }
        int index = SYNCED_PROPERTIES.indexOf(prop);
        if (index == -1) {
            return prop.getDouble();
        }
        return syncPropNBT.func_74769_h("p_" + index);
    }

    public static int getConfigInt(Property prop, boolean client) {
        if (prop.getType() != Property.Type.INTEGER || prop.isList()) {
            throw new ClassCastException("essentials: Incorrect config property type.");
        }
        if (!client || syncPropNBT == null) {
            return prop.getInt();
        }
        int index = SYNCED_PROPERTIES.indexOf(prop);
        if (index == -1) {
            return prop.getInt();
        }
        return syncPropNBT.func_74762_e("p_" + index);
    }

    public static String getConfigString(Property prop, boolean client) {
        if (prop.getType() != Property.Type.STRING || prop.isList()) {
            throw new ClassCastException("essentials: Incorrect config property type.");
        }
        if (!client || syncPropNBT == null) {
            return prop.getString();
        }
        int index = SYNCED_PROPERTIES.indexOf(prop);
        if (index == -1) {
            return prop.getString();
        }
        return syncPropNBT.func_74779_i("p_" + index);
    }

    public static String[] getConfigStringList(Property prop, boolean client) {
        if (prop.getType() != Property.Type.STRING || !prop.isList()) {
            throw new ClassCastException("essentials: Incorrect config property type.");
        }
        if (!client || syncPropNBT == null) {
            return prop.getStringList();
        }
        int index = SYNCED_PROPERTIES.indexOf(prop);
        if (index == -1) {
            return prop.getStringList();
        }
        String[] out = new String[syncPropNBT.func_74762_e("p_" + index)];
        for (int i = 0; i < out.length; ++i) {
            out[i] = syncPropNBT.func_74779_i("p_" + index + "_" + i);
        }
        return out;
    }

    public static NBTTagCompound nbtToSyncConfig() {
        NBTTagCompound out = new NBTTagCompound();
        int i = 0;
        for (Property prop : SYNCED_PROPERTIES) {
            switch (prop.getType()) {
                case BOOLEAN: {
                    if (prop.isList()) break;
                    out.func_74757_a("p_" + i, prop.getBoolean());
                    break;
                }
                case COLOR: {
                    break;
                }
                case DOUBLE: {
                    if (prop.isList()) break;
                    out.func_74780_a("p_" + i, prop.getDouble());
                    break;
                }
                case INTEGER: {
                    if (prop.isList()) break;
                    out.func_74768_a("p_" + i, prop.getInt());
                    break;
                }
                case MOD_ID: {
                    break;
                }
                case STRING: {
                    if (!prop.isList()) {
                        out.func_74757_a("p_" + i, prop.getBoolean());
                        break;
                    }
                    out.func_74768_a("p_" + i, prop.getStringList().length);
                    for (int ind = 0; ind < prop.getStringList().length; ++ind) {
                        out.func_74778_a("p_" + i + "_" + ind, prop.getStringList()[ind]);
                    }
                    break;
                }
            }
            ++i;
        }
        return out;
    }

    public static boolean isWrench(ItemStack stack, boolean client) {
        if (stack.func_190926_b()) {
            return false;
        }
        ResourceLocation loc = stack.func_77973_b().getRegistryName();
        if (loc == null) {
            return false;
        }
        String name = loc.toString();
        for (String s : EssentialsConfig.getConfigStringList(wrenchTypes, client)) {
            if (!name.equals(s)) continue;
            return true;
        }
        return false;
    }

    static {
        SYNCED_PROPERTIES = new ArrayList();
    }
}

