/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.crossroads.API.rotary.IAxisHandler;
import com.Da_Technomancer.crossroads.API.rotary.IAxleHandler;
import com.Da_Technomancer.essentials.Essentials;
import com.Da_Technomancer.essentials.EssentialsConfig;
import com.Da_Technomancer.essentials.blocks.EssentialsBlocks;
import com.Da_Technomancer.essentials.blocks.EssentialsProperties;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemChutePortTileEntity
extends TileEntity
implements ITickable {
    private ItemStack inventory = ItemStack.field_190927_a;
    private final double[] motionData = new double[4];
    @CapabilityInject(value=IAxleHandler.class)
    private static Capability<?> AXLE_HANDLER_CAPABILITY = null;
    private Object axleHandler = null;
    private final IItemHandler handler = new InventoryHandler();

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.isSpotInvalid() && !this.inventory.func_190926_b()) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177972_a((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)EssentialsProperties.FACING)).func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177972_a((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)EssentialsProperties.FACING)).func_177952_p(), this.inventory.func_77946_l()));
            this.inventory = ItemStack.field_190927_a;
            this.func_70296_d();
        } else if (!(this.inventory.func_190926_b() || Essentials.hasCrossroads && EssentialsConfig.getConfigBool(EssentialsConfig.itemChuteRotary, false) && !(Math.abs(this.motionData[1]) >= 0.5) || !this.output())) {
            if (Essentials.hasCrossroads && EssentialsConfig.getConfigBool(EssentialsConfig.itemChuteRotary, true)) {
                this.motionData[1] = this.motionData[1] - 0.5 * Math.signum(this.motionData[1]);
                this.func_70296_d();
            }
            this.inventory = ItemStack.field_190927_a;
            this.func_70296_d();
        }
    }

    public void dropItems() {
        this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), this.inventory.func_77946_l()));
        this.inventory = ItemStack.field_190927_a;
        this.func_70296_d();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (!this.inventory.func_190926_b()) {
            nbt.func_74782_a("inv", (NBTBase)this.inventory.func_77955_b(new NBTTagCompound()));
        }
        for (int i = 0; i < 4; ++i) {
            nbt.func_74780_a("motion" + i, this.motionData[i]);
        }
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("inv")) {
            this.inventory = new ItemStack(nbt.func_74775_l("inv"));
        }
        for (int i = 0; i < 4; ++i) {
            this.motionData[i] = nbt.func_74769_h("motion" + i);
        }
    }

    private boolean isSpotInvalid() {
        Block block = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(EnumFacing.DOWN)).func_177230_c();
        Block blockUp = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(EnumFacing.UP)).func_177230_c();
        return block == EssentialsBlocks.itemChutePort || block == EssentialsBlocks.itemChute || blockUp != EssentialsBlocks.itemChutePort && blockUp != EssentialsBlocks.itemChute;
    }

    private boolean output() {
        BlockPos outputPos = null;
        EnumFacing outDir = null;
        for (int height = 1; height < 255 - this.field_174879_c.func_177956_o(); ++height) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177967_a(EnumFacing.UP, height));
            if (state.func_177230_c() == EssentialsBlocks.itemChutePort) {
                outputPos = this.field_174879_c.func_177967_a(EnumFacing.UP, height);
                outDir = (EnumFacing)state.func_177229_b((IProperty)EssentialsProperties.FACING);
                break;
            }
            if (state.func_177230_c() == EssentialsBlocks.itemChute) continue;
            return false;
        }
        if (outputPos == null) {
            return false;
        }
        TileEntity offsetTE = this.field_145850_b.func_175625_s(outputPos.func_177972_a(outDir));
        if (offsetTE != null && offsetTE.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, outDir.func_176734_d())) {
            IItemHandler outHandler = (IItemHandler)offsetTE.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, outDir.func_176734_d());
            for (int i = 0; i < outHandler.getSlots(); ++i) {
                ItemStack outStack = outHandler.insertItem(i, this.inventory, false);
                if (!outStack.func_190926_b()) continue;
                return true;
            }
            return false;
        }
        EntityItem ent = new EntityItem(this.field_145850_b, (double)outputPos.func_177972_a(outDir).func_177958_n() + 0.5, (double)outputPos.func_177972_a(outDir).func_177956_o(), (double)outputPos.func_177972_a(outDir).func_177952_p() + 0.5, this.inventory);
        ent.field_70159_w = 0.0;
        ent.field_70179_y = 0.0;
        this.field_145850_b.func_72838_d((Entity)ent);
        return true;
    }

    public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() != EssentialsBlocks.itemChutePort) {
            return false;
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (facing == null || facing == state.func_177229_b((IProperty)EssentialsProperties.FACING))) {
            return true;
        }
        if (cap == AXLE_HANDLER_CAPABILITY && Essentials.hasCrossroads && EssentialsConfig.getConfigBool(EssentialsConfig.itemChuteRotary, true) && facing == ((EnumFacing)state.func_177229_b((IProperty)EssentialsProperties.FACING)).func_176732_a(EnumFacing.Axis.Y)) {
            return true;
        }
        return super.hasCapability(cap, facing);
    }

    public <T> T getCapability(Capability<T> cap, EnumFacing facing) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() != EssentialsBlocks.itemChutePort) {
            return (T)super.getCapability(cap, facing);
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (facing == null || facing == state.func_177229_b((IProperty)EssentialsProperties.FACING))) {
            return (T)this.handler;
        }
        if (cap == AXLE_HANDLER_CAPABILITY && Essentials.hasCrossroads && EssentialsConfig.getConfigBool(EssentialsConfig.itemChuteRotary, true) && facing == ((EnumFacing)state.func_177229_b((IProperty)EssentialsProperties.FACING)).func_176732_a(EnumFacing.Axis.Y)) {
            if (this.axleHandler == null) {
                this.axleHandler = new AxleHandler();
            }
            return (T)this.axleHandler;
        }
        return (T)super.getCapability(cap, facing);
    }

    private class InventoryHandler
    implements IItemHandler {
        private InventoryHandler() {
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return slot == 0 ? ItemChutePortTileEntity.this.inventory : ItemStack.field_190927_a;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot != 0 || stack.func_190926_b() || !ItemChutePortTileEntity.this.inventory.func_190926_b()) {
                return stack;
            }
            if (!simulate) {
                ItemChutePortTileEntity.this.inventory = stack.func_77946_l();
                ItemChutePortTileEntity.this.inventory.func_190920_e(1);
                ItemChutePortTileEntity.this.func_70296_d();
            }
            ItemStack holder = stack.func_77946_l();
            holder.func_190918_g(1);
            return holder;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return slot == 0 ? 1 : 0;
        }
    }

    private class AxleHandler
    implements IAxleHandler {
        private double rotRatio;
        private byte updateKey;

        private AxleHandler() {
        }

        public double[] getMotionData() {
            return ItemChutePortTileEntity.this.motionData;
        }

        public void propogate(IAxisHandler masterIn, byte key, double rotRatioIn, double lastRadius) {
            if (key == this.updateKey || masterIn.addToList((IAxleHandler)this)) {
                return;
            }
            this.rotRatio = rotRatioIn == 0.0 ? 1.0 : rotRatioIn;
            this.updateKey = key;
        }

        public double getMoInertia() {
            return 8.0;
        }

        public double getRotationRatio() {
            return this.rotRatio;
        }

        public void addEnergy(double energy, boolean allowInvert, boolean absolute) {
            if (allowInvert && absolute) {
                double[] dArray = ItemChutePortTileEntity.this.motionData;
                dArray[1] = dArray[1] + energy;
            } else if (allowInvert) {
                double[] dArray = ItemChutePortTileEntity.this.motionData;
                dArray[1] = dArray[1] + energy * Math.signum(ItemChutePortTileEntity.this.motionData[1]);
            } else if (absolute) {
                int sign = (int)Math.signum(ItemChutePortTileEntity.this.motionData[1]);
                double[] dArray = ItemChutePortTileEntity.this.motionData;
                dArray[1] = dArray[1] + energy;
                if (sign != 0 && Math.signum(ItemChutePortTileEntity.this.motionData[1]) != (double)sign) {
                    ((ItemChutePortTileEntity)ItemChutePortTileEntity.this).motionData[1] = 0.0;
                }
            } else {
                int sign = (int)Math.signum(ItemChutePortTileEntity.this.motionData[1]);
                double[] dArray = ItemChutePortTileEntity.this.motionData;
                dArray[1] = dArray[1] + energy * (double)sign;
                if (Math.signum(ItemChutePortTileEntity.this.motionData[1]) != (double)sign) {
                    ((ItemChutePortTileEntity)ItemChutePortTileEntity.this).motionData[1] = 0.0;
                }
            }
            ItemChutePortTileEntity.this.func_70296_d();
        }

        public void markChanged() {
            ItemChutePortTileEntity.this.func_70296_d();
        }

        public boolean shouldManageAngle() {
            return false;
        }
    }
}

