/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerHopper;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;

public class SortingHopperTileEntity
extends TileEntityLockable
implements ITickable {
    private ItemStack[] inventory = new ItemStack[5];
    private int transferCooldown = -1;

    public SortingHopperTileEntity() {
        this.func_174888_l();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public String func_70005_c_() {
        return "container.sorting_hopper";
    }

    protected IItemHandler createUnSidedHandler() {
        return new HopperItemHandler();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.transferCooldown = nbt.func_74762_e("transferCooldown");
        for (int i = 0; i < 5; ++i) {
            NBTTagCompound stackNBT = nbt.func_74775_l("inv" + i);
            this.inventory[i] = new ItemStack(stackNBT);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        for (int i = 0; i < 5; ++i) {
            if (this.inventory[i].func_190926_b()) continue;
            NBTTagCompound stackNBT = new NBTTagCompound();
            this.inventory[i].func_77955_b(stackNBT);
            nbt.func_74782_a("inv" + i, (NBTBase)stackNBT);
        }
        nbt.func_74768_a("transferCooldown", this.transferCooldown);
        return nbt;
    }

    public int func_70302_i_() {
        return 5;
    }

    public ItemStack func_70301_a(int index) {
        return index > 4 ? ItemStack.field_190927_a : this.inventory[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        if (index > 4 || this.inventory[index].func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        return this.inventory[index].func_77979_a(count);
    }

    public ItemStack func_70304_b(int index) {
        if (index > 4) {
            return ItemStack.field_190927_a;
        }
        ItemStack copy = this.inventory[4].func_77946_l();
        this.inventory[4] = ItemStack.field_190927_a;
        return copy;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index > 4) {
            return;
        }
        this.inventory[index] = stack;
        if (!stack.func_190926_b() && stack.func_190916_E() > stack.func_77976_d()) {
            stack.func_190920_e(stack.func_77976_d());
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index < 5;
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && --this.transferCooldown <= 0) {
            this.transferCooldown = 0;
            if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && BlockHopper.func_149917_c((int)this.func_145832_p())) {
                boolean flag = false;
                if (!this.isFull()) {
                    flag = this.transferItemsIn();
                }
                if (!this.func_191420_l()) {
                    boolean bl = flag = this.transferItemsOut() || flag;
                }
                if (flag) {
                    this.transferCooldown = 8;
                    this.func_70296_d();
                }
            }
        }
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    private boolean isFull() {
        for (ItemStack itemstack : this.inventory) {
            if (!itemstack.func_190926_b() && itemstack.func_190916_E() == itemstack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    private boolean transferItemsOut() {
        EnumFacing facing = EnumFacing.func_82600_a((int)(this.func_145832_p() & 7));
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
        if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) {
            IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                ItemStack stackInSlot = this.func_70301_a(i);
                if (stackInSlot.func_190926_b()) continue;
                ItemStack insert = stackInSlot.func_77946_l();
                insert.func_190920_e(1);
                ItemStack newStack = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)insert, (boolean)true);
                if (!newStack.func_190926_b()) continue;
                ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)this.func_70298_a(i, 1), (boolean)false);
                this.func_70296_d();
                return true;
            }
            return false;
        }
        IInventory iinventory = SortingHopperTileEntity.getInventoryAtPosition(this.field_145850_b, this.field_174879_c.func_177972_a(facing));
        if (iinventory == null) {
            return false;
        }
        EnumFacing enumfacing = facing.func_176734_d();
        if (this.isInventoryFull(iinventory, enumfacing)) {
            return false;
        }
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            ItemStack itemstack = this.func_70301_a(i).func_77946_l();
            ItemStack itemstack1 = SortingHopperTileEntity.putStackInInventoryAllSlots(iinventory, this.func_70298_a(i, 1), enumfacing);
            if (itemstack1.func_190926_b()) {
                iinventory.func_70296_d();
                return true;
            }
            this.func_70299_a(i, itemstack);
        }
        return false;
    }

    private boolean isInventoryFull(IInventory inventoryIn, EnumFacing side) {
        if (inventoryIn instanceof ISidedInventory) {
            ISidedInventory isidedinventory = (ISidedInventory)inventoryIn;
            int[] aint = isidedinventory.func_180463_a(side);
            if (aint == null) {
                return false;
            }
            for (int k : aint) {
                ItemStack itemstack1 = isidedinventory.func_70301_a(k);
                if (!itemstack1.func_190926_b() && itemstack1.func_190916_E() == itemstack1.func_77976_d()) continue;
                return false;
            }
        } else {
            int i = inventoryIn.func_70302_i_();
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inventoryIn.func_70301_a(j);
                if (!itemstack.func_190926_b() && itemstack.func_190916_E() == itemstack.func_77976_d()) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isInventoryEmpty(IInventory inventoryIn, EnumFacing side) {
        if (inventoryIn instanceof ISidedInventory) {
            int[] aint;
            ISidedInventory isidedinventory = (ISidedInventory)inventoryIn;
            for (int i : aint = isidedinventory.func_180463_a(side)) {
                if (isidedinventory.func_70301_a(i).func_190926_b()) continue;
                return false;
            }
        } else {
            int j = inventoryIn.func_70302_i_();
            for (int k = 0; k < j; ++k) {
                if (inventoryIn.func_70301_a(k).func_190926_b()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean transferItemsIn() {
        TileEntity fromTE = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(EnumFacing.UP));
        if (fromTE != null && fromTE.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN)) {
            IItemHandler handler = (IItemHandler)fromTE.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
            IItemHandler thisHandler = (IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack extractItem = handler.extractItem(i, 1, true);
                if (extractItem.func_190926_b()) continue;
                for (int j = 0; j < this.func_70302_i_(); ++j) {
                    if (!thisHandler.insertItem(j, extractItem, true).func_190926_b()) continue;
                    handler.extractItem(i, 1, false);
                    thisHandler.insertItem(j, extractItem, false);
                    return true;
                }
            }
            return false;
        }
        IInventory iinventory = SortingHopperTileEntity.getInventoryAtPosition(this.field_145850_b, this.field_174879_c.func_177972_a(EnumFacing.UP));
        if (iinventory != null) {
            if (SortingHopperTileEntity.isInventoryEmpty(iinventory, EnumFacing.DOWN)) {
                return false;
            }
            if (iinventory instanceof ISidedInventory) {
                int[] aint;
                ISidedInventory isidedinventory = (ISidedInventory)iinventory;
                for (int i : aint = isidedinventory.func_180463_a(EnumFacing.DOWN)) {
                    if (!this.pullItemFromSlot(iinventory, i, EnumFacing.DOWN)) continue;
                    return true;
                }
            } else {
                int j = iinventory.func_70302_i_();
                for (int k = 0; k < j; ++k) {
                    if (!this.pullItemFromSlot(iinventory, k, EnumFacing.DOWN)) continue;
                    return true;
                }
            }
        } else {
            for (EntityItem entityitem : this.field_145850_b.func_175647_a(EntityItem.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)this.field_174879_c.func_177956_o() + 2.0, (double)(this.field_174879_c.func_177952_p() + 1)), EntitySelectors.field_94557_a)) {
                if (!SortingHopperTileEntity.putDropInInventoryAllSlots((IInventory)this, entityitem)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean pullItemFromSlot(IInventory inventoryIn, int index, EnumFacing direction) {
        ItemStack itemstack = inventoryIn.func_70301_a(index);
        if (!itemstack.func_190926_b() && SortingHopperTileEntity.canExtractItemFromSlot(inventoryIn, itemstack, index, direction)) {
            ItemStack itemstack1 = itemstack.func_77946_l();
            ItemStack itemstack2 = SortingHopperTileEntity.putStackInInventoryAllSlots((IInventory)this, inventoryIn.func_70298_a(index, 1), null);
            if (itemstack2.func_190926_b()) {
                inventoryIn.func_70296_d();
                return true;
            }
            inventoryIn.func_70299_a(index, itemstack1);
        }
        return false;
    }

    private static boolean putDropInInventoryAllSlots(IInventory p_145898_0_, EntityItem itemIn) {
        boolean flag = false;
        if (itemIn == null) {
            return false;
        }
        ItemStack itemstack = itemIn.func_92059_d().func_77946_l();
        ItemStack itemstack1 = SortingHopperTileEntity.putStackInInventoryAllSlots(p_145898_0_, itemstack, null);
        if (!itemstack1.func_190926_b()) {
            itemIn.func_92058_a(itemstack1);
        } else {
            flag = true;
            itemIn.func_70106_y();
        }
        return flag;
    }

    private static ItemStack putStackInInventoryAllSlots(IInventory inventoryIn, ItemStack stack, @Nullable EnumFacing side) {
        if (inventoryIn instanceof ISidedInventory && side != null) {
            ISidedInventory isidedinventory = (ISidedInventory)inventoryIn;
            int[] aint = isidedinventory.func_180463_a(side);
            for (int k = 0; k < aint.length && !stack.func_190926_b(); ++k) {
                stack = SortingHopperTileEntity.insertStack(inventoryIn, stack, aint[k], side);
            }
        } else {
            int i = inventoryIn.func_70302_i_();
            for (int j = 0; j < i && !stack.func_190926_b(); ++j) {
                stack = SortingHopperTileEntity.insertStack(inventoryIn, stack, j, side);
            }
        }
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    private static boolean canInsertItemInSlot(IInventory inventoryIn, ItemStack stack, int index, EnumFacing side) {
        return inventoryIn.func_94041_b(index, stack) && (!(inventoryIn instanceof ISidedInventory) || ((ISidedInventory)inventoryIn).func_180462_a(index, stack, side));
    }

    private static boolean canExtractItemFromSlot(IInventory inventoryIn, ItemStack stack, int index, EnumFacing side) {
        return !(inventoryIn instanceof ISidedInventory) || ((ISidedInventory)inventoryIn).func_180461_b(index, stack, side);
    }

    private static ItemStack insertStack(IInventory inventoryIn, ItemStack stack, int index, EnumFacing side) {
        ItemStack itemstack = inventoryIn.func_70301_a(index);
        if (SortingHopperTileEntity.canInsertItemInSlot(inventoryIn, stack, index, side)) {
            int max;
            boolean flag = false;
            if (itemstack.func_190926_b()) {
                max = Math.min(stack.func_77976_d(), inventoryIn.func_70297_j_());
                if (max >= stack.func_190916_E()) {
                    inventoryIn.func_70299_a(index, stack);
                    stack = ItemStack.field_190927_a;
                } else {
                    inventoryIn.func_70299_a(index, stack.func_77979_a(max));
                }
                flag = true;
            } else if (SortingHopperTileEntity.canCombine(itemstack, stack) && (max = Math.min(stack.func_77976_d(), inventoryIn.func_70297_j_())) > itemstack.func_190916_E()) {
                int i = max - itemstack.func_190916_E();
                int j = Math.min(stack.func_190916_E(), i);
                stack.func_190918_g(j);
                itemstack.func_190917_f(j);
                boolean bl = flag = j > 0;
            }
            if (flag) {
                if (inventoryIn instanceof TileEntityHopper) {
                    TileEntityHopper tileentityhopper = (TileEntityHopper)inventoryIn;
                    if (tileentityhopper.func_174914_o()) {
                        tileentityhopper.func_145896_c(8);
                    }
                    inventoryIn.func_70296_d();
                }
                inventoryIn.func_70296_d();
            }
        }
        return stack;
    }

    private static IInventory getInventoryAtPosition(World worldIn, BlockPos targetPos) {
        List list;
        IInventory iinventory = null;
        Block block = worldIn.func_180495_p(targetPos).func_177230_c();
        TileEntity te = worldIn.func_175625_s(targetPos);
        if (te instanceof IInventory && (iinventory = (IInventory)te) instanceof TileEntityChest && block instanceof BlockChest) {
            iinventory = ((BlockChest)block).func_189418_a(worldIn, targetPos, true);
        }
        if (iinventory == null && !(list = worldIn.func_175674_a((Entity)null, new AxisAlignedBB((double)targetPos.func_177958_n(), (double)targetPos.func_177956_o(), (double)targetPos.func_177952_p(), (double)(targetPos.func_177958_n() + 1), (double)(targetPos.func_177956_o() + 1), (double)(targetPos.func_177952_p() + 1)), EntitySelectors.field_96566_b)).isEmpty()) {
            iinventory = (IInventory)list.get(worldIn.field_73012_v.nextInt(list.size()));
        }
        return iinventory;
    }

    private static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77960_j() == stack2.func_77960_j() && stack1.func_190916_E() <= stack1.func_77976_d() && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public String func_174875_k() {
        return "minecraft:hopper";
    }

    public boolean mayTransfer() {
        return this.transferCooldown <= 1;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < 5; ++i) {
            this.inventory[i] = ItemStack.field_190927_a;
        }
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerHopper(playerInventory, (IInventory)this, playerIn);
    }

    private class HopperItemHandler
    extends InvWrapper {
        public HopperItemHandler() {
            super((IInventory)SortingHopperTileEntity.this);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (simulate || !SortingHopperTileEntity.this.mayTransfer()) {
                return super.insertItem(slot, stack, simulate);
            }
            int curStackSize = stack.func_190916_E();
            ItemStack itemStack = super.insertItem(slot, stack, false);
            if (itemStack.func_190926_b() || curStackSize != itemStack.func_190916_E()) {
                SortingHopperTileEntity.this.transferCooldown = 8;
            }
            return itemStack;
        }
    }
}

