/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials;

import com.Da_Technomancer.essentials.EssentialsConfig;
import com.Da_Technomancer.essentials.EssentialsEventHandlerCommon;
import com.Da_Technomancer.essentials.blocks.EssentialsBlocks;
import com.Da_Technomancer.essentials.gui.EssentialsGuiHandler;
import com.Da_Technomancer.essentials.items.EssentialsItems;
import com.Da_Technomancer.essentials.items.crafting.EssentialsCrafting;
import com.Da_Technomancer.essentials.packets.EssentialsPackets;
import com.Da_Technomancer.essentials.render.TESRRegistry;
import com.Da_Technomancer.essentials.tileentities.BasicItemSplitterTileEntity;
import com.Da_Technomancer.essentials.tileentities.BrazierTileEntity;
import com.Da_Technomancer.essentials.tileentities.FluidShifterTileEntity;
import com.Da_Technomancer.essentials.tileentities.HopperFilterTileEntity;
import com.Da_Technomancer.essentials.tileentities.ItemShifterTileEntity;
import com.Da_Technomancer.essentials.tileentities.ItemSplitterTileEntity;
import com.Da_Technomancer.essentials.tileentities.SlottedChestTileEntity;
import com.Da_Technomancer.essentials.tileentities.SortingHopperTileEntity;
import com.Da_Technomancer.essentials.tileentities.SpeedHopperTileEntity;
import com.mojang.datafixers.types.Type;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="essentials")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public final class Essentials {
    public static final String MODID = "essentials";
    public static final String MODNAME = "Essentials";
    public static final Logger logger = LogManager.getLogger((String)"Essentials");

    public Essentials() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonInit);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientInit);
        EssentialsConfig.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
        EssentialsConfig.load();
    }

    private void commonInit(FMLCommonSetupEvent e) {
        EssentialsPackets.preInit();
        MinecraftForge.EVENT_BUS.register((Object)new EssentialsEventHandlerCommon());
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.GUIFACTORY, EssentialsGuiHandler::new);
        EssentialsCrafting.init();
    }

    private void clientInit(FMLClientSetupEvent e) {
        TESRRegistry.init();
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> e) {
        IForgeRegistry registry = e.getRegistry();
        EssentialsBlocks.init();
        for (Block block : EssentialsBlocks.toRegister) {
            registry.register((IForgeRegistryEntry)block);
        }
        EssentialsBlocks.toRegister.clear();
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> e) {
        IForgeRegistry registry = e.getRegistry();
        EssentialsItems.init();
        for (Item item : EssentialsItems.toRegister) {
            registry.register((IForgeRegistryEntry)item);
        }
        EssentialsItems.toRegister.clear();
    }

    @SubscribeEvent
    public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> e) {
        IForgeRegistry reg = e.getRegistry();
        Essentials.register(BrazierTileEntity::new, "brazier", reg);
        Essentials.register(SlottedChestTileEntity::new, "slotted_chest", reg);
        Essentials.register(SortingHopperTileEntity::new, "sorting_hopper", reg);
        Essentials.register(SpeedHopperTileEntity::new, "speed_hopper", reg);
        Essentials.register(ItemShifterTileEntity::new, "item_shifter", reg);
        Essentials.register(HopperFilterTileEntity::new, "hopper_filter", reg);
        Essentials.register(BasicItemSplitterTileEntity::new, "basic_item_splitter", reg);
        Essentials.register(ItemSplitterTileEntity::new, "item_splitter", reg);
        Essentials.register(FluidShifterTileEntity::new, "fluid_splitter", reg);
    }

    private static void register(Supplier<? extends TileEntity> cons, String id, IForgeRegistry<TileEntityType<?>> reg) {
        Type type = null;
        TileEntityType teType = TileEntityType.Builder.func_200963_a(cons).func_206865_a(type);
        teType.setRegistryName(new ResourceLocation(MODID, id));
        reg.register((IForgeRegistryEntry)teType);
    }
}

