/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks;

import com.Da_Technomancer.essentials.blocks.EssentialsBlocks;
import com.Da_Technomancer.essentials.blocks.EssentialsProperties;
import com.Da_Technomancer.essentials.tileentities.BrazierTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Brazier
extends BlockContainer {
    private static final VoxelShape SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0), (VoxelShape)Block.func_208617_a((double)1.0, (double)10.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0));

    protected Brazier() {
        super(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(2.0f));
        String name = "brazier";
        this.setRegistryName(name);
        this.func_180632_j((IBlockState)this.func_176223_P().func_206870_a((IProperty)EssentialsProperties.BRAZIER_CONTENTS, (Comparable)Integer.valueOf(0)));
        EssentialsBlocks.toRegister.add((Block)this);
        EssentialsBlocks.blockAddQue(this);
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new BrazierTileEntity();
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return SHAPE;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public int getLightValue(IBlockState state, IWorldReader world, BlockPos pos) {
        IBlockState other = world.func_180495_p(pos);
        if (other.func_177230_c() != this) {
            return other.getLightValue(world, pos);
        }
        switch ((Integer)state.func_177229_b((IProperty)EssentialsProperties.BRAZIER_CONTENTS)) {
            case 2: 
            case 4: {
                return 15;
            }
            case 3: {
                return 14;
            }
            case 7: {
                return 3;
            }
        }
        return 0;
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        int type = (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)EssentialsProperties.BRAZIER_CONTENTS);
        if (type == 1) {
            entityIn.func_70066_B();
        } else if (type == 2) {
            entityIn.func_70015_d(5);
        }
        super.func_176199_a(worldIn, pos, entityIn);
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        int type = (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)EssentialsProperties.BRAZIER_CONTENTS);
        if (type != 1 && type != 2) {
            super.func_180658_a(worldIn, pos, entityIn, fallDistance);
        }
        if (type == 2 && entityIn instanceof EntityItem) {
            entityIn.func_70106_y();
        }
    }

    public boolean func_196250_a(IBlockState state, World worldIn, BlockPos pos, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack out;
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof BrazierTileEntity && !(out = ((BrazierTileEntity)te).useItem(playerIn.func_184586_b(hand))).equals(playerIn.func_184586_b(hand))) {
            if (!worldIn.field_72995_K) {
                playerIn.func_184611_a(hand, out);
            }
            return true;
        }
        return false;
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{EssentialsProperties.BRAZIER_CONTENTS});
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_196243_a(IBlockState state, World worldIn, BlockPos pos, IBlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity te = worldIn.func_175625_s(pos);
            if (te instanceof BrazierTileEntity) {
                ItemStack made = ItemStack.field_190927_a;
                switch ((Integer)state.func_177229_b((IProperty)EssentialsProperties.BRAZIER_CONTENTS)) {
                    case 3: {
                        made = new ItemStack((IItemProvider)Blocks.field_150402_ci);
                        break;
                    }
                    case 4: {
                        made = new ItemStack((IItemProvider)Blocks.field_150426_aN);
                        break;
                    }
                    case 6: {
                        made = new ItemStack((IItemProvider)Blocks.field_150425_aM);
                        break;
                    }
                    case 7: {
                        made = new ItemStack((IItemProvider)Items.field_151170_bI);
                    }
                }
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)made);
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        tooltip.add((ITextComponent)new TextComponentString("Able to hold Water, Lava, Glowstone, Coal Blocks, and Soul Sand"));
        tooltip.add((ITextComponent)new TextComponentString("Can prevent fall damage with liquid, emit light with Glowstone/Coal/Lava, destroy dropped items with Lava, or block witch spawns with Soul Sand"));
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

