/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks;

import com.Da_Technomancer.essentials.EssentialsConfig;
import com.Da_Technomancer.essentials.blocks.EssentialsBlocks;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.ToolType;

public class FertileSoil
extends Block {
    private final IBlockState plant;

    protected FertileSoil(String plantName, IBlockState plant) {
        super(Block.Properties.func_200945_a((Material)(plant.func_177230_c() == Blocks.field_150388_bm ? Material.field_151595_p : Material.field_151578_c)).func_200943_b(0.5f).func_200947_a(SoundType.field_185849_b).func_200944_c());
        this.plant = plant;
        String name = "fertile_soil_" + plantName;
        this.setRegistryName(name);
        EssentialsBlocks.toRegister.add(this);
        EssentialsBlocks.blockAddQue(this);
    }

    public boolean isToolEffective(IBlockState state, ToolType tool) {
        return tool == ToolType.SHOVEL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        tooltip.add((ITextComponent)new TextComponentString("Slowly creates the seed plant/sapling on top of it, for free"));
        tooltip.add((ITextComponent)new TextComponentString("Doesn't need a water source, and can't be trampled"));
        if (this.plant.func_177230_c() == Blocks.field_150388_bm) {
            tooltip.add((ITextComponent)new TextComponentString("Made with farmer souls"));
        }
    }

    public boolean canSustainPlant(IBlockState state, IBlockReader world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return this.plant.func_177230_c() == Blocks.field_150388_bm == (plantable.getPlantType(world, pos.func_177972_a(direction)) == EnumPlantType.Nether);
    }

    public boolean isFertile(IBlockState state, IBlockReader world, BlockPos pos) {
        return true;
    }

    public void func_196267_b(IBlockState state, World worldIn, BlockPos pos, Random random) {
        if (worldIn.field_72995_K) {
            return;
        }
        if ((Double)EssentialsConfig.fertileSoilRate.get() < 100.0 * Math.random()) {
            return;
        }
        BlockPos upPos = pos.func_177972_a(EnumFacing.UP);
        if (worldIn.func_175623_d(upPos)) {
            worldIn.func_175656_a(upPos, this.plant);
        }
    }
}

