/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks;

import com.Da_Technomancer.essentials.EssentialsConfig;
import com.Da_Technomancer.essentials.blocks.EssentialsBlocks;
import com.Da_Technomancer.essentials.blocks.EssentialsProperties;
import com.Da_Technomancer.essentials.tileentities.HopperFilterTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HopperFilter
extends BlockContainer {
    private static final VoxelShape[] BB = new VoxelShape[3];

    protected HopperFilter() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200943_b(2.0f));
        String name = "hopper_filter";
        this.setRegistryName(name);
        EssentialsBlocks.toRegister.add((Block)this);
        EssentialsBlocks.blockAddQue(this);
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new HopperFilterTileEntity();
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        tooltip.add((ITextComponent)new TextComponentString("Allows items to be moved through it only if they match the filter"));
        tooltip.add((ITextComponent)new TextComponentString("Doesn't move items on its own"));
        tooltip.add((ITextComponent)new TextComponentString("Setting a Shulker Box as a filter matches everything in the Shulker Box"));
    }

    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face.func_176740_k() == state.func_177229_b(EssentialsProperties.AXIS) ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return BB[((EnumFacing.Axis)state.func_177229_b(EssentialsProperties.AXIS)).ordinal()];
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{EssentialsProperties.AXIS});
    }

    public boolean func_196250_a(IBlockState state, World worldIn, BlockPos pos, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (EssentialsConfig.isWrench(playerIn.func_184586_b(hand))) {
            if (!worldIn.field_72995_K) {
                worldIn.func_175656_a(pos, (IBlockState)state.func_177231_a(EssentialsProperties.AXIS));
                TileEntity te = worldIn.func_175625_s(pos);
                if (te instanceof HopperFilterTileEntity) {
                    ((HopperFilterTileEntity)te).clearCache();
                }
            }
            return true;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof HopperFilterTileEntity) {
            if (!worldIn.field_72995_K) {
                HopperFilterTileEntity fte = (HopperFilterTileEntity)te;
                ItemStack held = playerIn.func_184586_b(hand);
                if (fte.getFilter().func_190926_b() && !held.func_190926_b()) {
                    fte.setFilter(held.func_77979_a(1));
                    playerIn.func_184611_a(hand, held);
                } else if (!fte.getFilter().func_190926_b() && held.func_190926_b()) {
                    playerIn.func_184611_a(hand, fte.getFilter());
                    fte.setFilter(ItemStack.field_190927_a);
                }
            }
            return true;
        }
        return false;
    }

    public IBlockState func_196258_a(BlockItemUseContext context) {
        return (IBlockState)this.func_176223_P().func_206870_a(EssentialsProperties.AXIS, (Comparable)context.func_196000_l().func_176740_k());
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    static {
        HopperFilter.BB[0] = VoxelShapes.func_197882_b((VoxelShape)HopperFilter.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), (VoxelShape)VoxelShapes.func_197882_b((VoxelShape)HopperFilter.func_208617_a((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)HopperFilter.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), (IBooleanFunction)IBooleanFunction.OR), (IBooleanFunction)IBooleanFunction.OR);
        HopperFilter.BB[1] = VoxelShapes.func_197882_b((VoxelShape)HopperFilter.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), (VoxelShape)VoxelShapes.func_197882_b((VoxelShape)HopperFilter.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)HopperFilter.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), (IBooleanFunction)IBooleanFunction.OR), (IBooleanFunction)IBooleanFunction.OR);
        HopperFilter.BB[2] = VoxelShapes.func_197882_b((VoxelShape)HopperFilter.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), (VoxelShape)VoxelShapes.func_197882_b((VoxelShape)HopperFilter.func_208617_a((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)HopperFilter.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), (IBooleanFunction)IBooleanFunction.OR), (IBooleanFunction)IBooleanFunction.OR);
    }
}

