/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks;

import com.Da_Technomancer.essentials.EssentialsConfig;
import com.Da_Technomancer.essentials.WorldBuffer;
import com.Da_Technomancer.essentials.blocks.EssentialsBlocks;
import com.Da_Technomancer.essentials.blocks.EssentialsProperties;
import com.Da_Technomancer.essentials.blocks.MultiPistonExtend;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;

public class MultiPistonBase
extends Block {
    private static final int DIST_LIMIT = 15;
    private static final int PUSH_LIMIT = 64;
    private final boolean sticky;
    private static final VoxelShape[] BB = new VoxelShape[]{MultiPistonBase.func_208617_a((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), MultiPistonBase.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), MultiPistonBase.func_208617_a((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0, (double)16.0), MultiPistonBase.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)11.0), MultiPistonBase.func_208617_a((double)5.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), MultiPistonBase.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0)};
    protected static boolean changingWorld = false;

    protected MultiPistonBase(boolean sticky) {
        super(Block.Properties.func_200945_a((Material)Material.field_76233_E).func_200943_b(0.5f).func_200947_a(SoundType.field_185852_e));
        String name = "multi_piston" + (sticky ? "_sticky" : "");
        this.setRegistryName(name);
        this.sticky = sticky;
        this.func_180632_j((IBlockState)((IBlockState)this.func_176223_P().func_206870_a((IProperty)EssentialsProperties.FACING, (Comparable)EnumFacing.NORTH)).func_206870_a((IProperty)EssentialsProperties.EXTENDED, (Comparable)Boolean.valueOf(false)));
        EssentialsBlocks.toRegister.add(this);
        EssentialsBlocks.blockAddQue(this);
    }

    @Nullable
    public IBlockState func_196258_a(BlockItemUseContext context) {
        return (IBlockState)this.func_176223_P().func_206870_a((IProperty)EssentialsProperties.FACING, (Comparable)context.func_196010_d().func_176734_d());
    }

    public boolean func_196250_a(IBlockState state, World worldIn, BlockPos pos, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (EssentialsConfig.isWrench(playerIn.func_184586_b(hand)) && !((Boolean)state.func_177229_b((IProperty)EssentialsProperties.EXTENDED)).booleanValue()) {
            if (!worldIn.field_72995_K) {
                IBlockState endState = (IBlockState)state.func_177231_a((IProperty)EssentialsProperties.FACING);
                worldIn.func_175656_a(pos, endState);
            }
            return true;
        }
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)EssentialsProperties.EXTENDED) == false;
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TextComponentString("An uber piston that can push up to 15 blocks away, move 64 blocks at a time, and extends instantly"));
        tooltip.add((ITextComponent)new TextComponentString("Extension length controlled by signal strength"));
    }

    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == state.func_177229_b((IProperty)EssentialsProperties.FACING) && (Boolean)state.func_177229_b((IProperty)EssentialsProperties.EXTENDED) != false ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)EssentialsProperties.EXTENDED)).booleanValue()) {
            return BB[((EnumFacing)state.func_177229_b((IProperty)EssentialsProperties.FACING)).func_176745_a()];
        }
        return VoxelShapes.func_197868_b();
    }

    public void func_176206_d(IWorld world, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)EssentialsProperties.EXTENDED)).booleanValue()) {
            world.func_175698_g(pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)EssentialsProperties.FACING)));
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.func_189540_a(world.func_180495_p(pos), world, pos, null, null);
    }

    public boolean shouldCheckWeakPower(IBlockState state, IWorldReader world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (worldIn.field_72995_K || changingWorld) {
            return;
        }
        this.activate(worldIn, pos, state);
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{EssentialsProperties.FACING, EssentialsProperties.EXTENDED});
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)EssentialsProperties.EXTENDED) != false ? EnumPushReaction.BLOCK : EnumPushReaction.NORMAL;
    }

    private void activate(World world, BlockPos pos, IBlockState state) {
        int i;
        int target = 0;
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)EssentialsProperties.FACING);
        for (EnumFacing dir : EnumFacing.values()) {
            if (dir == facing) continue;
            target = Math.max(target, world.func_175651_c(pos.func_177972_a(dir), dir));
        }
        target = Math.min(target, 15);
        if (facing == EnumFacing.UP) {
            target = Math.min(target, world.func_72800_K() - pos.func_177956_o() - 1);
        } else if (facing == EnumFacing.DOWN) {
            target = Math.min(target, pos.func_177956_o());
        }
        int currentExtension = 0;
        if (((Boolean)state.func_177229_b((IProperty)EssentialsProperties.EXTENDED)).booleanValue()) {
            EnumFacing.AxisDirection dir;
            MultiPistonExtend tarBlock;
            BlockPos checkPos = pos.func_177972_a(facing);
            IBlockState curState = world.func_180495_p(checkPos);
            MultiPistonExtend multiPistonExtend = tarBlock = this.sticky ? EssentialsBlocks.multiPistonExtendSticky : EssentialsBlocks.multiPistonExtend;
            while (curState.func_177230_c() == tarBlock && curState.func_177229_b(EssentialsProperties.AXIS) == facing.func_176740_k() && (dir = MultiPistonExtend.getDirFromHead((Integer)curState.func_177229_b((IProperty)EssentialsProperties.HEAD))) != facing.func_176734_d().func_176743_c() && currentExtension != 15) {
                ++currentExtension;
                checkPos = checkPos.func_177972_a(facing);
                curState = world.func_180495_p(checkPos);
                if (dir == null) continue;
            }
        }
        if (currentExtension == target) {
            return;
        }
        changingWorld = true;
        WorldBuffer wBuf = new WorldBuffer(world);
        if (currentExtension < target) {
            for (i = currentExtension; i < target; ++i) {
                if (!this.shiftExtension(wBuf, pos, facing, i, true)) continue;
                target = i - 1;
                break;
            }
        } else {
            for (i = currentExtension; i > target; --i) {
                this.shiftExtension(wBuf, pos, facing, i, false);
            }
        }
        wBuf.applyChanges();
        if (currentExtension == 0 ^ target == 0) {
            world.func_175656_a(pos, (IBlockState)state.func_206870_a((IProperty)EssentialsProperties.EXTENDED, (Comparable)Boolean.valueOf(target != 0)));
        }
        changingWorld = false;
    }

    private boolean shiftExtension(WorldBuffer world, BlockPos pos, EnumFacing facing, int currentExtension, boolean out) {
        MultiPistonExtend extendBlock;
        EnumFacing moveDir = out ? facing : facing.func_176734_d();
        LinkedHashSet<BlockPos> movedBlocks = new LinkedHashSet<BlockPos>(65);
        BlockPos prevHeadPos = pos.func_177967_a(facing, currentExtension);
        MultiPistonExtend multiPistonExtend = extendBlock = this.sticky ? EssentialsBlocks.multiPistonExtendSticky : EssentialsBlocks.multiPistonExtend;
        if (!out) {
            movedBlocks.add(prevHeadPos);
        }
        if ((out || this.sticky) && this.buildMoveset(pos, world, prevHeadPos.func_177972_a(facing), moveDir, movedBlocks, !out)) {
            if (!out) {
                movedBlocks.clear();
            } else {
                return true;
            }
        }
        if (!out) {
            movedBlocks.remove(prevHeadPos);
        }
        if (currentExtension != 0) {
            world.addChange(prevHeadPos, out ? (IBlockState)extendBlock.func_176223_P().func_206870_a(EssentialsProperties.AXIS, (Comparable)facing.func_176740_k()) : Blocks.field_150350_a.func_176223_P());
        }
        for (BlockPos changePos : movedBlocks) {
            IBlockState prevState = world.getBlockState(changePos);
            if (prevState.func_185905_o() == EnumPushReaction.DESTROY) {
                world.getWorld().func_175655_b(changePos, true);
            } else {
                world.addChange(changePos.func_177972_a(moveDir), prevState);
            }
            world.addChange(changePos, Blocks.field_150350_a.func_176223_P());
            this.moveEnts(world.getWorld(), changePos, moveDir, this.isStickyBlock(prevState));
        }
        this.moveEnts(world.getWorld(), prevHeadPos, moveDir, false);
        if (out) {
            world.addChange(pos.func_177967_a(facing, currentExtension + 1), (IBlockState)((IBlockState)extendBlock.func_176223_P().func_206870_a(EssentialsProperties.AXIS, (Comparable)facing.func_176740_k())).func_206870_a((IProperty)EssentialsProperties.HEAD, (Comparable)Integer.valueOf(facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? 1 : 2)));
        } else if (currentExtension != 1) {
            world.addChange(pos.func_177967_a(facing, currentExtension - 1), (IBlockState)((IBlockState)extendBlock.func_176223_P().func_206870_a(EssentialsProperties.AXIS, (Comparable)facing.func_176740_k())).func_206870_a((IProperty)EssentialsProperties.HEAD, (Comparable)Integer.valueOf(facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? 1 : 2)));
        }
        return false;
    }

    private void moveEnts(World world, BlockPos activePos, EnumFacing moveDir, boolean sticky) {
        AxisAlignedBB BB = new AxisAlignedBB(activePos.func_177972_a(moveDir));
        ArrayList<Entity> movingEnts = new ArrayList<Entity>(4);
        MultiPistonBase.getEntitiesMultiChunk(BB, world, movingEnts);
        for (Entity ent : movingEnts) {
            if (ent.func_184192_z() == EnumPushReaction.IGNORE) continue;
            ent.func_70634_a(ent.field_70165_t + (double)moveDir.func_82601_c(), ent.field_70163_u + (double)moveDir.func_96559_d(), ent.field_70161_v + (double)moveDir.func_82599_e());
            if (!sticky) continue;
            ent.func_70024_g((double)moveDir.func_82601_c(), (double)moveDir.func_96559_d(), (double)moveDir.func_82599_e());
            ent.field_70133_I = true;
        }
        movingEnts.clear();
    }

    private boolean buildMoveset(BlockPos pistonPos, WorldBuffer world, BlockPos curPos, EnumFacing moveDir, LinkedHashSet<BlockPos> movedBlocks, boolean dragging) {
        if (movedBlocks.contains(curPos)) {
            return false;
        }
        IBlockState state = world.getBlockState(curPos);
        EnumPushReaction reaction = state.func_185905_o();
        if (state.func_177230_c().isAir(state, (IBlockReader)world.getWorld(), curPos)) {
            reaction = EnumPushReaction.IGNORE;
        } else if (state.func_177230_c() == Blocks.field_150343_Z || state.func_177230_c().hasTileEntity(state) || pistonPos.equals((Object)curPos)) {
            reaction = EnumPushReaction.BLOCK;
        }
        boolean blocked = false;
        switch (reaction) {
            case PUSH_ONLY: {
                if (dragging) break;
            }
            case NORMAL: {
                if (moveDir == EnumFacing.UP && curPos.func_177956_o() == world.getWorld().func_72800_K() || moveDir == EnumFacing.DOWN && curPos.func_177956_o() == 0) {
                    blocked = true;
                    break;
                }
                blocked = movedBlocks.size() > 64 || this.buildMoveset(pistonPos, world, curPos.func_177972_a(moveDir), moveDir, movedBlocks, false);
                movedBlocks.add(curPos);
                if (this.isStickyBlock(state)) {
                    boolean bl = blocked = blocked || this.buildMoveset(pistonPos, world, curPos.func_177972_a(moveDir.func_176734_d()), moveDir, movedBlocks, true);
                }
                if (!this.isStickyBlock(state)) break;
                for (EnumFacing side : EnumFacing.values()) {
                    if (side.func_176740_k() == moveDir.func_176740_k()) continue;
                    blocked = blocked || this.buildMoveset(pistonPos, world, curPos.func_177972_a(side), moveDir, movedBlocks, true);
                }
                break;
            }
            case DESTROY: {
                if (dragging) break;
                movedBlocks.add(curPos);
                break;
            }
            case BLOCK: {
                blocked = !dragging;
                break;
            }
        }
        return blocked || movedBlocks.size() > 64;
    }

    private static void getEntitiesMultiChunk(AxisAlignedBB checkBox, World worldIn, ArrayList<Entity> entList) {
        double maxEntityRad = worldIn.getMaxEntityRadius();
        int i = MathHelper.func_76128_c((double)((checkBox.field_72340_a - maxEntityRad) / 16.0)) - 1;
        int j = MathHelper.func_76128_c((double)((checkBox.field_72336_d + maxEntityRad) / 16.0)) + 1;
        int k = MathHelper.func_76128_c((double)((checkBox.field_72339_c - maxEntityRad) / 16.0)) - 1;
        int l = MathHelper.func_76128_c((double)((checkBox.field_72334_f + maxEntityRad) / 16.0)) + 1;
        int yMin = MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)((checkBox.field_72338_b - maxEntityRad) / 16.0)) - 1), (int)0, (int)15);
        int yMax = MathHelper.func_76125_a((int)(MathHelper.func_76128_c((double)((checkBox.field_72337_e + maxEntityRad) / 16.0)) + 1), (int)0, (int)15);
        for (int iLoop = i; iLoop <= j; ++iLoop) {
            for (int kLoop = k; kLoop <= l; ++kLoop) {
                if (!((ChunkProviderServer)worldIn.func_72863_F()).func_73149_a(iLoop, kLoop)) continue;
                Chunk chunk = worldIn.func_72964_e(iLoop, kLoop);
                for (int yLoop = yMin; yLoop <= yMax; ++yLoop) {
                    if (chunk.func_177429_s()[yLoop].isEmpty()) continue;
                    for (Entity entity : chunk.func_177429_s()[yLoop]) {
                        if (!entity.func_174813_aQ().func_72326_a(checkBox)) continue;
                        entList.add(entity);
                    }
                }
            }
        }
    }
}

