/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks;

import com.Da_Technomancer.essentials.blocks.EssentialsBlocks;
import com.Da_Technomancer.essentials.blocks.EssentialsProperties;
import com.Da_Technomancer.essentials.blocks.MultiPistonBase;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class MultiPistonExtend
extends Block {
    private final boolean sticky;
    private static final VoxelShape[] ROD_BB = new VoxelShape[]{MultiPistonExtend.func_208617_a((double)0.001, (double)6.0, (double)6.0, (double)15.999, (double)10.0, (double)10.0), MultiPistonExtend.func_208617_a((double)6.0, (double)0.001, (double)6.0, (double)10.0, (double)15.999, (double)10.0), MultiPistonExtend.func_208617_a((double)6.0, (double)6.0, (double)0.001, (double)10.0, (double)10.0, (double)15.999)};
    private static final VoxelShape[] HEAD_BB = new VoxelShape[]{MultiPistonExtend.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), MultiPistonExtend.func_208617_a((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), MultiPistonExtend.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)5.0), MultiPistonExtend.func_208617_a((double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0, (double)16.0), MultiPistonExtend.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0), MultiPistonExtend.func_208617_a((double)11.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    protected MultiPistonExtend(boolean sticky) {
        super(Block.Properties.func_200945_a((Material)Material.field_76233_E).func_200943_b(0.5f));
        this.sticky = sticky;
        String name = "multi_piston_extend" + (sticky ? "_sticky" : "");
        this.setRegistryName(name);
        this.func_180632_j((IBlockState)((IBlockState)this.func_176223_P().func_206870_a(EssentialsProperties.AXIS, (Comparable)EnumFacing.Axis.Y)).func_206870_a((IProperty)EssentialsProperties.HEAD, (Comparable)Integer.valueOf(0)));
        EssentialsBlocks.toRegister.add(this);
    }

    @Nullable
    protected static EnumFacing.AxisDirection getDirFromHead(int head) {
        if (head == 0) {
            return null;
        }
        return EnumFacing.AxisDirection.values()[head - 1];
    }

    public void func_196255_a(IBlockState state, World worldIn, BlockPos pos, float chancePerItem, int fortune) {
        if (!MultiPistonBase.changingWorld) {
            MultiPistonBase piston = this.sticky ? EssentialsBlocks.multiPistonSticky : EssentialsBlocks.multiPiston;
            NonNullList drops = NonNullList.func_191196_a();
            piston.getDrops(state, drops, worldIn, pos, fortune);
            for (ItemStack s : drops) {
                MultiPistonExtend.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)s);
            }
        }
    }

    public void func_176206_d(IWorld world, BlockPos pos, IBlockState state) {
        if (!MultiPistonBase.changingWorld) {
            EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b(EssentialsProperties.AXIS);
            EnumFacing.AxisDirection dir = MultiPistonExtend.getDirFromHead((Integer)state.func_177229_b((IProperty)EssentialsProperties.HEAD));
            MultiPistonBase piston = this.sticky ? EssentialsBlocks.multiPistonSticky : EssentialsBlocks.multiPiston;
            for (EnumFacing.AxisDirection actDir : EnumFacing.AxisDirection.values()) {
                BlockPos adjPos;
                IBlockState adjState;
                if (actDir == dir || ((adjState = world.func_180495_p(adjPos = pos.func_177972_a(EnumFacing.func_181076_a((EnumFacing.AxisDirection)actDir, (EnumFacing.Axis)axis)))).func_177230_c() != piston || ((EnumFacing)adjState.func_177229_b((IProperty)EssentialsProperties.FACING)).func_176740_k() != axis) && (adjState.func_177230_c() != this || adjState.func_177229_b(EssentialsProperties.AXIS) != axis)) continue;
                world.func_175698_g(adjPos);
            }
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{EssentialsProperties.AXIS, EssentialsProperties.HEAD});
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b(EssentialsProperties.AXIS);
        EnumFacing.AxisDirection dir = MultiPistonExtend.getDirFromHead((Integer)state.func_177229_b((IProperty)EssentialsProperties.HEAD));
        if (dir == null) {
            return ROD_BB[axis.ordinal()];
        }
        return VoxelShapes.func_197882_b((VoxelShape)ROD_BB[axis.ordinal()], (VoxelShape)HEAD_BB[EnumFacing.func_181076_a((EnumFacing.AxisDirection)dir, (EnumFacing.Axis)axis).func_176745_a()], (IBooleanFunction)IBooleanFunction.OR);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face.func_176740_k() == state.func_177229_b(EssentialsProperties.AXIS)) {
            EnumFacing.AxisDirection dir = MultiPistonExtend.getDirFromHead((Integer)state.func_177229_b((IProperty)EssentialsProperties.HEAD));
            if (dir == null || face.func_176743_c() != dir) {
                return BlockFaceShape.MIDDLE_POLE_THIN;
            }
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }
}

