/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.gui.container;

import com.Da_Technomancer.essentials.tileentities.FluidShifterTileEntity;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class FluidShifterContainer
extends Container {
    public final IInventory playerInv;
    public final FluidShifterTileEntity te;
    private final int[] fields = new int[2];
    public static final int[] invStart = new int[]{8, 84};

    public FluidShifterContainer(IInventory playerInv, FluidShifterTileEntity te) {
        this.playerInv = playerInv;
        this.te = te;
        this.func_75146_a(new FluidSlot(this, 100, 19, 100, 54));
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot(playerInv, x, invStart[0] + x * 18, invStart[1] + 58));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot(playerInv, x + y * 9 + 9, invStart[0] + x * 18, invStart[1] + y * 18));
            }
        }
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int fromSlot) {
        ItemStack previous = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(fromSlot);
        if (slot != null && slot.func_75216_d()) {
            ItemStack current = slot.func_75211_c();
            previous = current.func_77946_l();
            if (fromSlot < 2 ? !this.func_75135_a(current, 2, 38, true) : !this.func_75135_a(current, 0, 2, false)) {
                return ItemStack.field_190927_a;
            }
            if (current.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (current.func_190916_E() == previous.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, current);
        }
        return previous;
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return this.te.func_70300_a(playerIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_75137_b(int id, int data) {
        this.te.func_174885_b(id, data);
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        listener.func_175173_a((Container)this, (IInventory)this.te);
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i] == this.te.func_174887_a_(i)) continue;
            this.fields[i] = this.te.func_174887_a_(i);
            for (IContainerListener listener : this.field_75149_d) {
                listener.func_71112_a((Container)this, i, this.fields[i]);
            }
        }
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (!this.te.func_145831_w().field_72995_K) {
            if (!(!playerIn.func_70089_S() || playerIn instanceof EntityPlayerMP && ((EntityPlayerMP)playerIn).func_193105_t())) {
                playerIn.field_71071_by.func_191975_a(this.te.func_145831_w(), ((Slot)this.field_75151_b.get(0)).func_75211_c());
                playerIn.field_71071_by.func_191975_a(this.te.func_145831_w(), ((Slot)this.field_75151_b.get(1)).func_75211_c());
            } else {
                playerIn.func_71019_a(((Slot)this.field_75151_b.get(0)).func_75211_c(), false);
                playerIn.func_71019_a(((Slot)this.field_75151_b.get(1)).func_75211_c(), false);
            }
        }
    }

    protected static class FluidSlot
    extends Slot {
        protected final FluidShifterContainer cont;
        protected final Slot outputSlot;

        public FluidSlot(FluidShifterContainer container, int x, int y, int outputX, int outputY) {
            super((IInventory)new FakeInventory(), 0, x, y);
            this.cont = container;
            this.outputSlot = new Slot(this.field_75224_c, 1, outputX, outputY){

                public boolean func_75214_a(ItemStack stack) {
                    return false;
                }

                public ItemStack func_190901_a(EntityPlayer thePlayer, ItemStack stack) {
                    this.func_75218_e();
                    return stack;
                }
            };
            container.func_75146_a(this.outputSlot);
        }

        public boolean func_75214_a(ItemStack stack) {
            return FluidUtil.getFluidHandler((ItemStack)stack) != null;
        }

        public void func_75218_e() {
            if (!this.cont.te.func_145831_w().field_72995_K) {
                this.cont.func_75142_b();
                ItemStack stack = this.func_75211_c().func_77946_l();
                if (!stack.func_190926_b()) {
                    stack.func_190920_e(1);
                    LazyOptional teCap = this.cont.te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                    LazyOptional stackCap = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                    if (teCap.isPresent() && stackCap.isPresent()) {
                        IFluidHandler teHandler = (IFluidHandler)teCap.orElseThrow(NullPointerException::new);
                        IFluidHandlerItem stackHandler = (IFluidHandlerItem)stackCap.orElseThrow(NullPointerException::new);
                        FluidStack stFs = stackHandler.drain(Integer.MAX_VALUE, false);
                        FluidStack teFs = teHandler.drain(Integer.MAX_VALUE, false);
                        ItemStack outputStack = this.field_75224_c.func_70301_a(1);
                        if (stFs == null && teFs != null) {
                            int filled = stackHandler.fill(teFs, true);
                            ItemStack container = stackHandler.getContainer();
                            if (filled > 0 && (outputStack.func_190926_b() || ItemStack.func_179545_c((ItemStack)outputStack, (ItemStack)container) && ItemStack.func_77970_a((ItemStack)outputStack, (ItemStack)container) && outputStack.func_190916_E() < outputStack.func_77976_d())) {
                                teHandler.drain(filled, true);
                                if (outputStack.func_190926_b()) {
                                    outputStack = container;
                                } else {
                                    outputStack.func_190917_f(container.func_190916_E());
                                }
                                this.field_75224_c.func_70299_a(1, outputStack);
                                this.field_75224_c.func_70298_a(0, 1);
                                this.cont.func_75142_b();
                            }
                        } else if (stFs != null) {
                            int drained = teHandler.fill(stFs, false);
                            FluidStack drainedFs = stackHandler.drain(drained, true);
                            if (drained == 0 || drainedFs == null || drained != drainedFs.amount) {
                                return;
                            }
                            ItemStack container = stackHandler.getContainer();
                            if (outputStack.func_190926_b() || ItemStack.func_179545_c((ItemStack)outputStack, (ItemStack)container) && ItemStack.func_77970_a((ItemStack)outputStack, (ItemStack)container) && outputStack.func_190916_E() < outputStack.func_77976_d()) {
                                teHandler.fill(drainedFs, true);
                                if (outputStack.func_190926_b()) {
                                    outputStack = container;
                                } else {
                                    outputStack.func_190917_f(container.func_190916_E());
                                }
                                this.field_75224_c.func_70299_a(1, outputStack);
                                this.field_75224_c.func_70298_a(0, 1);
                                this.cont.func_75142_b();
                            }
                        }
                    }
                }
            }
        }

        private static class FakeInventory
        implements IInventory {
            protected final ItemStack[] stacks = new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a};

            private FakeInventory() {
            }

            public int func_70302_i_() {
                return 2;
            }

            public boolean func_191420_l() {
                return this.stacks[0].func_190926_b() && this.stacks[1].func_190926_b();
            }

            public ItemStack func_70301_a(int index) {
                return this.stacks[index];
            }

            public ItemStack func_70298_a(int index, int count) {
                return this.stacks[index].func_77979_a(count);
            }

            public ItemStack func_70304_b(int index) {
                ItemStack stack = this.stacks[index];
                this.stacks[index] = ItemStack.field_190927_a;
                return stack;
            }

            public void func_70299_a(int index, ItemStack stack) {
                this.stacks[index] = stack;
            }

            public int func_70297_j_() {
                return 64;
            }

            public void func_70296_d() {
            }

            public boolean func_70300_a(EntityPlayer player) {
                return true;
            }

            public void func_174889_b(EntityPlayer player) {
            }

            public void func_174886_c(EntityPlayer player) {
            }

            public boolean func_94041_b(int index, ItemStack stack) {
                return index == 0 && stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).isPresent();
            }

            public int func_174887_a_(int id) {
                return 0;
            }

            public void func_174885_b(int id, int value) {
            }

            public int func_174890_g() {
                return 0;
            }

            public void func_174888_l() {
                this.stacks[0] = ItemStack.field_190927_a;
                this.stacks[1] = ItemStack.field_190927_a;
            }

            public boolean func_145818_k_() {
                return false;
            }

            @Nullable
            public ITextComponent func_200201_e() {
                return null;
            }

            public ITextComponent func_200200_C_() {
                return new TextComponentString("");
            }
        }
    }
}

