/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.blocks.EssentialsProperties;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="essentials")
public class BasicItemSplitterTileEntity
extends TileEntity
implements ITickable {
    @ObjectHolder(value="basic_item_splitter")
    private static TileEntityType<BasicItemSplitterTileEntity> TYPE = null;
    public static final int[] MODES = new int[]{1, 2, 3};
    private int mode = 1;
    private ItemStack[] inventory = new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a};
    private EnumFacing facing = null;
    private final OutItemHandler primaryHandler = new OutItemHandler(1);
    private final OutItemHandler secondaryHandler = new OutItemHandler(0);
    private final InHandler inHandler = new InHandler();
    private int transfered = 0;

    public BasicItemSplitterTileEntity(TileEntityType<?> type) {
        super(type);
    }

    public BasicItemSplitterTileEntity() {
        this(TYPE);
    }

    private EnumFacing getFacing() {
        if (this.facing == null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!state.func_196959_b((IProperty)EssentialsProperties.FACING)) {
                return EnumFacing.DOWN;
            }
            this.facing = (EnumFacing)state.func_177229_b((IProperty)EssentialsProperties.FACING);
        }
        return this.facing;
    }

    public void func_73660_a() {
        EnumFacing dir = this.getFacing();
        block0: for (int i = 0; i < 2; ++i) {
            LazyOptional outHandlerCon;
            EnumFacing side = i == 0 ? dir : dir.func_176734_d();
            TileEntity outputTE = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
            if (outputTE == null || !(outHandlerCon = outputTE.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d())).isPresent()) continue;
            IItemHandler outHandler = (IItemHandler)outHandlerCon.orElseThrow(NullPointerException::new);
            for (int j = 0; j < outHandler.getSlots(); ++j) {
                ItemStack outStack = outHandler.insertItem(j, this.inventory[i], false);
                if (outStack.func_190916_E() == this.inventory[i].func_190916_E()) continue;
                this.inventory[i] = outStack;
                this.func_70296_d();
                continue block0;
            }
        }
    }

    public int increaseMode() {
        ++this.mode;
        this.mode %= MODES.length;
        this.func_70296_d();
        return this.mode;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, EnumFacing side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            EnumFacing dir = this.getFacing();
            return side == dir ? LazyOptional.of(() -> new OutItemHandler(1)) : (side == dir.func_176734_d() ? LazyOptional.of(() -> new OutItemHandler(0)) : LazyOptional.of(() -> new InHandler()));
        }
        return super.getCapability(cap, side);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("mode", this.mode);
        nbt.func_74768_a("transfered", this.transfered);
        for (int i = 0; i < 2; ++i) {
            if (this.inventory[i].func_190926_b()) continue;
            NBTTagCompound inner = new NBTTagCompound();
            this.inventory[i].func_77955_b(inner);
            nbt.func_74782_a("inv_" + i, (INBTBase)inner);
        }
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.mode = nbt.func_74762_e("mode");
        this.transfered = nbt.func_74762_e("transfered");
        for (int i = 0; i < 2; ++i) {
            this.inventory[i] = ItemStack.func_199557_a((NBTTagCompound)nbt.func_74775_l("inv_" + i));
        }
    }

    protected int getPortion() {
        return MODES[this.mode];
    }

    protected int getBase() {
        return 4;
    }

    protected class OutItemHandler
    implements IItemHandler {
        private final int index;

        public OutItemHandler(int index) {
            this.index = index;
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return slot != 0 ? ItemStack.field_190927_a : BasicItemSplitterTileEntity.this.inventory[this.index];
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot != 0) {
                return ItemStack.field_190927_a;
            }
            int moved = Math.min(amount, BasicItemSplitterTileEntity.this.inventory[this.index].func_190916_E());
            if (simulate) {
                return new ItemStack((IItemProvider)BasicItemSplitterTileEntity.this.inventory[this.index].func_77973_b(), moved, BasicItemSplitterTileEntity.this.inventory[this.index].func_77978_p());
            }
            BasicItemSplitterTileEntity.this.func_70296_d();
            return BasicItemSplitterTileEntity.this.inventory[this.index].func_77979_a(moved);
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return false;
        }
    }

    private class InHandler
    implements IItemHandler {
        private InHandler() {
        }

        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (stack.func_190926_b() || slot != 0) {
                return stack;
            }
            int portion = BasicItemSplitterTileEntity.this.getPortion();
            int base = BasicItemSplitterTileEntity.this.getBase();
            int accepted = Math.max(0, Math.min(stack.func_190916_E(), portion == 0 ? (!(BasicItemSplitterTileEntity.this.inventory[1].func_190926_b() || ItemStack.func_179545_c((ItemStack)stack, (ItemStack)BasicItemSplitterTileEntity.this.inventory[1]) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)BasicItemSplitterTileEntity.this.inventory[1])) ? 0 : stack.func_77976_d() - BasicItemSplitterTileEntity.this.inventory[1].func_190916_E()) : (portion == base ? (!(BasicItemSplitterTileEntity.this.inventory[0].func_190926_b() || ItemStack.func_179545_c((ItemStack)stack, (ItemStack)BasicItemSplitterTileEntity.this.inventory[0]) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)BasicItemSplitterTileEntity.this.inventory[0])) ? 0 : stack.func_77976_d() - BasicItemSplitterTileEntity.this.inventory[0].func_190916_E()) : Math.min(!BasicItemSplitterTileEntity.this.inventory[0].func_190926_b() && (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)BasicItemSplitterTileEntity.this.inventory[0]) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)BasicItemSplitterTileEntity.this.inventory[0])) ? 0 : base * (stack.func_77976_d() - BasicItemSplitterTileEntity.this.inventory[0].func_190916_E()) / portion, !BasicItemSplitterTileEntity.this.inventory[1].func_190926_b() && (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)BasicItemSplitterTileEntity.this.inventory[1]) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)BasicItemSplitterTileEntity.this.inventory[1])) ? 0 : base * (stack.func_77976_d() - BasicItemSplitterTileEntity.this.inventory[1].func_190916_E()) / (base - portion)))));
            int goDown = portion * (accepted / base) + (BasicItemSplitterTileEntity.this.transfered >= portion ? 0 : Math.min(portion - BasicItemSplitterTileEntity.this.transfered, accepted % base)) + Math.max(0, Math.min(portion, accepted % base + BasicItemSplitterTileEntity.this.transfered - base));
            int goUp = accepted - goDown;
            if (!simulate && accepted != 0) {
                if (BasicItemSplitterTileEntity.this.inventory[0].func_190926_b()) {
                    ((BasicItemSplitterTileEntity)BasicItemSplitterTileEntity.this).inventory[0] = stack.func_77946_l();
                    BasicItemSplitterTileEntity.this.inventory[0].func_190920_e(goDown);
                } else {
                    BasicItemSplitterTileEntity.this.inventory[0].func_190917_f(goDown);
                }
                if (BasicItemSplitterTileEntity.this.inventory[1].func_190926_b()) {
                    ((BasicItemSplitterTileEntity)BasicItemSplitterTileEntity.this).inventory[1] = stack.func_77946_l();
                    BasicItemSplitterTileEntity.this.inventory[1].func_190920_e(goUp);
                } else {
                    BasicItemSplitterTileEntity.this.inventory[1].func_190917_f(goUp);
                }
                BasicItemSplitterTileEntity.this.transfered += accepted % base;
                BasicItemSplitterTileEntity.this.transfered %= base;
            }
            if (accepted > 0) {
                ItemStack out = stack.func_77946_l();
                out.func_190918_g(accepted);
                return out;
            }
            return stack;
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot == 0;
        }
    }
}

