/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.EssentialsConfig;
import com.Da_Technomancer.essentials.blocks.EssentialsBlocks;
import com.Da_Technomancer.essentials.blocks.EssentialsProperties;
import com.Da_Technomancer.essentials.gui.CrudeFluidBar;
import com.Da_Technomancer.essentials.gui.container.FluidShifterContainer;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IInteractionObject;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="essentials")
public class FluidShifterTileEntity
extends TileEntity
implements ITickable,
IInventory,
IInteractionObject {
    @ObjectHolder(value="fluid_splitter")
    private static TileEntityType<FluidShifterTileEntity> TYPE = null;
    private FluidStack inventory = null;
    private BlockPos endPos = null;
    public static final int CAPACITY = 4000;
    private EnumFacing facing = null;
    private final IFluidHandler handler = new FluidHandler();
    private short[] clientFluids = new short[2];

    public FluidShifterTileEntity() {
        super(TYPE);
    }

    private EnumFacing getFacing() {
        if (this.facing == null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!state.func_196959_b((IProperty)EssentialsProperties.FACING)) {
                return EnumFacing.DOWN;
            }
            this.facing = (EnumFacing)state.func_177229_b((IProperty)EssentialsProperties.FACING);
        }
        return this.facing;
    }

    public void func_73660_a() {
        IFluidHandler outHandler;
        int filled;
        LazyOptional outHandlerCon;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.endPos == null) {
            this.refreshCache();
        }
        if (this.inventory == null) {
            return;
        }
        TileEntity outputTE = this.field_145850_b.func_175625_s(this.endPos);
        EnumFacing dir = this.getFacing();
        if (outputTE != null && (outHandlerCon = outputTE.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.func_176734_d())).isPresent() && (filled = (outHandler = (IFluidHandler)outHandlerCon.orElseThrow(NullPointerException::new)).fill(this.inventory, true)) != 0) {
            if (this.inventory.amount == filled) {
                this.inventory = null;
            } else {
                this.inventory.amount -= filled;
            }
            this.func_70296_d();
        }
    }

    public void refreshCache() {
        IBlockState target;
        int extension;
        this.facing = null;
        EnumFacing dir = this.getFacing();
        int maxChutes = (Integer)EssentialsConfig.itemChuteRange.get();
        for (extension = 1; extension <= maxChutes && (target = this.field_145850_b.func_180495_p(this.field_174879_c.func_177967_a(dir, extension))).func_177230_c() == EssentialsBlocks.itemChute && target.func_177229_b(EssentialsProperties.AXIS) == dir.func_176740_k(); ++extension) {
        }
        this.endPos = this.field_174879_c.func_177967_a(dir, extension);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.inventory != null) {
            nbt.func_74782_a("inv", (INBTBase)this.inventory.writeToNBT(new NBTTagCompound()));
        }
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("inv")) {
            this.inventory = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("inv"));
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, EnumFacing facing) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.handler);
        }
        return super.getCapability(cap, facing);
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new FluidShifterContainer((IInventory)playerInventory, this);
    }

    public String func_174875_k() {
        return "essentials:fluid_shifter";
    }

    public ITextComponent func_200200_C_() {
        return new TextComponentTranslation("container.fluid_shifter", new Object[0]);
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return null;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public int func_70302_i_() {
        return 0;
    }

    public boolean func_191420_l() {
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
    }

    public int func_70297_j_() {
        return 0;
    }

    public void func_174888_l() {
    }

    public int func_174887_a_(int id) {
        if (id < 2) {
            if (this.field_145850_b.field_72995_K) {
                return this.clientFluids[id];
            }
            return CrudeFluidBar.fluidToPacket(this.inventory)[id];
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        if (id < 2) {
            this.clientFluids[id] = (short)value;
        }
    }

    public int func_174890_g() {
        return 2;
    }

    private class FluidHandler
    implements IFluidHandler {
        private FluidHandler() {
        }

        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[]{new FluidTankProperties(FluidShifterTileEntity.this.inventory, 4000)};
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource != null && (FluidShifterTileEntity.this.inventory == null || FluidShifterTileEntity.this.inventory.isFluidEqual(resource))) {
                int change = Math.min(4000 - (FluidShifterTileEntity.this.inventory == null ? 0 : ((FluidShifterTileEntity)FluidShifterTileEntity.this).inventory.amount), resource.amount);
                if (doFill) {
                    int prevAmount = FluidShifterTileEntity.this.inventory == null ? 0 : ((FluidShifterTileEntity)FluidShifterTileEntity.this).inventory.amount;
                    FluidShifterTileEntity.this.inventory = resource.copy();
                    ((FluidShifterTileEntity)FluidShifterTileEntity.this).inventory.amount = prevAmount + change;
                    FluidShifterTileEntity.this.func_70296_d();
                }
                return change;
            }
            return 0;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (resource != null && resource.isFluidEqual(FluidShifterTileEntity.this.inventory)) {
                int change = Math.min(((FluidShifterTileEntity)FluidShifterTileEntity.this).inventory.amount, resource.amount);
                if (doDrain) {
                    ((FluidShifterTileEntity)FluidShifterTileEntity.this).inventory.amount -= change;
                    if (((FluidShifterTileEntity)FluidShifterTileEntity.this).inventory.amount == 0) {
                        FluidShifterTileEntity.this.inventory = null;
                    }
                    FluidShifterTileEntity.this.func_70296_d();
                }
                FluidStack out = resource.copy();
                out.amount = change;
                return out;
            }
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (maxDrain != 0 && FluidShifterTileEntity.this.inventory != null) {
                int change = Math.min(((FluidShifterTileEntity)FluidShifterTileEntity.this).inventory.amount, maxDrain);
                FluidStack content = FluidShifterTileEntity.this.inventory.copy();
                content.amount = change;
                if (doDrain) {
                    ((FluidShifterTileEntity)FluidShifterTileEntity.this).inventory.amount -= change;
                    if (((FluidShifterTileEntity)FluidShifterTileEntity.this).inventory.amount == 0) {
                        FluidShifterTileEntity.this.inventory = null;
                    }
                    FluidShifterTileEntity.this.func_70296_d();
                }
                return content;
            }
            return null;
        }
    }
}

