/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.blocks.EssentialsBlocks;
import com.Da_Technomancer.essentials.blocks.EssentialsProperties;
import com.Da_Technomancer.essentials.packets.EssentialsPackets;
import com.Da_Technomancer.essentials.packets.INBTReceiver;
import com.Da_Technomancer.essentials.packets.SendSlotFilterToClient;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="essentials")
public class HopperFilterTileEntity
extends TileEntity
implements INBTReceiver {
    @ObjectHolder(value="hopper_filter")
    private static TileEntityType<HopperFilterTileEntity> TYPE = null;
    private EnumFacing.Axis axisCache = null;
    private ItemStack filter = ItemStack.field_190927_a;
    private LazyOptional<IItemHandler> passedHandler = null;

    public HopperFilterTileEntity() {
        super(TYPE);
    }

    public ItemStack getFilter() {
        return this.filter;
    }

    public void setFilter(ItemStack filter) {
        this.filter = filter;
        EssentialsPackets.channel.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)512.0, (DimensionType)this.field_145850_b.field_73011_w.func_186058_p())), (Object)new SendSlotFilterToClient(filter.func_77955_b(new NBTTagCompound()), this.field_174879_c));
        this.func_70296_d();
    }

    private EnumFacing.Axis getAxis() {
        if (this.axisCache == null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_177230_c() == EssentialsBlocks.hopperFilter) {
                this.axisCache = (EnumFacing.Axis)state.func_177229_b(EssentialsProperties.AXIS);
            } else {
                return EnumFacing.Axis.Y;
            }
        }
        return this.axisCache;
    }

    public void clearCache() {
        this.axisCache = null;
        if (this.passedHandler != null) {
            this.passedHandler.invalidate();
            this.passedHandler = null;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.filter.func_77955_b(nbt);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.filter = ItemStack.func_199557_a((NBTTagCompound)nbt);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    @Override
    public void receiveNBT(NBTTagCompound nbt) {
        this.filter = ItemStack.func_199557_a((NBTTagCompound)nbt);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, EnumFacing side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side.func_176740_k() == this.getAxis()) {
            if (this.passedHandler == null) {
                LazyOptional src;
                TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side.func_176734_d()));
                if (te != null && (src = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)).isPresent()) {
                    this.passedHandler = LazyOptional.of(() -> new ProxyItemHandler(src));
                    src.addListener(handler -> {
                        if (this.passedHandler != null) {
                            this.passedHandler.invalidate();
                        }
                        this.passedHandler = null;
                    });
                } else {
                    return LazyOptional.empty();
                }
            }
            return this.passedHandler;
        }
        return super.getCapability(cap, side);
    }

    private static boolean matchFilter(ItemStack query, ItemStack filt) {
        NBTTagCompound nbt;
        if (filt.func_190926_b()) {
            return true;
        }
        if (filt.func_77973_b() instanceof ItemBlock && ((ItemBlock)filt.func_77973_b()).func_179223_d() instanceof BlockShulkerBox && (nbt = filt.func_77978_p()) != null && (nbt = nbt.func_74775_l("BlockEntityTag")).func_150297_b("Items", 9)) {
            NonNullList nonnulllist = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((NBTTagCompound)nbt, (NonNullList)nonnulllist);
            for (ItemStack singleFilt : nonnulllist) {
                if (singleFilt.func_190926_b() || !HopperFilterTileEntity.matchFilter(query, singleFilt)) continue;
                return true;
            }
            return false;
        }
        return query.func_77973_b() == filt.func_77973_b();
    }

    private class ProxyItemHandler
    implements IItemHandler {
        private final LazyOptional<IItemHandler> src;

        private ProxyItemHandler(LazyOptional<IItemHandler> src) {
            this.src = src;
        }

        private IItemHandler getHandler() {
            if (this.src.isPresent()) {
                return (IItemHandler)this.src.orElseThrow(NullPointerException::new);
            }
            if (HopperFilterTileEntity.this.passedHandler != null) {
                HopperFilterTileEntity.this.passedHandler.invalidate();
            }
            HopperFilterTileEntity.this.passedHandler = null;
            return new BlankHandler();
        }

        public int getSlots() {
            return this.getHandler().getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.getHandler().getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (HopperFilterTileEntity.matchFilter(stack, HopperFilterTileEntity.this.filter)) {
                return this.getHandler().insertItem(slot, stack, simulate);
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (HopperFilterTileEntity.matchFilter(this.getStackInSlot(slot), HopperFilterTileEntity.this.filter)) {
                return this.getHandler().extractItem(slot, amount, simulate);
            }
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return this.getHandler().getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return HopperFilterTileEntity.matchFilter(stack, HopperFilterTileEntity.this.filter) && this.getHandler().isItemValid(slot, stack);
        }
    }

    private static class BlankHandler
    implements IItemHandler {
        private BlankHandler() {
        }

        public int getSlots() {
            return 0;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 0;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return false;
        }
    }
}

