/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.EssentialsConfig;
import com.Da_Technomancer.essentials.blocks.EssentialsBlocks;
import com.Da_Technomancer.essentials.blocks.EssentialsProperties;
import com.Da_Technomancer.essentials.gui.container.ItemShifterContainer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IInteractionObject;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="essentials")
public class ItemShifterTileEntity
extends TileEntity
implements ITickable,
IInventory,
IInteractionObject {
    @ObjectHolder(value="item_shifter")
    private static TileEntityType<ItemShifterTileEntity> TYPE = null;
    private ItemStack inventory = ItemStack.field_190927_a;
    private BlockPos endPos = null;
    private EnumFacing facing = null;

    public ItemShifterTileEntity() {
        super(TYPE);
    }

    private EnumFacing getFacing() {
        if (this.facing == null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!state.func_196959_b((IProperty)EssentialsProperties.FACING)) {
                return EnumFacing.DOWN;
            }
            this.facing = (EnumFacing)state.func_177229_b((IProperty)EssentialsProperties.FACING);
        }
        return this.facing;
    }

    public void func_73660_a() {
        LazyOptional outputCap;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.endPos == null) {
            this.refreshCache();
        }
        if (this.inventory.func_190926_b()) {
            return;
        }
        TileEntity outputTE = this.field_145850_b.func_175625_s(this.endPos);
        EnumFacing dir = this.getFacing();
        if (outputTE != null && (outputCap = outputTE.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d())).isPresent()) {
            IItemHandler outHandler = (IItemHandler)outputCap.orElseThrow(NullPointerException::new);
            for (int i = 0; i < outHandler.getSlots(); ++i) {
                ItemStack outStack = outHandler.insertItem(i, this.inventory, false);
                if (outStack.func_190916_E() == this.inventory.func_190916_E()) continue;
                this.inventory = outStack;
                this.func_70296_d();
                return;
            }
            return;
        }
        EntityItem ent = new EntityItem(this.field_145850_b, (double)this.endPos.func_177958_n() + 0.5, (double)this.endPos.func_177956_o() + 0.5, (double)this.endPos.func_177952_p() + 0.5, this.inventory);
        ent.field_70159_w = 0.0;
        ent.field_70179_y = 0.0;
        this.field_145850_b.func_72838_d((Entity)ent);
        this.inventory = ItemStack.field_190927_a;
        this.func_70296_d();
    }

    public void refreshCache() {
        IBlockState target;
        int extension;
        this.facing = null;
        EnumFacing dir = this.getFacing();
        int maxChutes = (Integer)EssentialsConfig.itemChuteRange.get();
        for (extension = 1; extension <= maxChutes && (target = this.field_145850_b.func_180495_p(this.field_174879_c.func_177967_a(dir, extension))).func_177230_c() == EssentialsBlocks.itemChute && target.func_177229_b(EssentialsProperties.AXIS) == dir.func_176740_k(); ++extension) {
        }
        this.endPos = this.field_174879_c.func_177967_a(dir, extension);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (!this.inventory.func_190926_b()) {
            nbt.func_74782_a("inv", (INBTBase)this.inventory.func_77955_b(new NBTTagCompound()));
        }
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("inv")) {
            this.inventory = ItemStack.func_199557_a((NBTTagCompound)nbt.func_74775_l("inv"));
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, EnumFacing facing) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> new InventoryHandler());
        }
        return super.getCapability(cap, facing);
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ItemShifterContainer((IInventory)playerInventory, this);
    }

    public String func_174875_k() {
        return "essentials:item_shifter";
    }

    public int func_70302_i_() {
        return 1;
    }

    public boolean func_191420_l() {
        return this.inventory.func_190926_b();
    }

    public ItemStack func_70301_a(int index) {
        return index == 0 ? this.inventory : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        this.func_70296_d();
        return index == 0 ? this.inventory.func_77979_a(count) : ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        if (index == 0) {
            ItemStack removed = this.inventory;
            this.inventory = ItemStack.field_190927_a;
            this.func_70296_d();
            return removed;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index == 0) {
            this.inventory = stack;
            this.func_70296_d();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_180425_c().func_177951_i((Vec3i)this.field_174879_c) < 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 0;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inventory = ItemStack.field_190927_a;
        this.func_70296_d();
    }

    public ITextComponent func_200200_C_() {
        return new TextComponentString("Item Shifter");
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return null;
    }

    private class InventoryHandler
    implements IItemHandler {
        private InventoryHandler() {
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return slot == 0 ? ItemShifterTileEntity.this.inventory : ItemStack.field_190927_a;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot != 0 || stack.func_190926_b() || !ItemShifterTileEntity.this.inventory.func_190926_b() && (!ItemShifterTileEntity.this.inventory.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)ItemShifterTileEntity.this.inventory, (ItemStack)stack))) {
                return stack;
            }
            int moved = Math.min(stack.func_190916_E(), stack.func_77976_d() - ItemShifterTileEntity.this.inventory.func_190916_E());
            if (!simulate && moved != 0) {
                if (ItemShifterTileEntity.this.inventory.func_190926_b()) {
                    ItemShifterTileEntity.this.inventory = stack.func_77946_l();
                    ItemShifterTileEntity.this.inventory.func_190920_e(moved);
                } else {
                    ItemShifterTileEntity.this.inventory.func_190917_f(moved);
                }
                ItemShifterTileEntity.this.func_70296_d();
            }
            ItemStack remain = stack.func_77946_l();
            remain.func_190918_g(moved);
            return remain;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot != 0 || ItemShifterTileEntity.this.inventory.func_190926_b() || amount <= 0) {
                return ItemStack.field_190927_a;
            }
            ItemStack removed = ItemShifterTileEntity.this.inventory.func_77946_l();
            removed.func_190920_e(Math.min(ItemShifterTileEntity.this.inventory.func_190916_E(), amount));
            if (!simulate) {
                ItemShifterTileEntity.this.inventory.func_190918_g(removed.func_190916_E());
                ItemShifterTileEntity.this.func_70296_d();
            }
            return removed;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }
    }
}

