/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities;

import com.Da_Technomancer.essentials.blocks.SortingHopper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerHopper;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IInteractionObject;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="essentials")
public class SortingHopperTileEntity
extends TileEntity
implements ITickable,
IInventory,
IInteractionObject {
    @ObjectHolder(value="sorting_hopper")
    private static TileEntityType<SortingHopperTileEntity> TYPE = null;
    protected final ItemStack[] inventory = new ItemStack[5];
    private int transferCooldown = -1;
    private EnumFacing dir = null;
    protected ItemHandler handler = new ItemHandler();

    protected SortingHopperTileEntity(TileEntityType<?> type) {
        super(type);
        for (int i = 0; i < 5; ++i) {
            this.inventory[i] = ItemStack.field_190927_a;
        }
    }

    public SortingHopperTileEntity() {
        this(TYPE);
    }

    public void resetCache() {
        this.dir = null;
    }

    protected EnumFacing getDir() {
        if (this.dir == null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(state.func_177230_c() instanceof SortingHopper)) {
                return EnumFacing.DOWN;
            }
            this.dir = (EnumFacing)state.func_177229_b((IProperty)SortingHopper.FACING);
        }
        return this.dir;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && --this.transferCooldown <= 0) {
            this.transferCooldown = 0;
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_177230_c() instanceof SortingHopper && ((Boolean)state.func_177229_b((IProperty)SortingHopper.ENABLED)).booleanValue()) {
                boolean flag = false;
                if (!this.isFull()) {
                    flag = this.transferItemsIn();
                }
                if (!this.func_191420_l()) {
                    boolean bl = flag = this.transferItemsOut() || flag;
                }
                if (flag) {
                    this.transferCooldown = 8;
                    this.func_70296_d();
                }
            }
        }
    }

    public ITextComponent func_200200_C_() {
        return new TextComponentTranslation("container.sorting_hopper", new Object[0]);
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.transferCooldown = nbt.func_74762_e("trans_cooldown");
        for (int i = 0; i < 5; ++i) {
            NBTTagCompound stackNBT = nbt.func_74775_l("inv_" + i);
            this.inventory[i] = ItemStack.func_199557_a((NBTTagCompound)stackNBT);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        for (int i = 0; i < 5; ++i) {
            if (this.inventory[i].func_190926_b()) continue;
            NBTTagCompound stackNBT = new NBTTagCompound();
            this.inventory[i].func_77955_b(stackNBT);
            nbt.func_74782_a("inv_" + i, (INBTBase)stackNBT);
        }
        nbt.func_74768_a("trans_cooldown", this.transferCooldown);
        return nbt;
    }

    public int func_70302_i_() {
        return 5;
    }

    public ItemStack func_70301_a(int index) {
        return index > 4 ? ItemStack.field_190927_a : this.inventory[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        if (index > 4 || this.inventory[index].func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.func_70296_d();
        return this.inventory[index].func_77979_a(count);
    }

    public ItemStack func_70304_b(int index) {
        if (index > 4) {
            return ItemStack.field_190927_a;
        }
        ItemStack copy = this.inventory[index];
        this.inventory[index] = ItemStack.field_190927_a;
        this.func_70296_d();
        return copy;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index > 4) {
            return;
        }
        this.inventory[index] = stack;
        this.func_70296_d();
        if (!stack.func_190926_b() && stack.func_190916_E() > stack.func_77976_d()) {
            stack.func_190920_e(stack.func_77976_d());
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index < 5;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    protected boolean isFull() {
        for (ItemStack itemstack : this.inventory) {
            if (!itemstack.func_190926_b() && itemstack.func_190916_E() == itemstack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    protected int transferQuantity() {
        return 1;
    }

    protected boolean transferItemsOut() {
        LazyOptional outCap;
        EnumFacing facing = this.getDir();
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
        if (te != null && (outCap = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())).isPresent()) {
            IItemHandler handler = (IItemHandler)outCap.orElseThrow(NullPointerException::new);
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                ItemStack stackInSlot = this.func_70301_a(i);
                if (stackInSlot.func_190926_b()) continue;
                ItemStack insert = stackInSlot.func_77946_l();
                insert.func_190920_e(Math.min(insert.func_190916_E(), this.transferQuantity()));
                ItemStack newStack = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)insert, (boolean)true);
                if (newStack.func_190916_E() >= insert.func_190916_E()) continue;
                ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)this.func_70298_a(i, insert.func_190916_E() - newStack.func_190916_E()), (boolean)false);
                this.func_70296_d();
                return true;
            }
        }
        return false;
    }

    protected boolean transferItemsIn() {
        LazyOptional inCap;
        TileEntity fromTE = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(EnumFacing.UP));
        if (fromTE != null && (inCap = fromTE.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN)).isPresent()) {
            IItemHandler otherHandler = (IItemHandler)inCap.orElseThrow(NullPointerException::new);
            for (int i = 0; i < otherHandler.getSlots(); ++i) {
                ItemStack extractItem = otherHandler.extractItem(i, this.transferQuantity(), true);
                if (extractItem.func_190926_b()) continue;
                for (int j = 0; j < this.func_70302_i_(); ++j) {
                    ItemStack uninserted = this.handler.insertItem(j, extractItem, false);
                    if (uninserted.func_190916_E() >= extractItem.func_190916_E()) continue;
                    otherHandler.extractItem(i, extractItem.func_190916_E() - uninserted.func_190916_E(), false);
                    return true;
                }
            }
            return false;
        }
        boolean changed = false;
        for (EntityItem entityitem : this.field_145850_b.func_175647_a(EntityItem.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)this.field_174879_c.func_177956_o() + 2.0, (double)(this.field_174879_c.func_177952_p() + 1)), EntitySelectors.field_94557_a)) {
            ItemStack stack;
            if (entityitem == null) continue;
            ItemStack remain = stack = entityitem.func_92059_d().func_77946_l();
            for (int i = 0; i < 5 && !(remain = this.handler.insertItem(i, remain, false)).func_190926_b(); ++i) {
            }
            if (remain.func_190926_b()) {
                entityitem.func_70106_y();
                changed = true;
                continue;
            }
            if (remain.func_190916_E() == stack.func_190916_E()) continue;
            entityitem.func_92058_a(remain);
            changed = true;
        }
        return changed;
    }

    protected static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_190916_E() <= stack1.func_77976_d() && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < 5; ++i) {
            this.inventory[i] = ItemStack.field_190927_a;
        }
        this.func_70296_d();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.handler);
        }
        return super.getCapability(capability, facing);
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerHopper(playerInventory, (IInventory)this, playerIn);
    }

    public String func_174875_k() {
        return "minecraft:hopper";
    }

    protected class ItemHandler
    implements IItemHandler {
        protected ItemHandler() {
        }

        public int getSlots() {
            return SortingHopperTileEntity.this.func_70302_i_();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return SortingHopperTileEntity.this.func_70301_a(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.func_190926_b() || slot > 4) {
                return ItemStack.field_190927_a;
            }
            if (SortingHopperTileEntity.this.inventory[slot].func_190926_b() || SortingHopperTileEntity.canCombine(stack, SortingHopperTileEntity.this.inventory[slot])) {
                int moved = Math.min(stack.func_190916_E(), stack.func_77976_d() - SortingHopperTileEntity.this.inventory[slot].func_190916_E());
                ItemStack remain = stack.func_77946_l();
                remain.func_190918_g(moved);
                if (!simulate && moved != 0) {
                    if (SortingHopperTileEntity.this.inventory[slot].func_190926_b()) {
                        SortingHopperTileEntity.this.inventory[slot] = stack.func_77946_l();
                        SortingHopperTileEntity.this.inventory[slot].func_190920_e(moved);
                    } else {
                        SortingHopperTileEntity.this.inventory[slot].func_190917_f(moved);
                    }
                    if (SortingHopperTileEntity.this.transferCooldown < 1) {
                        SortingHopperTileEntity.this.transferCooldown = 8;
                    }
                    SortingHopperTileEntity.this.func_70296_d();
                }
                return remain;
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            LazyOptional otherCap;
            if (amount <= 0 || slot > 4) {
                return ItemStack.field_190927_a;
            }
            EnumFacing facing = SortingHopperTileEntity.this.getDir();
            TileEntity te = SortingHopperTileEntity.this.field_145850_b.func_175625_s(SortingHopperTileEntity.this.field_174879_c.func_177972_a(facing));
            if (te != null && (otherCap = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())).isPresent()) {
                IItemHandler otherHandler = (IItemHandler)otherCap.orElseThrow(NullPointerException::new);
                int slots = otherHandler.getSlots();
                for (int i = 0; i < slots; ++i) {
                    if (otherHandler.insertItem(i, SortingHopperTileEntity.this.inventory[slot], true).func_190916_E() >= SortingHopperTileEntity.this.inventory[slot].func_190916_E()) continue;
                    return ItemStack.field_190927_a;
                }
            }
            int removed = Math.min(amount, SortingHopperTileEntity.this.inventory[slot].func_190916_E());
            if (!simulate) {
                SortingHopperTileEntity.this.func_70296_d();
                return SortingHopperTileEntity.this.inventory[slot].func_77979_a(removed);
            }
            ItemStack out = SortingHopperTileEntity.this.inventory[slot].func_77946_l();
            out.func_190920_e(removed);
            return out;
        }

        public int getSlotLimit(int slot) {
            return SortingHopperTileEntity.this.func_70297_j_();
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }
    }
}

