/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks;

import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import com.Da_Technomancer.essentials.tileentities.BrazierTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Brazier
extends ContainerBlock {
    private static final VoxelShape SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0), (VoxelShape)Block.func_208617_a((double)1.0, (double)10.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0));

    protected Brazier() {
        super(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(2.0f));
        String name = "brazier";
        this.setRegistryName(name);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)ESProperties.BRAZIER_CONTENTS, (Comparable)Integer.valueOf(0)));
        ESBlocks.toRegister.add((Block)this);
        ESBlocks.blockAddQue(this);
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new BrazierTileEntity();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public int getLightValue(BlockState state, IEnviromentBlockReader world, BlockPos pos) {
        BlockState other = world.func_180495_p(pos);
        if (other.func_177230_c() != this) {
            return other.getLightValue(world, pos);
        }
        switch ((Integer)state.func_177229_b((IProperty)ESProperties.BRAZIER_CONTENTS)) {
            case 2: 
            case 4: {
                return 15;
            }
            case 3: {
                return 14;
            }
            case 7: {
                return 3;
            }
        }
        return 0;
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        int type = (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)ESProperties.BRAZIER_CONTENTS);
        if (type == 1) {
            entityIn.func_70066_B();
        } else if (type == 2) {
            entityIn.func_70015_d(5);
        }
        super.func_176199_a(worldIn, pos, entityIn);
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        int type = (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)ESProperties.BRAZIER_CONTENTS);
        if (type != 1 && type != 2) {
            super.func_180658_a(worldIn, pos, entityIn, fallDistance);
        }
        if (type == 2 && entityIn instanceof ItemEntity) {
            entityIn.func_70106_y();
        }
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        ItemStack out;
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof BrazierTileEntity && !(out = ((BrazierTileEntity)te).useItem(playerIn.func_184586_b(hand))).equals(playerIn.func_184586_b(hand))) {
            if (!worldIn.field_72995_K) {
                playerIn.func_184611_a(hand, out);
            }
            return true;
        }
        return false;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{ESProperties.BRAZIER_CONTENTS});
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity te = worldIn.func_175625_s(pos);
            if (te instanceof BrazierTileEntity) {
                ItemStack made = ItemStack.field_190927_a;
                switch ((Integer)state.func_177229_b((IProperty)ESProperties.BRAZIER_CONTENTS)) {
                    case 3: {
                        made = new ItemStack((IItemProvider)Blocks.field_150402_ci);
                        break;
                    }
                    case 4: {
                        made = new ItemStack((IItemProvider)Blocks.field_150426_aN);
                        break;
                    }
                    case 6: {
                        made = new ItemStack((IItemProvider)Blocks.field_150425_aM);
                    }
                }
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)made);
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        tooltip.add((ITextComponent)new StringTextComponent("Able to hold Water, Lava, Glowstone, Coal Blocks, and Soul Sand"));
        tooltip.add((ITextComponent)new StringTextComponent("Can prevent fall damage with liquid, emit light with Glowstone/Coal/Lava, destroy dropped items with Lava, or blocks witch spawns with Soul Sand"));
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

