/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.blocks;

import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.ReflectionUtil;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.ToolType;

public class FertileSoil
extends Block {
    private final BlockState plant;

    protected FertileSoil(String plantName, BlockState plant) {
        super(Block.Properties.func_200945_a((Material)(plant.func_177230_c() == Blocks.field_150388_bm ? Material.field_151595_p : Material.field_151578_c)).func_200943_b(0.5f).func_200947_a(SoundType.field_185849_b).func_200944_c());
        this.plant = plant;
        String name = "fertile_soil_" + plantName;
        this.setRegistryName(name);
        ESBlocks.toRegister.add(this);
        ESBlocks.blockAddQue(this);
    }

    public List<ItemStack> func_220076_a(BlockState p_220076_1_, LootContext.Builder p_220076_2_) {
        return super.func_220076_a(p_220076_1_, p_220076_2_);
    }

    public boolean isToolEffective(BlockState state, ToolType tool) {
        return tool == ToolType.SHOVEL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.essentials.fertile_soil.desc", new Object[0]));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.essentials.fertile_soil.benefits", new Object[0]));
        if (this.plant.func_177230_c() == Blocks.field_150388_bm) {
            tooltip.add(new TranslationTextComponent("tt.essentials.fertile_soil.quip", new Object[0]).func_150255_a(ESConfig.TT_QUIP));
        }
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction direction, IPlantable plantable) {
        String name;
        StackTraceElement[] stack;
        if (this.plant.func_177230_c() == Blocks.field_196675_u && (stack = Thread.currentThread().getStackTrace()).length > 7 && ((name = stack[6].getMethodName()).equals(ReflectionUtil.EsReflection.PODZOL_GEN.mcp) || name.equals(ReflectionUtil.EsReflection.PODZOL_GEN.obf) || (name = stack[7].getMethodName()).equals(ReflectionUtil.EsReflection.PODZOL_GEN.mcp) || name.equals(ReflectionUtil.EsReflection.PODZOL_GEN.obf))) {
            return false;
        }
        return this.plant.func_177230_c() == plantable;
    }

    public boolean isFertile(BlockState state, IBlockReader world, BlockPos pos) {
        return true;
    }

    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        if (worldIn.field_72995_K) {
            return;
        }
        if ((Double)ESConfig.fertileSoilRate.get() < 100.0 * Math.random()) {
            return;
        }
        BlockPos upPos = pos.func_177972_a(Direction.UP);
        if (worldIn.func_175623_d(upPos)) {
            worldIn.func_175656_a(upPos, this.plant);
        }
    }
}

