/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.gui.container;

import com.Da_Technomancer.essentials.gui.container.IFluidSlotTE;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class FluidSlotManager {
    private static BiMap<ResourceLocation, Short> fluidIDs = null;
    private final int capacity;
    private int fluidId;
    private int fluidQty;
    private int windowXStart;
    private int windowYStart;
    private int xPos;
    private int yPos;
    private IntReferenceHolder idRef;
    private IntReferenceHolder qtyRef;
    private static final int MAX_HEIGHT = 48;
    private static final ResourceLocation OVERLAY = new ResourceLocation("essentials", "textures/gui/rectangle_fluid_overlay.png");

    private static BiMap<ResourceLocation, Short> getFluidMap() {
        if (fluidIDs == null) {
            fluidIDs = HashBiMap.create((int)ForgeRegistries.FLUIDS.getKeys().size());
            short[] value = new short[]{0};
            ForgeRegistries.FLUIDS.getKeys().stream().sorted(ResourceLocation::compareTo).forEach(key -> {
                short s = value[0];
                value[0] = (short)(s + 1);
                Short cfr_ignored_0 = (Short)fluidIDs.put(key, (Object)s);
            });
        }
        return fluidIDs;
    }

    public FluidSlotManager(FluidStack init, int capacity) {
        this.capacity = capacity;
        this.fluidId = ((Short)FluidSlotManager.getFluidMap().getOrDefault((Object)init.getFluid().getRegistryName(), (Object)0)).shortValue();
        this.fluidQty = init.getAmount() - Short.MAX_VALUE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initScreen(int windowXStart, int windowYStart, int xPos, int yPos, IntReferenceHolder idRef, IntReferenceHolder qtyRef) {
        this.windowXStart = windowXStart;
        this.windowYStart = windowYStart;
        this.xPos = xPos;
        this.yPos = yPos;
        this.idRef = idRef;
        this.qtyRef = qtyRef;
    }

    public int getFluidId() {
        return this.fluidId;
    }

    public int getFluidQty() {
        return this.fluidQty;
    }

    public void updateState(FluidStack newFluid) {
        this.fluidId = ((Short)FluidSlotManager.getFluidMap().getOrDefault((Object)newFluid.getFluid().getRegistryName(), (Object)0)).shortValue();
        this.fluidQty = newFluid.getAmount() - Short.MAX_VALUE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public FluidStack getStack() {
        Fluid f = (Fluid)ForgeRegistries.FLUIDS.getValue((ResourceLocation)FluidSlotManager.getFluidMap().inverse().getOrDefault((Object)((short)this.idRef.func_221495_b()), (Object)Fluids.field_204546_a.getRegistryName()));
        if (f == null) {
            f = Fluids.field_204546_a;
        }
        return new FluidStack(f, this.qtyRef.func_221495_b() + Short.MAX_VALUE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderBack(float partialTicks, int mouseX, int mouseY, FontRenderer fontRenderer) {
        FluidStack clientState = this.getStack();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        Screen.fill((int)(this.xPos + this.windowXStart), (int)(this.yPos + this.windowYStart - 48), (int)(this.xPos + this.windowXStart + 16), (int)(this.yPos + this.windowYStart), (int)-6974059);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FluidAttributes attr = clientState.getFluid().getAttributes();
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_195424_a(attr.getStillTexture());
        int col = attr.getColor(clientState);
        int height = (int)(48.0f * (float)clientState.getAmount() / (float)this.capacity);
        GlStateManager.color3f((float)((float)(col >>> 16 & 0xFF) / 255.0f), (float)((float)(col >>> 8 & 0xFF) / 255.0f), (float)((float)(col & 0xFF) / 255.0f));
        Screen.blit((int)(this.xPos + this.windowXStart), (int)(this.yPos + this.windowYStart - height), (int)0, (int)16, (int)height, (TextureAtlasSprite)sprite);
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderFore(int mouseX, int mouseY, FontRenderer fontRenderer, List<String> tooltip) {
        FluidStack clientState = this.getStack();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(OVERLAY);
        Screen.blit((int)this.xPos, (int)(this.yPos - 48), (float)0.0f, (float)0.0f, (int)16, (int)48, (int)16, (int)48);
        if (mouseX >= this.xPos + this.windowXStart && mouseX <= this.xPos + this.windowXStart + 16 && mouseY >= this.yPos + this.windowYStart - 48 && mouseY <= this.yPos + this.windowYStart) {
            if (clientState.isEmpty()) {
                tooltip.add(new TranslationTextComponent("tt.essentials.empty_fluid", new Object[0]).func_150254_d());
            } else {
                tooltip.add(clientState.getDisplayName().func_150254_d());
                tooltip.add(clientState.getAmount() + "/" + this.capacity);
            }
        }
    }

    public static Pair<Slot, Slot> createFluidSlots(IInventory inv, int startIndex, int inXPos, int inYPos, int outXPos, int outYPos, @Nullable IFluidSlotTE te, int[] fluidIndex) {
        InSlot in = new InSlot(inv, startIndex + 1, inXPos, inYPos, startIndex, te, fluidIndex);
        OutSlot out = new OutSlot(inv, startIndex, outXPos, outYPos, in);
        return Pair.of((Object)((Object)out), (Object)((Object)in));
    }

    public static class FakeInventory
    implements IInventory {
        private final Container container;
        private final ItemStack[] stacks = new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a};

        public FakeInventory(Container cont) {
            this.container = cont;
        }

        public int func_70302_i_() {
            return 2;
        }

        public boolean func_191420_l() {
            return this.stacks[0].func_190926_b() && this.stacks[1].func_190926_b();
        }

        public ItemStack func_70301_a(int index) {
            return this.stacks[index];
        }

        public ItemStack func_70298_a(int index, int count) {
            this.func_70296_d();
            return this.stacks[index].func_77979_a(count);
        }

        public ItemStack func_70304_b(int index) {
            ItemStack stack = this.stacks[index];
            this.stacks[index] = ItemStack.field_190927_a;
            this.func_70296_d();
            return stack;
        }

        public void func_70299_a(int index, ItemStack stack) {
            this.stacks[index] = stack;
            this.func_70296_d();
        }

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
            this.container.func_75142_b();
        }

        public boolean func_70300_a(PlayerEntity player) {
            return true;
        }

        public boolean func_94041_b(int index, ItemStack stack) {
            return index == 0 && stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent();
        }

        public void func_174888_l() {
            this.stacks[0] = ItemStack.field_190927_a;
            this.stacks[1] = ItemStack.field_190927_a;
            this.func_70296_d();
        }
    }

    private static class InSlot
    extends Slot {
        private final int outSlotIndex;
        @Nullable
        private final IFluidSlotTE te;
        private final int[] fluidIndices;
        private boolean internalChange = false;

        private InSlot(IInventory inventoryIn, int index, int xPosition, int yPosition, int outSlotIndex, @Nullable IFluidSlotTE te, int[] fluidIndices) {
            super(inventoryIn, index, xPosition, yPosition);
            this.outSlotIndex = outSlotIndex;
            this.te = te;
            this.fluidIndices = fluidIndices;
        }

        public boolean func_75214_a(ItemStack stack) {
            return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent();
        }

        public int func_75219_a() {
            return 1;
        }

        public void func_75218_e() {
            super.func_75218_e();
            ItemStack stack = this.func_75211_c();
            if (!this.internalChange && this.te != null && this.func_75214_a(stack) && this.field_75224_c.func_70301_a(this.outSlotIndex).func_190926_b()) {
                LazyOptional opt = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
                IFluidHandler handler = this.te.getFluidHandler();
                if (opt.isPresent()) {
                    IFluidHandlerItem itHandler = (IFluidHandlerItem)opt.orElseThrow(NullPointerException::new);
                    for (int fluidIndex : this.fluidIndices) {
                        int maxDrain = handler.getTankCapacity(fluidIndex) - handler.getFluidInTank(fluidIndex).getAmount();
                        FluidStack drained = itHandler.drain(maxDrain, IFluidHandler.FluidAction.SIMULATE);
                        if (handler.isFluidValid(fluidIndex, drained) && (maxDrain = handler.fill(drained, IFluidHandler.FluidAction.EXECUTE)) != 0) {
                            itHandler.drain(drained, IFluidHandler.FluidAction.EXECUTE);
                            this.field_75224_c.func_70299_a(this.outSlotIndex, itHandler.getContainer());
                            this.internalChange = true;
                            this.field_75224_c.func_70299_a(this.getSlotIndex(), ItemStack.field_190927_a);
                            this.internalChange = false;
                            this.field_75224_c.func_70296_d();
                            return;
                        }
                        FluidStack filled = handler.drain(0x3FFFFFFF, IFluidHandler.FluidAction.SIMULATE);
                        int filledQty = itHandler.fill(filled, IFluidHandler.FluidAction.EXECUTE);
                        if (filledQty == 0) continue;
                        filled.setAmount(filledQty);
                        handler.drain(filled, IFluidHandler.FluidAction.EXECUTE);
                        this.field_75224_c.func_70299_a(this.outSlotIndex, itHandler.getContainer());
                        this.internalChange = true;
                        this.field_75224_c.func_70299_a(this.getSlotIndex(), ItemStack.field_190927_a);
                        this.internalChange = false;
                        return;
                    }
                }
            }
        }
    }

    private static class OutSlot
    extends Slot {
        private final InSlot inSlot;

        private OutSlot(IInventory inventoryIn, int index, int xPosition, int yPosition, InSlot inSlot) {
            super(inventoryIn, index, xPosition, yPosition);
            this.inSlot = inSlot;
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        public int func_75219_a() {
            return 1;
        }

        public ItemStack func_190901_a(PlayerEntity p_190901_1_, ItemStack p_190901_2_) {
            ItemStack s = super.func_190901_a(p_190901_1_, p_190901_2_);
            this.inSlot.func_75218_e();
            return s;
        }
    }
}

