/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.items;

import com.Da_Technomancer.essentials.Essentials;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import com.Da_Technomancer.essentials.blocks.redstone.AbstractCircuit;
import com.Da_Technomancer.essentials.blocks.redstone.AbstractTile;
import com.Da_Technomancer.essentials.gui.container.CircuitWrenchContainer;
import com.Da_Technomancer.essentials.items.ESItems;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class CircuitWrench
extends Item {
    public static final ArrayList<AbstractTile> MODES = new ArrayList(32);
    public static final ArrayList<ResourceLocation> ICONS = new ArrayList(32);
    public static final String NBT_KEY = "essentials:mode";
    private static final Tag<Item> COMPONENT_TAG = new ItemTags.Wrapper(new ResourceLocation("essentials", "circuit_components"));
    private static final Style style;

    public static void registerCircuit(@Nonnull AbstractTile toRegister, @Nullable ResourceLocation icon) {
        if (!MODES.contains(toRegister)) {
            MODES.add(toRegister);
            ICONS.add(icon);
        } else {
            Essentials.logger.info("Redundant circuit registration: " + toRegister.getRegistryName());
        }
    }

    protected CircuitWrench() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ESItems.TAB_ESSENTIALS));
        String name = "circuit_wrench";
        this.setRegistryName(name);
        ESItems.toRegister.add(this);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn.func_70093_af()) {
            if (!worldIn.field_72995_K) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)UIProvider.INSTANCE);
            }
            return ActionResult.newResult((ActionResultType)ActionResultType.SUCCESS, (Object)stack);
        }
        return ActionResult.newResult((ActionResultType)ActionResultType.SUCCESS, (Object)stack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockState state = context.func_195991_k().func_180495_p(context.func_195995_a());
        BlockState toPlace = MODES.get(context.func_195996_i().func_196082_o().func_74762_e(NBT_KEY) % MODES.size()).func_176223_P();
        if (!context.func_195999_j().func_70093_af() && state.func_177230_c() instanceof AbstractTile) {
            if (state.func_177230_c() == toPlace.func_177230_c()) {
                return ActionResultType.SUCCESS;
            }
            boolean allowed = false;
            if (context.func_195999_j().func_184812_l_()) {
                allowed = true;
            } else if (toPlace.func_177230_c() instanceof AbstractCircuit) {
                if (state.func_177230_c() instanceof AbstractCircuit) {
                    allowed = true;
                } else {
                    NonNullList playerInv = context.func_195999_j().field_71071_by.field_70462_a;
                    for (ItemStack stack : playerInv) {
                        if (!COMPONENT_TAG.func_199685_a_((Object)stack.func_77973_b())) continue;
                        if (!context.func_195991_k().field_72995_K) {
                            stack.func_190918_g(1);
                        }
                        allowed = true;
                        break;
                    }
                }
            } else {
                ItemStack given;
                allowed = true;
                if (state.func_177230_c() instanceof AbstractCircuit && !(given = new ItemStack((IItemProvider)COMPONENT_TAG.func_205596_a(context.func_195991_k().field_73012_v), 1)).func_190926_b()) {
                    context.func_195999_j().func_191521_c(given);
                }
            }
            if (allowed) {
                if (toPlace.func_196959_b((IProperty)ESProperties.HORIZ_FACING)) {
                    toPlace = state.func_196959_b((IProperty)ESProperties.HORIZ_FACING) ? (BlockState)toPlace.func_206870_a((IProperty)ESProperties.HORIZ_FACING, (Comparable)((Direction)state.func_177229_b((IProperty)ESProperties.HORIZ_FACING))) : (BlockState)toPlace.func_206870_a((IProperty)ESProperties.HORIZ_FACING, (Comparable)context.func_195999_j().func_184172_bi());
                }
                context.func_195991_k().func_175656_a(context.func_195995_a(), toPlace);
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        int mode = stack.func_196082_o().func_74762_e(NBT_KEY) % MODES.size();
        tooltip.add(new TranslationTextComponent("tt.essentials.circuit_wrench_setting", new Object[0]).func_150255_a(style).func_150257_a((ITextComponent)new TranslationTextComponent(MODES.get(mode).func_149739_a(), new Object[0])));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.essentials.circuit_wrench_info", new Object[0]));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.essentials.circuit_wrench_change_mode", new Object[0]));
    }

    static {
        CircuitWrench.registerCircuit(ESBlocks.wireCircuit, new ResourceLocation("essentials", "textures/gui/circuit/wire.png"));
        CircuitWrench.registerCircuit(ESBlocks.wireJunctionCircuit, new ResourceLocation("essentials", "textures/gui/circuit/wire_junction.png"));
        CircuitWrench.registerCircuit(ESBlocks.interfaceCircuit, new ResourceLocation("essentials", "textures/gui/circuit/interface.png"));
        CircuitWrench.registerCircuit(ESBlocks.consCircuit, new ResourceLocation("essentials", "textures/gui/circuit/constant.png"));
        CircuitWrench.registerCircuit(ESBlocks.notCircuit, new ResourceLocation("essentials", "textures/gui/circuit/not.png"));
        CircuitWrench.registerCircuit(ESBlocks.andCircuit, new ResourceLocation("essentials", "textures/gui/circuit/and.png"));
        CircuitWrench.registerCircuit(ESBlocks.orCircuit, new ResourceLocation("essentials", "textures/gui/circuit/or.png"));
        CircuitWrench.registerCircuit(ESBlocks.xorCircuit, new ResourceLocation("essentials", "textures/gui/circuit/xor.png"));
        CircuitWrench.registerCircuit(ESBlocks.readerCircuit, new ResourceLocation("essentials", "textures/gui/circuit/reader.png"));
        CircuitWrench.registerCircuit(ESBlocks.sumCircuit, new ResourceLocation("essentials", "textures/gui/circuit/sum.png"));
        CircuitWrench.registerCircuit(ESBlocks.difCircuit, new ResourceLocation("essentials", "textures/gui/circuit/dif.png"));
        CircuitWrench.registerCircuit(ESBlocks.prodCircuit, new ResourceLocation("essentials", "textures/gui/circuit/prod.png"));
        CircuitWrench.registerCircuit(ESBlocks.quotCircuit, new ResourceLocation("essentials", "textures/gui/circuit/quot.png"));
        CircuitWrench.registerCircuit(ESBlocks.invCircuit, new ResourceLocation("essentials", "textures/gui/circuit/inv.png"));
        CircuitWrench.registerCircuit(ESBlocks.moduloCircuit, new ResourceLocation("essentials", "textures/gui/circuit/modulo.png"));
        CircuitWrench.registerCircuit(ESBlocks.powCircuit, new ResourceLocation("essentials", "textures/gui/circuit/pow.png"));
        CircuitWrench.registerCircuit(ESBlocks.logCircuit, new ResourceLocation("essentials", "textures/gui/circuit/log.png"));
        CircuitWrench.registerCircuit(ESBlocks.sinCircuit, new ResourceLocation("essentials", "textures/gui/circuit/sin.png"));
        CircuitWrench.registerCircuit(ESBlocks.cosCircuit, new ResourceLocation("essentials", "textures/gui/circuit/cos.png"));
        CircuitWrench.registerCircuit(ESBlocks.tanCircuit, new ResourceLocation("essentials", "textures/gui/circuit/tan.png"));
        CircuitWrench.registerCircuit(ESBlocks.asinCircuit, new ResourceLocation("essentials", "textures/gui/circuit/asin.png"));
        CircuitWrench.registerCircuit(ESBlocks.acosCircuit, new ResourceLocation("essentials", "textures/gui/circuit/acos.png"));
        CircuitWrench.registerCircuit(ESBlocks.atanCircuit, new ResourceLocation("essentials", "textures/gui/circuit/atan.png"));
        CircuitWrench.registerCircuit(ESBlocks.maxCircuit, new ResourceLocation("essentials", "textures/gui/circuit/max.png"));
        CircuitWrench.registerCircuit(ESBlocks.minCircuit, new ResourceLocation("essentials", "textures/gui/circuit/min.png"));
        CircuitWrench.registerCircuit(ESBlocks.roundCircuit, new ResourceLocation("essentials", "textures/gui/circuit/round.png"));
        CircuitWrench.registerCircuit(ESBlocks.floorCircuit, new ResourceLocation("essentials", "textures/gui/circuit/floor.png"));
        CircuitWrench.registerCircuit(ESBlocks.ceilCircuit, new ResourceLocation("essentials", "textures/gui/circuit/ceil.png"));
        CircuitWrench.registerCircuit(ESBlocks.equalsCircuit, new ResourceLocation("essentials", "textures/gui/circuit/equals.png"));
        CircuitWrench.registerCircuit(ESBlocks.lessCircuit, new ResourceLocation("essentials", "textures/gui/circuit/less.png"));
        CircuitWrench.registerCircuit(ESBlocks.moreCircuit, new ResourceLocation("essentials", "textures/gui/circuit/more.png"));
        style = new Style().func_150238_a(TextFormatting.DARK_RED);
    }

    private static class UIProvider
    implements INamedContainerProvider {
        private static final UIProvider INSTANCE = new UIProvider();

        private UIProvider() {
        }

        @Nullable
        public Container createMenu(int menuId, PlayerInventory playerInv, PlayerEntity player) {
            return new CircuitWrenchContainer(menuId, playerInv, null);
        }

        public ITextComponent func_145748_c_() {
            return new TranslationTextComponent("container.circuit_wrench", new Object[0]);
        }
    }
}

