/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.gui;

import com.Da_Technomancer.essentials.gui.container.AutoCrafterContainer;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.recipebook.IRecipeShownListener;
import net.minecraft.client.gui.recipebook.RecipeBookGui;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.RecipeBookCategories;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.RecipeBookContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.crafting.IShapedRecipe;

public class AutoCrafterScreen
extends ContainerScreen<AutoCrafterContainer>
implements IRecipeShownListener {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("essentials", "textures/gui/auto_crafter.png");
    private static final ResourceLocation RECIPE_BUTTON_TEXTURE = new ResourceLocation("textures/gui/recipe_button.png");
    private final RecipeBookGui recipeBook = new RecipeBookGui();
    private boolean widthTooNarrow;
    private float time = 0.0f;

    public AutoCrafterScreen(AutoCrafterContainer cont, PlayerInventory playerInventory, ITextComponent text) {
        super((Container)cont, playerInventory, text);
        this.field_147000_g = 186;
    }

    protected void init() {
        super.init();
        this.widthTooNarrow = this.width < 379;
        this.recipeBook.func_201520_a(this.width, this.height, Minecraft.func_71410_x(), this.widthTooNarrow, (RecipeBookContainer)this.field_147002_h);
        this.field_147003_i = this.recipeBook.func_193011_a(this.widthTooNarrow, this.width, this.field_146999_f);
        this.children.add(this.recipeBook);
        this.func_212928_a((IGuiEventListener)this.recipeBook);
        this.addButton((Widget)new ImageButton(this.field_147003_i + 5, this.height / 2 - 49, 20, 18, 0, 0, 19, RECIPE_BUTTON_TEXTURE, p_214076_1_ -> {
            this.recipeBook.func_201518_a(this.widthTooNarrow);
            this.recipeBook.func_191866_a();
            this.field_147003_i = this.recipeBook.func_193011_a(this.widthTooNarrow, this.width, this.field_146999_f);
            ((ImageButton)p_214076_1_).func_191746_c(this.field_147003_i + 5, this.height / 2 - 49);
        }));
    }

    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        this.time += p_render_3_;
        this.renderBackground();
        if (this.recipeBook.func_191878_b() && this.widthTooNarrow) {
            this.func_146976_a(p_render_3_, p_render_1_, p_render_2_);
            this.recipeBook.render(p_render_1_, p_render_2_, p_render_3_);
        } else {
            this.recipeBook.render(p_render_1_, p_render_2_, p_render_3_);
            super.render(p_render_1_, p_render_2_, p_render_3_);
            this.recipeBook.func_191864_a(this.field_147003_i, this.field_147009_r, true, p_render_3_);
        }
        this.func_191948_b(p_render_1_, p_render_2_);
        this.recipeBook.func_191876_c(this.field_147003_i, this.field_147009_r, p_render_1_, p_render_2_);
        this.func_212932_b((IGuiEventListener)this.recipeBook);
    }

    protected boolean func_195359_a(int p_195359_1_, int p_195359_2_, int p_195359_3_, int p_195359_4_, double p_195359_5_, double p_195359_7_) {
        return (!this.widthTooNarrow || !this.recipeBook.func_191878_b()) && super.func_195359_a(p_195359_1_, p_195359_2_, p_195359_3_, p_195359_4_, p_195359_5_, p_195359_7_);
    }

    public boolean mouseClicked(double x, double y, int p_mouseClicked_5_) {
        if (this.recipeBook.mouseClicked(x, y, p_mouseClicked_5_)) {
            return true;
        }
        return this.widthTooNarrow && this.recipeBook.func_191878_b() || super.mouseClicked(x, y, p_mouseClicked_5_);
    }

    protected boolean func_195361_a(double p_195361_1_, double p_195361_3_, int p_195361_5_, int p_195361_6_, int p_195361_7_) {
        boolean flag = p_195361_1_ < (double)p_195361_5_ || p_195361_3_ < (double)p_195361_6_ || p_195361_1_ >= (double)(p_195361_5_ + this.field_146999_f) || p_195361_3_ >= (double)(p_195361_6_ + this.field_147000_g);
        return this.recipeBook.func_195604_a(p_195361_1_, p_195361_3_, this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g, p_195361_7_) && flag;
    }

    protected void func_184098_a(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        super.func_184098_a(slotIn, slotId, mouseButton, type);
        this.recipeBook.func_191874_a(slotIn);
    }

    public void func_192043_J_() {
        this.recipeBook.func_193948_e();
    }

    public void removed() {
        this.recipeBook.func_191871_c();
        super.removed();
    }

    public RecipeBookGui func_194310_f() {
        return this.recipeBook;
    }

    public void tick() {
        super.tick();
        this.recipeBook.func_193957_d();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.font.func_211126_b(this.title.func_150254_d(), 8.0f, 6.0f, 0x404040);
        this.font.func_211126_b(this.field_213127_e.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 94), 0x404040);
        if (((AutoCrafterContainer)this.field_147002_h).te == null) {
            return;
        }
        ItemStack[] inv = new ItemStack[19];
        for (int i = 10; i < 19; ++i) {
            inv[i] = ((AutoCrafterContainer)this.field_147002_h).func_75139_a(i).func_75211_c();
        }
        IRecipe<CraftingInventory> iRecipe = ((AutoCrafterContainer)this.field_147002_h).te.findRecipe(inv);
        if (iRecipe != null) {
            RenderSystem.enableRescaleNormal();
            RenderHelper.func_227780_a_();
            if (((AutoCrafterContainer)this.field_147002_h).te.recipe != null) {
                boolean shaped = iRecipe instanceof IShapedRecipe;
                int width = 3;
                if (shaped) {
                    width = ((IShapedRecipe)iRecipe).getRecipeWidth();
                }
                NonNullList ingredients = iRecipe.func_192400_c();
                for (int i = 0; i < ingredients.size(); ++i) {
                    ItemStack[] matching = ((Ingredient)ingredients.get(i)).func_193365_a();
                    if (matching.length == 0) continue;
                    ItemStack s = matching[(int)Math.floor(this.time / 30.0f) % matching.length];
                    this.itemRenderer.func_175042_a(s, 44 + 18 * (i % width), 15 + 18 * (i / width));
                }
            }
            ItemStack output = iRecipe.func_77571_b();
            this.itemRenderer.func_175042_a(output, 106, 33);
            if (output.func_190916_E() > 1) {
                this.itemRenderer.func_180453_a(this.font, output, 106, 33, null);
            }
            RenderSystem.disableRescaleNormal();
            RenderHelper.func_74518_a();
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.minecraft.func_110434_K().func_110577_a(GUI_TEXTURE);
        this.blit(this.field_147003_i, (this.height - this.field_147000_g) / 2, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public static List<RecipeBookCategories> getRecipeCategories() {
        return Lists.newArrayList((Object[])new RecipeBookCategories[]{RecipeBookCategories.SEARCH, RecipeBookCategories.EQUIPMENT, RecipeBookCategories.BUILDING_BLOCKS, RecipeBookCategories.MISC, RecipeBookCategories.REDSTONE});
    }
}

